import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PolyVector {
    Vector[] V=new Vector[10];
    int count,radius,orbit;

    public PolyVector() {
	for(int i=0;i<9;++i) 
	    V[i]=new Vector();
    }





    public PolyVector(PolyVector Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.V[i]=Q.V[i];
    }

    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.V[i]=V[i].normalize();
	}
	return(P);
    }




    public static  PolyVector makePoly(Complex z,Quad Q0,int i) {
	PolyWedge TEMP=PolyWedge.makeWedge(z,Q0,i);
        PolyVector V=new PolyVector(TEMP);
        return(V);
    }


    public PolyVector(PolyWedge Q) {
	this.count=Q.count;
	this.orbit=Q.orbit;
	this.radius=Q.radius;
	for(int i=0;i<Q.count;++i) {
            this.V[i]=new Vector(Q.z[i]);
	}
    }

    public PolyVector(Quad Q) {
	this.count=4;
	for(int i=0;i<4;++i) {
            this.V[i]=new Vector(Q.z[i]);
	}
    }

    /**we are assuming that the tiles are at most 100 times the
       size of the initial quad*/


    public  PolyWedge toPolyWedge() {
	PolyWedge Q=new PolyWedge();
	Q.count=this.count;
	Q.orbit=this.orbit;
	Q.radius=this.radius;
	for(int i=0;i<count;++i) Q.z[i]=V[i].toComplex();
	return(Q);
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(V[0].x[0]/V[0].x[2]),(float)(V[0].x[1]/V[0].x[2]));
	for(int i=0;i<count;++i) {
	gp.moveTo((float)(V[i].x[0]/V[i].x[2]),(float)(V[i].x[1]/V[i].x[2]));
	}
	gp.closePath();
	return(gp);
    }



    public Vector getCenter() {
	double x=0;
	double y=0;
	for(int i=0;i<count;++i) {
	    x=x+V[i].x[0]/(count*V[i].x[2]);
	    y=y+V[i].x[1]/(count*V[i].x[2]);
	}
	Vector V=new Vector();
	V.x[0]=x;
	V.x[1]=y;
	V.x[2]=1;
	return(V);
    }


    public static PolyVector bigSquare(Complex z) {
	PolyVector P=new PolyVector();
	P.count=4;
	P.V[0]=new Vector(z.x+2,z.y-2);
	P.V[1]=new Vector(z.x+2,z.y+2);
	P.V[2]=new Vector(z.x-2,z.y+2);
	P.V[3]=new Vector(z.x-2,z.y-2);
	return(P);
    }


    public int inside(Vector W) {
	int i1,i2,i3;
	double o1,o2;
	for(int i=0;i<count;++i) {
	    i1=(i+0)%count;
	    i2=(i+1)%count;
	    i3=(i+2)%count;
	    o1=Vector.tripleProduct(V[i1],V[i2],W);
	    o2=Vector.tripleProduct(V[i2],V[i3],W);
	    if(o1*o2<0) return(0);
	}
	return(1);
    }




}

