import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

import java.awt.geom.*;


public class PolyWedge {
    Complex[] z=new Complex[10];
    int count,radius,orbit;
    int history;
    int X,Y,T;

    public PolyWedge() {}

    public PolyWedge(Complex z0,Complex z1,Complex z2) {
    this.count=3;
    this.z[0]=z0;
    this.z[1]=z1;
    this.z[2]=z2;
    }

    public PolyWedge(PolyWedge Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.z[i]=Q.z[i];
	this.X=Q.X;
	this.Y=Q.Y;
	this.T=Q.T;
    }



    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	for(int i=0;i<count;++i) {
	    gp.lineTo((float)(z[i].x),(float)(z[i].y));
	}
	gp.closePath();
	return(gp);
    }



    public Complex findIntersect(Complex z1,Complex z2,double y) {
	Complex z3=new Complex(0,y);
	Complex z4=new Complex(10000,y);
	Complex z5=Vector.findCross2(z1,z2,z3,z4);
	return(z5);
    }


    public double dec(double x) {
	return(x-Math.floor(x+.5));
    }

    public PolyWedge toFundamentalDomain() {
	PolyWedge P=new PolyWedge();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.z[i]=new Complex(dec(z[i].x),dec(z[i].y));
	}
	return(P);
    }



    public PolyWedge rotate(int k) {
	PolyWedge P=new PolyWedge();
	P.count=this.count;
	for(int i=0;i<P.count;++i) {
	    P.z[i]=this.z[(i+k)%P.count];
	}
	return(P);
    }


    public int recognizeRhombus() {
	double d1,d2;
	int i1,i2,i3;
	for(int i=0;i<4;++i) {
	    i1=(i+0)%4;
	    i2=(i+1)%4;
	    i3=(i+2)%4;
	    d1=Complex.dist(z[i1],z[i2]);
	    d2=Complex.dist(z[i2],z[i3]);
	    if(Math.abs(d1-d2)>.000001) return(0);
	}
	return(1);
    }


    public static PolyWedge  makeWedge(Complex z,Quad Q0,int i) {
	Quad Q1=Q0.rotate(i);
	Complex z0=Q0.z[i];
	int i1=(i+1)%4;
	int i2=(i+3)%4;
	double d=10*Complex.dist(z,Q0.z[i])+1000;
	//double d=10000000.0;
	Complex z1=Complex.minus(Q0.z[i1],z0);
	Complex z2=Complex.minus(Q1.z[i2],z0);
	z1=z1.unit();
	z2=z2.unit();
	z1=Complex.plus(z0,new Complex(d*z1.x,d*z1.y));
	z2=Complex.plus(z0,new Complex(d*z2.x,d*z2.y));
	return(new PolyWedge(z0,z1,z2));
    }


    public void print() {
	System.out.println("PolyWedge");
	for(int i=0;i<count;++i) z[i].print();
    }



    public Complex getCenter() {
	double x=0;
	double y=0;
	for(int i=0;i<count;++i) {
	    x=x+z[i].x/count;
	    y=y+z[i].y/count;
	}
	return(new Complex(x,y));
    }

    /**A return of 1 means that the polygon is close enough to the origin*/

    public int isWithinRange(double dx,double dy) {
    double xmin=+1000000;
    double xmax=-1000000;
    double ymin=+1000000;
    double ymax=-1000000;
    for(int i=0;i<count;++i) {
	if(xmin>z[i].x) xmin=z[i].x;
	if(xmax<z[i].x) xmax=z[i].x;
	if(ymin>z[i].y) ymin=z[i].y;
	if(ymax<z[i].y) ymax=z[i].y;
    }
    if(xmin>dx) return(0);
    if(ymin>dy) return(0);
    if(xmax<-dx) return(0);
    if(ymax<-dy) return(0);
    return(1);
    }



    public double relativeDistance(Quad Q) {
	Complex z=this.getCenter();
	double d=z.norm()/Q.z[2].x;
	return(d);
    }




    public int crossPositiveHorizontal(double y,double shift) {
    double ymin=+1000000;
    double ymax=-1000000;
    for(int i=0;i<count;++i) {
	if(ymin>z[i].y) ymin=z[i].y;
	if(ymax<z[i].y) ymax=z[i].y;
    }
    if(ymin>y+.00001) return(0);
    if(ymax<y-.00001) return(0);
    Complex z=getCenter();
    if(z.x<shift) return(0);
    return(1);
    }





    public Complex pointOnBoundary(double y) {
	Complex z=getCenter();
	z.y=y;
	return(z);
    }


    public int hitsStrip() {
	Complex zz=getCenter();
	if(zz.x<0) return(0);
        for(int i=0;i<count;++i) {
   	  if(Math.abs(z[i].y)<1+.000001) return(1);
	}
        return(0);
    }


    public PolyWedge shrinkSlightly(double d) {
	PolyWedge P=new PolyWedge();
	P.count=count;
	Complex Z=getCenter();
	for(int i=0;i<count;++i) {
	    P.z[i]=new Complex(d*Z.x+(1-d)*z[i].x,d*Z.y+(1-d)*z[i].y);
	}
	return(P);
    }




    public static int doTheyIntersect(PolyWedge Q1,PolyWedge Q2) {
	return(doTheyIntersect(Q1,Q2,.0001));
    }


    public static int doTheyIntersect(PolyWedge Q1,PolyWedge Q2,double tol) {
	PolyVector P1=new PolyVector(Q1.shrinkSlightly(tol));
	PolyVector P2=new PolyVector(Q2.shrinkSlightly(tol));
	return(PolygonIntersector.doTheyIntersect(P1,P2));
    }


    public static int isSubset(PolyWedge Q1,PolyWedge Q2) {
	Q1.print();
	Q2.print();
	PolyWedge P1=new PolyWedge(Q1);
	P1.shrinkSlightly(.00001);
	GeneralPath gp=Q2.toGeneralPath();
	for(int i=0;i<P1.count;++i) {
	    if(gp.contains(P1.z[i].x,P1.z[i].y)==false) return(0);
	}
	return(1);
    }





    PolyWedge inflate(double d) {
	PolyWedge P=new PolyWedge();
	P.count=count;
	for(int i=0;i<count;++i)
	    P.z[i]=new Complex(d*z[i].x,d*z[i].y);
	return(P);
    }


    public double  edgeMin() {
	double d=0;
	double test;
	for(int i=0;i<count;++i) {
	    int i1=i;
	    int i2=(i+1)%count;
	    test=Complex.dist(z[i1],z[i2]);
	    if(d<test) d=test;
	}
	return(d);
    }

    public PolyWedge polyChop(PolyWedge XX1,PolyWedge XX2) {

	double edge=XX1.edgeMin();

	PolyWedge X1=XX1.inflate(1.0/edge);   //unit edges
	PolyWedge X2=XX2.inflate(1.0/edge);
	PolyVector Y1=new PolyVector(X1);
	PolyVector Y2=new PolyVector(X2);
	PolyVector Y3=PolygonIntersector.polyChop(Y1,Y2);
	PolyWedge X3=Y3.toPolyWedge();

	PolyWedge XX3=X3.inflate(edge);
	return(XX3);
    }


    public PolyWedge translate(Complex Z) {
	PolyWedge Q=new PolyWedge();
	Q.count=count;
	for(int i=0;i<count;++i) Q.z[i]=Complex.plus(z[i],Z);
	return(Q);
    }




}

