

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class PolygonIntersector {
    public PolygonIntersector() {}




    public static Vector[] findIntersect(Vector Vec1,Vector Vec2,PolyVector P,int[][] K) {

	Vector[] W=new Vector[2];
        if(K[1][2]==2) {
	W[0]=P.V[K[1][3]];
	W[1]=P.V[K[1][4]];
	return(W);
    }

    if(K[1][2]==1) {
	W[0]=P.V[K[1][3]];
	int i1=K[1][6];
	int i2=(i1+1)%P.count;	
	W[1]=Vector.findCross(Vec1,Vec2,P.V[i1],P.V[i2]);
	return(W);
       }

    if(K[1][5]==2) {
	int i1=K[1][6];
	int i2=(i1+1)%P.count;
	W[0]=Vector.findCross(Vec1,Vec2,P.V[i1],P.V[i2]);
	int i3=K[1][7];
	int i4=(i3+1)%P.count;
	W[1]=Vector.findCross(Vec1,Vec2,P.V[i3],P.V[i4]);
	return(W);
       }
    return(null);
}


    public static PolyVector specialPolyChop(PolyVector PV,PolyVector VE) {
	if(VE==null) return(null);
	Vector V1=PV.V[0];
	Vector V2=PV.V[1];
	Vector V3=PV.V[2];
	PolyVector Q1=singleChop(V1,V2,V3,VE);
	Q1=Q1.normalize();
       	PolyVector Q2=singleChop(V1,V3,V2,Q1);
	return(Q2.normalize());
    }



    public static PolyVector polyChop(PolyVector PV,PolyVector VE) {
	PolyVector Q1=new PolyVector(PV);

	if(VE==null) return(null);
	for(int i=0;i<VE.count;++i) {
	    int i1=i+0;
	    int i2=i+1;
	    int i3=i+2;
	    if(i2>=VE.count) i2=i2-VE.count;
	    if(i3>=VE.count) i3=i3-VE.count;
	    Vector V1=VE.V[i1];
	    Vector V2=VE.V[i2];
	    Vector V3=VE.V[i3];
	    Vector W1=new Vector(10000*V1.x[0]-9999*V2.x[0],10000*V1.x[1]-9999*V2.x[1]);
	    Vector W2=new Vector(10000*V2.x[0]-9999*V1.x[0],10000*V2.x[1]-9999*V1.x[1]);
	    Q1=singleChop(W1,W2,V3,Q1);
	    Q1=Q1.normalize();
	}
	return(Q1);
    }



    public static PolyVector singleChop(Vector[] Vec,PolyVector P) {
	Vector Vec1=Vec[0];	
        Vector Vec2=Vec[1];	
        Vector Vec3=Vec[2];
	return(singleChop(Vec1,Vec2,Vec3,P));
    }


    public static PolyVector singleChop(Vector Vec1,Vector Vec2,Vector Vec3,PolyVector P) {
	if(P==null) return(null);
	int[][] K=intersectProfile(Vec1,Vec2,Vec3,P);
	if(K[1][0]==1) return(P);                //(V1,V2) lies on an edge
	if(K[1][1]==1) return(P);                //no vertices on wrong side

	Vector[] W=findIntersect(Vec1,Vec2,P,K);

	PolyVector Q=new PolyVector();
	Q.V[0]=W[1];
	Q.V[1]=W[0];
	Q.count=2;
	int first=0;
	int last=0;

	int[] A=new int[P.count];
	int total=0;

	  for(int i=0;i<P.count;++i) {
		  if(K[0][i]==1) {
                   A[total]=i;
		   ++total;
                   Q.V[Q.count]=P.V[i];
                   ++Q.count;
		  }
	  }
	  if(Q.count==3) return(Q);
	  int[] B=gapRotate(A,total,P.count);
	  for(int i=0;i<total;++i)
	      Q.V[i]=P.V[B[i]];
	  int test=checkLineCross(Q.V[0],W[0],Q.V[total-1],W[1]);
	  Q.V[total]=W[1];
	  Q.V[total+1]=W[0];
	  if(test==1) {Q.V[total]=W[0];Q.V[total+1]=W[1];}
	  return(Q);
	}





    /*checks if the line V1V2 crosses the line V3V4*/

    public static int checkLineCross(Vector V1,Vector V2,Vector V3,Vector V4) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	Vector W3=V3.normalize();
	Vector W4=V4.normalize();
	double o1=Vector.tripleProduct(W1,W2,W3);
	double o2=Vector.tripleProduct(W1,W2,W4);

      if(Math.abs(o1)<.000001) return(1);
      if(Math.abs(o2)<.000001) return(1);
      if(o1*o2<0) return(1);
      return(0);
    }


    /* checks if the segment V1V2 crosses the segment V3V4 */




    public static int checkSegmentCross(Vector V1,Vector V2,Vector V3,Vector V4) {
	Vector W1=V1.normalize();
	Vector W2=V2.normalize();
	Vector W3=V3.normalize();
	Vector W4=V4.normalize();

	if(V1.between(V3,V1,V4)==1) return(1);
	if(V1.between(V3,V2,V4)==1) return(1);
	if(V1.between(V1,V3,V2)==1) return(1);
	if(V1.between(V1,V4,V2)==1) return(1);

	double o1=Vector.tripleProduct(W1,W2,W3);
	double o2=Vector.tripleProduct(W1,W2,W4);
	double o3=Vector.tripleProduct(W1,W3,W4);
	double o4=Vector.tripleProduct(W2,W3,W4);

	if(Math.abs(o1)<.000000001) return(0);
	if(Math.abs(o2)<.000000001) return(0);
	if(Math.abs(o3)<.000000001) return(0);
	if(Math.abs(o4)<.000000001) return(0);

	if(o1*o2>0) return(0);
	if(o3*o4>0) return(0);
	return(1);
    }



    public static int checkLineCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	Vector V1=new Vector(z1);
	Vector V2=new Vector(z2);
	Vector V3=new Vector(z3);
	Vector V4=new Vector(z4);
	return(checkLineCross(V1,V2,V3,V4));
    }







    public static int gapIndex(int[] A,int t1,int t2) {
	for(int i1=0;i1<t1;++i1) {
	    int i2=(i1+1)%t1;
	    int d=Math.abs(A[i1]-A[i2]);
	    d=d%t2;
	    if(d>1) return(i1);
	}
	return(-1);
    }

    public static int[] gapRotate(int[] A,int t1,int t2) {
	int ind=gapIndex(A,t1,t2);
	int[] B=new int[t1];
	if(ind>=0) {
	    for(int i=0;i<t1;++i) {
		B[i]=A[(i+ind+1)%t1];
	    }
	    return(B);
	}
	return(A);
    }








    public static int[][] intersectProfile(Vector V1, Vector V2, Vector V3, PolyVector P) {
    int[][] K=new int[2][P.count+8];
    int edge=0;
    int corner1=-2;
    int corner2=-2;
    int edge1=-2;
    int edge2=-2;
    int edgecount=0;
    int cornercount=0;
    int bad=0;
    double o1;
    double o2=Vector.tripleProduct(V1,V2,V3);
    for(int i=0;i<P.count;++i) {
	o1=Vector.tripleProduct(V1,V2,P.V[i]);
	if(o1*o2>0) K[0][i]=1;
	if(o1*o2<0) K[0][i]=-1;
	if(Math.abs(o1)<.00001) K[0][i]=0;
	if(K[0][i]<0) ++bad;
	if((i>0)&&(K[0][i]==0)&&(K[0][i-1]==0)) edge=1;
	if((cornercount==1)&&(K[0][i]==0)) {corner2=i;++cornercount;}
	if((cornercount==0)&&(K[0][i]==0)) {corner1=i;++cornercount;}
	if((edgecount==1)&&(i>0)&&(K[0][i]*K[0][i-1]<0)) {edge2=i-1;++edgecount;}
	if((edgecount==0)&&(i>0)&&(K[0][i]*K[0][i-1]<0)) {edge1=i-1;++edgecount;}
    }

    if((edgecount==0)&&(K[0][0]*K[0][P.count-1]<0)) {edge1=P.count-1;++edgecount;}
    if((edgecount==1)&&(K[0][0]*K[0][P.count-1]<0)) {edge2=P.count-1;++edgecount;}

    if((K[0][0]==0)&&(K[0][P.count-1]==0)) edge=1;
    K[1][0]=edge;
    if(bad==0) K[1][1]=1;
    K[1][2]=cornercount;
    K[1][3]=corner1;
    K[1][4]=corner2;
    K[1][5]=edgecount;
    K[1][6]=edge1;
    K[1][7]=edge2;
    return(K);
}



public static int[][] intersectProfile2(Complex z1,Complex z2,Complex z3,PolyWedge P) {
    Vector V1=new Vector(z1);
    Vector V2=new Vector(z2);
    Vector V3=new Vector(z3);
    PolyVector PP=new PolyVector(P);
    return(intersectProfile(V1,V2,V3,PP));
}


    public static int doTheyIntersect(PolyVector P1,PolyVector P2) {
	int i1,i2,j1,j2;
	for(int i=0;i<P1.count;++i) {
	    for(int j=0;j<P2.count;++j) {
		i1=i;
		i2=i+1;
		if(i2==P1.count) i2=0;
		j1=j;
		j2=j+1;
		if(j2==P2.count) j2=0;
		Vector V1=P1.V[i1];
		Vector V2=P1.V[i2];
		Vector W1=P2.V[j1];
		Vector W2=P2.V[j2];
		if(checkSegmentCross(V1,V2,W1,W2)==1) {
                    return(1);
		}
	    }
	}

	for(int i=0;i<P1.count;++i) {
	    Vector V1=P1.V[i];
	    if(P2.inside(V1)==1) return(1);
	}

	for(int i=0;i<P2.count;++i) {
	    Vector V1=P2.V[i];
	    if(P1.inside(V1)==1) return(1);
	}

	return(0);
    }


}
