import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Quad {
    Complex[] z=new Complex[4];

    public Quad() {
	for(int i=0;i<4;++i) z[i]=new Complex();
    } 

    public Quad(Quad P) {
	for(int i=0;i<4;++i)
	    this.z[i]=P.z[i];
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	gp.lineTo((float)(z[1].x),(float)(z[1].y));
	gp.lineTo((float)(z[2].x),(float)(z[2].y));
	gp.lineTo((float)(z[3].x),(float)(z[3].y));
	gp.closePath();
	return(gp);
    }

    public PolyWedge toPolyWedge() {
	PolyWedge P=new PolyWedge();
	P.count=4;
	for(int i=0;i<4;++i) P.z[i]=z[i];
	return(P);
    }


    public void print() {
	for(int i=0;i<4;++i) z[i].print();
    }



    public Quad scale(Complex Z) {
	Quad Q=new Quad();
	for(int i=0;i<4;++i) Q.z[i]=this.z[i].times(Z);
	return(Q);
    }


    public Quad translate(Complex Z) {
	Quad Q=new Quad();
	for(int i=0;i<4;++i) Q.z[i]=this.z[i].plus(Z);
	return(Q);
    }


    public static Complex reflect(Complex z0,Complex z1) {
	Complex z2=new Complex(2*z0.x-z1.x,2*z0.y-z1.y);
	return(z2);
    }



    public Quad rotate(int j) {
	if(j<0) return(this);
	if(j>3) return(this);
	Quad Q=new Quad();
	for(int i=0;i<4;++i) Q.z[i]=reflect(z[j],z[i]);
	return(Q);
    }

    /**a return of 1 means that the two quads are almost identical*/

    public static int compare(Quad Q1,Quad Q2) {
      for(int i=0;i<4;++i) {
	if(Complex.dist(Q1.z[i],Q2.z[i])>.0000001) return(0);
      }
    return(1);
    }


    Complex getCenter() {
	double x=0;
	double y=0;
	for(int i=0;i<4;++i) {
	    x=x+z[i].x/4.0;
	    y=y+z[i].y/4.0;
	}
	return(new Complex(x,y));
    }

    public static Quad fib0() {
	Quad Q=new Quad();  
	Q.z[2]=new Complex(1.0/3.0,0);
        Q.z[0]=new Complex(-1,0);
        Q.z[1]=new Complex(0,-1);
        Q.z[3]=new Complex(0,1);
	return(Q);
    }

    public static Quad penroseKite() {
	Quad Q=new Quad();  
	double PHI=(1+Math.sqrt(5))/2;
	Q.z[2]=new Complex(1.0/(PHI*PHI*PHI),0);
        Q.z[0]=new Complex(-1,0);
        Q.z[1]=new Complex(0,-1);
        Q.z[3]=new Complex(0,1);
	return(Q);
    }

    public static Quad setQuad(double A) {
	Quad Q=new Quad();  
	Q.z[2]=new Complex(A,0);
        Q.z[0]=new Complex(-1,0);
        Q.z[1]=new Complex(0,-1);
        Q.z[3]=new Complex(0,1);
	return(Q);
    }


    public int inside(Complex z) {
	Vector V=new Vector(z);
	PolyVector QQ=new PolyVector(this);
	return(QQ.inside(V));
    }


}

