import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;






public class TilingCanvas extends Canvas implements KeyListener,MouseListener, MouseMotionListener, Runnable {
    Manager M;
    Quad QUAD;
    GeneralPath[] G=new GeneralPath[3];
    AffineTransform[] A=new AffineTransform[5];
    ComputeTile TC;
    String[] STAT=new String[5];
    Documentation DOC;

    Complex SOURCE=new Complex(0,0);
    Color[] TILECOLOR=new Color[200000];
    Color[] TRACECOLOR=new Color[200000];
    GeneralPath[] TRACE=new GeneralPath[200000];
    PolyWedge[] TILE=new PolyWedge[200000];
    int[] ORBITINDEX=new int[200000];   
    int[] ORBITPOSITION=new int[200000];
    ListenSquare STATS;
    SelectIntegerKeyboard IS;
    ListenSquare IS2;



    //temp
    int point=0;
    Complex[] POINT=new Complex[200000];
    Color[] POINTCOLOR=new Color[200000];


    int orbit=0;
    int tile=0;
    int count=1;
    int halt=0;
    int block=0; 
    Point JX;

    PolyWedge WEDGE;
    PolyVector VECTOR;
    ListenSquare[] L=new ListenSquare[10];
    int MEM;


    public TilingCanvas addManager(Manager M) {
	TilingCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public TilingCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 TC=new ComputeTile();

	 /**ZOOM: these AffineTransforms are used in the scaling routines*/

	 A[0]=AffineTransform.getTranslateInstance(200,200);
         A[1]=AffineTransform.getScaleInstance(20,-20);

	 QUAD=new Quad();
	 QUAD=QUAD.setQuad(Math.sqrt(5.0)-2.0);
	 L[4]=new ListenSquare(0,0,300,12,Color.white);  //aspect ratio
	 L[6]=new ListenSquare(0,0,12,12,Color.white);
	 STATS=new ListenSquare(0,0,0,0,Color.white);
	 STAT[0]="";
	 STAT[1]="";
	 STAT[2]="";
	 STAT[3]="";

	 DOC=new Documentation();

	 //manual point selection
	 IS2=new ListenSquare(340,0,12,12,Color.white);
	 IS2.on=1;
	 IS=new SelectIntegerKeyboard(300,0,52,12,0,99999); 
	 IS.on=1;
	 point=0;
     }


   public void paint(Graphics g2) {

         Graphics2D g=(Graphics2D) g2;
         g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

         drawSetup(g);
	 drawPlot(g);
         drawTiles(g);  
         drawSource(g);

	   Output OUT=new Output("Output/tilemark");	   
	   if(M.C.CON_T.MARKER.L[0].on==1) TilingMarkings.drawX(g,M,OUT);
           if(M.C.CON_T.MARKER.L[1].on==1) TilingMarkings.drawFrame(g,M);
           if(M.C.CON_T.MARKER.L[2].on==1) TilingMarkings.drawStrips(g,M);

         g.setColor(Color.white);
         g.drawRect(0,0,getWidth()-1,getHeight()-1);
	 L[6].infoRender(g);
	 drawStats(g);
   }


    public void drawStats(Graphics g) {
	STATS.x=0;
	STATS.y=getHeight()-20;
	STATS.w=getWidth();
	STATS.h=20;
	STATS.on=1;
	STATS.render(g,new Color(0,0,100));
	g.drawString(STAT[0],5,(int)(STATS.y+11));
	g.drawString(STAT[1],90,(int)(STATS.y+11));
	g.drawString(STAT[2],200,(int)(STATS.y+11));
	g.drawString(STAT[3],500,(int)(STATS.y+11));
    }







    //temp
    public void addPoint(Complex z,Color C) {
	POINT[point]=new Complex(z);
	POINTCOLOR[point]=C;
	++point;
    }

    public void drawPlot(Graphics2D g) {

	double d=.005;
	GeneralPath gp=new GeneralPath();
	Complex z=new Complex();

	for(int i=0;i<point;++i) {
	    gp.reset();
	    z=new Complex(POINT[i]);
	    g.setColor(POINTCOLOR[i]);
	    gp.moveTo((float)(z.x-d),(float)(z.y-d));
	    gp.lineTo((float)(z.x-d),(float)(z.y+d));
	    gp.lineTo((float)(z.x+d),(float)(z.y+d));
	    gp.lineTo((float)(z.x+d),(float)(z.y-d));
	    gp.closePath();
	    gp=transform(gp);
	    g.draw(gp);
	    g.fill(gp);
	}
    }








    /**Scaling and transformations*/



     public void changeTranslate(int q) {
	 double g1=A[1].getScaleX(); //underlying scale
	 double tx=A[0].getTranslateX();
	 tx=tx+q*g1;
	 A[0]=AffineTransform.getTranslateInstance(tx,A[0].getTranslateY());
	 repaint();
     }



     public void absoluteTranslate(int q) {
	 double g1=A[1].getScaleX(); //underlying scale
	 double tx=-q*g1;
	 A[0]=AffineTransform.getTranslateInstance(tx,A[0].getTranslateY());
	 repaint();
     }



    /**ZOOM: This routine is invoked whenever I draw something. It
       scales the GeneralPath to the desired size, based on my
       previous mouse clicks */

    public GeneralPath transform(GeneralPath H) {
	GeneralPath HH=new GeneralPath(H);
	HH.transform(A[1]);   //scale
	HH.transform(A[0]);   //translate
	return(HH);
    }


    /**ZOOM: This routine is the companion to the scaling routine.  
       After I have zoomed into the picture in some way, my further
       mouse clicks have different meanings than they did before the
       zoom.  In other words, suppose that I dilate the picture by
       100000.  When I click on the point with pixel value (50,50)
       I really mean to select the number (.00005,.00005). This routine
       changes the pixel value of the point to the intended value.*/

    public Complex unTransform(Point X) {
	double ux=A[0].getTranslateX();
       double uy=A[0].getTranslateY();
       double tx=X.x;
       double ty=X.y;

       double sx=A[1].getScaleX();
       double sy=A[1].getScaleY();
       ux=(ux-tx)+tx;
       uy=(uy-ty)+ty;
       tx=tx-ux;
       ty=ty-uy;
       tx=tx/sx;
       ty=ty/sy;
       return(new Complex(tx,ty));
    }


    /**ZOOM: this routine scales up or down with the mouse click.
       The first argument is the point about which you scale, and
       the second argument just tells you whether to go up or down.
       The basic idea is that I have globally defined some
       AffineTransform objects.  These will rescale a GeneralPath
       whenever I draw it.  So, I just modify the components of
       these AffineTransforms whenever I do this routine.*/
       



    public void scaleUp(Point X,int k) {

	double scale=Math.pow(2,0.25);
	double ss=scale;
	if(k==1) ss=1/scale;

	double sx=A[1].getScaleX();
	double sy=A[1].getScaleY();
	double tx=X.x;
	double ty=X.y;
	double ux0=A[0].getTranslateX();
	double uy=A[0].getTranslateY();

	double ux1=ss*(ux0-tx)+tx;
	uy=ss*(uy-ty)+ty;
	sx=sx*ss;
        sy=sy*ss;
	A[1]=AffineTransform.getScaleInstance(sx,sy);
	A[0]=AffineTransform.getTranslateInstance(ux1,uy);
	repaint();
    }




    public void drawSource(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	float x=(float)(SOURCE.x);
	float y=(float)(SOURCE.y);
	gp.moveTo((float)(x-.00001),(float)(y-.00001));
	gp.lineTo((float)(x-.00001),(float)(y+.00001));
	gp.lineTo((float)(x+.00001),(float)(y+.00001));
	gp.lineTo((float)(x+.00001),(float)(y-.00001));
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.white);
	g.fill(gp);
	g.draw(gp);
    }


    public void drawSetup(Graphics2D g) {
	g.setColor(new Color(0,30,50));
	try{
          g.setColor(M.C.CON_T.COLORS.L[1].C);
	}
	catch(Exception e){}
     g.fillRect(0,0,getWidth(),getHeight());
     G[0]=QUAD.toGeneralPath();
     G[0]=transform(G[0]);
     g.setColor(new Color(0,0,50));
     try{
       g.setColor(M.C.CON_T.COLORS.L[2].C);
     }
     catch(Exception e) {}
     g.fill(G[0]);
     g.setColor(Color.white);
     g.draw(G[0]);  
   
    }






    public void nextOrbit(PolyWedge PW) {
	PinwheelMap RM=new PinwheelMap(Math.sqrt(5.0)-2.0);
	int k1=M.C.CON_T.TCC.INT[0].val;
	int k2=M.C.CON_T.TCC.INT[1].val;
	k1=(int)(Math.pow(2,k1));
	k2=(int)(Math.pow(2,k2));
	Complex z=PW.getCenter();
	  int multi=M.C.CON_T.MULTI.mode;
	  if(multi==0) nextOrbitWhole(PW,PW.orbit,k1,k2);
	  if(multi==1) nextOrbitWhole(PW,PW.orbit,k1,1);
	  if(multi==2) nextOrbitReturn(PW);
	  if(multi==3) nextOrbitWhole(PW,M.C.CON_T.INT[0].val,k1,k2);  
          if(multi==4) nextOrbitWhole(PW,1,k1,k2);
    }



    public void nextOrbitReturn(PolyWedge PW) {
	int first=0;
	int second=0;
	int test=0;  
        WEDGE=new PolyWedge(PW);
	int count=0;
	Complex[] z=new Complex[6];
	while((count<PW.orbit+6)&&(second==0)) {

           test=WEDGE.hitsStrip();
	    if(first==1) {
		if(test==1) {
                    z[1]=WEDGE.getCenter();
                    second=1;
		}
	    }

	    if(first==0) {
		if(test==1) {
                    first=1;
		    z[0]=WEDGE.getCenter();
		}
	    }

            TILE[tile]=WEDGE;
            TILECOLOR[tile]=M.C.CS.C;   
	    ORBITPOSITION[tile]=count;
            ORBITINDEX[tile]=orbit;   
            WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	    WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	    ++tile;
	    ++count;
	}
	++orbit;
    }



    public void nextOrbitWhole(PolyWedge PW,int k,int k1,int k2) {
	Complex z1=PW.getCenter();
	Complex z2=new Complex(z1);
	  WEDGE=new PolyWedge(PW);
	  int i=0;
	  int test=0;
	  int kk=k;
	  if(kk>50000) kk=50000;
	  while((test==0)&&(i<kk)) {
	      z2=WEDGE.getCenter();
	      if(determinePlot(k1,k2)==1) {
		   TILE[tile]=WEDGE;
                   TILECOLOR[tile]=M.C.CS.C;   
		   ORBITPOSITION[tile]=i;
                   ORBITINDEX[tile]=orbit;   
                   ++tile;
	       }
               WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       ++i;
	       test=PolyWedge.doTheyIntersect(PW,WEDGE);
	  }

	     Integer II=new Integer(i);
	     STAT[0]="orbit "+II.toString();

	     Integer MAX=new Integer(PW.radius);
	     STAT[1]="excursion "+MAX.toString();

	     setCoord();
	     ++orbit;
    }




    public void nextOrbitColorMap(PolyWedge PW,int k,int k1,int k2) {
	Complex z1=PW.getCenter();
	Complex z2=new Complex();
	Complex z3=new Complex();
	  WEDGE=new PolyWedge(PW);
	  PolyWedge WEDGE2=new PolyWedge(PW);
	  int i=0;
	  int test=0;  
          double A=Math.sqrt(5.0)-2.0;
	  while((test==0)&&(i<k)) {
	      if(determinePlot(k1,k2)==1) {
		   TILE[tile]=WEDGE;
		   z1=WEDGE.z[1];
                   TILECOLOR[tile]=M.C.CS.C;   
		   ORBITPOSITION[tile]=i;
                   ORBITINDEX[tile]=orbit;   
                   WEDGE2=ComputeTile.nextPoly(WEDGE,QUAD);
                   WEDGE2=ComputeTile.nextPoly(WEDGE2,QUAD);
		   z2=WEDGE2.z[1];
		   z3=Complex.minus(z2,z1);
                   Color CC=Color.black;
	           if(Complex.dist(z3,new Complex(-2,2))<.001) CC=Color.red;
	           if(Complex.dist(z3,new Complex(2,-2))<.001) CC=new Color(150,0,0);
	           if(Complex.dist(z3,new Complex(0,4))<.001) CC=Color.blue;
	           if(Complex.dist(z3,new Complex(0,-4))<.001) CC=new Color(0,0,150);
	           if(Complex.dist(z3,new Complex(-2-2*A,0))<.001) CC=Color.green;
	           if(Complex.dist(z3,new Complex(2+2*A,0))<.001) CC=new Color(0,150,0);
	           if(Complex.dist(z3,new Complex(2,2))<.001) CC=new Color(255,0,255);
	           if(Complex.dist(z3,new Complex(-2,-2))<.001) CC=new Color(140,0,140);
	           if(Complex.dist(z3,new Complex(-2*A,-2))<.001) CC=new Color(200,200,200);
	           if(Complex.dist(z3,new Complex(2*A,-2))<.001) CC=new Color(100,100,100);
                   TILECOLOR[tile]=CC;
                   ++tile;
	      }
               WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
               WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	       ++i;
	       test=PolyWedge.doTheyIntersect(PW,WEDGE);
	  }

	     Integer II=new Integer(i);
	     STAT[0]="orbit "+II.toString();

	     Integer MAX=new Integer(PW.radius);
	     STAT[1]="excursion "+MAX.toString();

	     setCoord();
	     ++orbit;
    }






    public void nextOrbitColorMap(PolyWedge PW) {
	  WEDGE=new PolyWedge(PW);
	  TILE[tile]=WEDGE;
	  Complex z1=WEDGE.z[1];
	  ORBITPOSITION[tile]=0;
          ORBITINDEX[tile]=orbit;
          WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
          WEDGE=ComputeTile.nextPoly(WEDGE,QUAD);
	  Complex z2=WEDGE.z[1];
	  Complex z3=Complex.minus(z2,z1);

	  double A=Math.sqrt(5.0)-2.0;

	  Color CC=Color.black;
	  if(Complex.dist(z3,new Complex(-2,2))<.001) CC=Color.red;
	  if(Complex.dist(z3,new Complex(2,-2))<.001) CC=new Color(150,0,0);

	  if(Complex.dist(z3,new Complex(0,4))<.001) CC=Color.blue;
	  if(Complex.dist(z3,new Complex(0,-4))<.001) CC=new Color(0,0,150);

	  if(Complex.dist(z3,new Complex(-2-2*A,0))<.001) CC=Color.green;
	  if(Complex.dist(z3,new Complex(2+2*A,0))<.001) CC=new Color(0,150,0);

	  if(Complex.dist(z3,new Complex(2,2))<.001) CC=new Color(255,0,255);
	  if(Complex.dist(z3,new Complex(-2,-2))<.001) CC=new Color(140,0,140);


	  if(Complex.dist(z3,new Complex(-2*A,-2))<.001) CC=new Color(200,200,200);
	  if(Complex.dist(z3,new Complex(2*A,-2))<.001) CC=new Color(100,100,100);

	  TILECOLOR[tile]=CC;
	  ++tile;
	  setCoord();
	  ++orbit;
    }







    public void setCoord() {
	     Double Sx=new Double(SOURCE.x);
	     Double Sy=new Double(SOURCE.y);
	     double d=Math.floor((SOURCE.x+1)/4);
	     Integer II=new Integer((int)(d));
	     STAT[2]="coord "+Sx.toString()+"   "+Sy.toString();

    }



    public int determinePlot(int k1,int k2) {
        int test=WEDGE.isWithinRange(k1,k2);
	return(test);
    }





    public int recolor1(int orb,Color C) {
	int ct=0;
	for(int i=0;i<tile;++i) {
	    if(ORBITINDEX[i]==orb) {TILECOLOR[i]=C;++ct;}
	}
	return(ct);
    }

    public void recolor2(int N,Color C) {
	TILECOLOR[N]=C;
    }


    /*ZOOM: the routine transform applies the AffineTransforms
      to any tile I want to plot.*/

    public void drawTiles(Graphics2D g) {
	for(int i=0;i<tile;++i) {
	    GeneralPath X=TILE[i].toGeneralPath();
	    X=transform(X);
            g.setColor(TILECOLOR[i]);
            g.fill(X); 
            g.setColor(M.C.CON_T.COLORS.L[0].C);
            g.draw(X); 
	}
    }


    public void saveTiles() {
	Output writer=new Output("Output/tiling");
	GeneralPath Y=QUAD.toGeneralPath();
        writer.polyWrite(Y,M.C.CON_T.COLORS.L[2].C);

	for(int i=0;i<tile;++i) {
	    GeneralPath X=TILE[i].toGeneralPath();
            writer.polyWrite(X,TILECOLOR[i]);
	}
    }


    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
     }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
	try{
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	    JX=J.X;
	}
	catch(Exception ee) {}
    }

    public void mouseDragged(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        DOC.M=this.M;
	MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	Point X=J.X;
	int but=J.mode; 
	doMouseClick(X,but);
    }

    public void doMouseClick(Point X,int mode) {

	if(M.C.EXPORT.mode==1) saveTiles();
        if(L[6].inside(X)==1) DOC.pictureCanvasInfo();

	if(IS2.inside(X)==1) absoluteTranslate(IS.val);

	/**ZOOM: Here is where I activate the scaling */

	if((IS.inside(X)==0)&&(L[4].inside(X)==0)) {
        if(mode==1) scaleUp(X,-1);
        if(mode==3) scaleUp(X,+1);


	/**ZOOM: Here is where I change the value of the clicked
           point from its pixel value to its intended value.  This
           will make sense after you read about the unTransform method.*/

	if(mode==2) {
            Complex temp=unTransform(X);
            if(QUAD.inside(temp)==0) {
	      SOURCE=temp;
	      setCoord();
	      goOrbit();
	    }
	}
      }
    }



    public void keyTyped(KeyEvent e) {

	int test=0;
	char ch=e.getKeyChar();
	if(ch=='b') test=1;
	if(ch=='n') test=2;
	if(ch=='m') test=3;
	if(test>0) doMouseClick(JX,test);

	if(ch==',') changeTranslate(4*IS.val);
	if(ch=='.') changeTranslate(-4*IS.val);
	if(ch=='h') changeTranslate(4*IS.val);
	if(ch=='j') changeTranslate(-4*IS.val);

	IS.modify(e);
	repaint();

    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}



    public int[] findRange(int N) {
	int orb=ORBITINDEX[N];
	int max=0;
	int min=10000000;
	for(int i=0;i<tile;++i) {
	    if((ORBITINDEX[i]==orb)&&(max<i)) max=i;
	    if((ORBITINDEX[i]==orb)&&(min>i)) min=i;
	}
	int[] str={min,max};
	return(str);
    }


    public void goOrbit() {


	if(M.C.CON_T.ACTION.mode==0) {
	    TC=new ComputeTile(QUAD,SOURCE,M,0);
	    new Thread(TC).start();
	}

        if(M.C.CON_T.ACTION.mode>0) {
	   Thread A=new Thread(this);
	   A.start();
	}
    }


    public void run() {
	    halt=1;
	    int count=tile-1;
	    double x=0;
	    double y=0;
	    MEM=-1;
	    while((count>=0)&&(halt==1)) {
	      x=SOURCE.x;
	      y=SOURCE.y;
	      GeneralPath T=TILE[count].toGeneralPath();
	      if(T.contains(x,y)==true) {
		  MEM=count;
		  halt=0;
	      }
	      --count; 
              if((count>0)&&(count%100==0)) {
		Integer COUNT=new Integer(count);
		M.C.repaint();
	      }
	    }
	    halt=0;
	    if(MEM!=-1) WEDGE=TILE[MEM];
	    alterMemory(MEM);

    }



    public void alterMemory(int N) {

     if(N!=-1) {

	 int MODE=M.C.CON_T.ACTION.mode;
	 //recoloring1
	if(MODE==1) {
           double time1=System.currentTimeMillis();
            int ct=recolor1(ORBITINDEX[N],M.C.CS.C);
            double time2=System.currentTimeMillis();
	}

	//erasing
	if(MODE==2) {
	    int[] stretch=findRange(N);
	    int range=stretch[1]-stretch[0]+1;
	    for(int i=stretch[0];i<tile-range;++i) {
		TILE[i]=new PolyWedge(TILE[i+range]);

	        ORBITINDEX[i]=ORBITINDEX[i+range];	
		int r=TILECOLOR[i+range].getRed();
		int g=TILECOLOR[i+range].getGreen();
		int b=TILECOLOR[i+range].getBlue();
		TILECOLOR[i]=new Color(r,g,b);

		try{
		  TRACE[i]=new GeneralPath(TRACE[i+range]);
                  r=TRACECOLOR[i+range].getRed();
		  g=TRACECOLOR[i+range].getGreen();
		  b=TRACECOLOR[i+range].getBlue();
	          TRACECOLOR[i]=new Color(r,g,b);
		}
		catch(Exception e) {}


	    }
	    tile=tile-range;
	}

	 //recoloring2
	if(MODE==3) {
            recolor2(N,M.C.CS.C);
	}

     repaint();
     M.C.repaint();
     }
    }

  

}

