import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TilingMarkings {
    public TilingMarkings() {
    }

    public static void drawX(Graphics2D g,Manager M,Output OUT) {
	GeneralPath H=new GeneralPath();  
        Color COL=M.C.CON_T.COLORS.L[3].C;
	g.setColor(COL);
	for(int i=-100;i<100;++i) {
	  H.reset();
	  H.moveTo(-1000,1+2*i);
	  H.lineTo(1000,1+2*i);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);
	}

	double A=Math.sqrt(5.0)-2.0;
          H.reset();
	  H.moveTo(-1000,0);
	  H.lineTo(1000,0);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);

    }


    public static void drawStrips(Graphics2D g,Manager M) {
	drawStrip1(g,M);
	drawStrip2(g,M);
	drawStrip3(g,M);
	drawStrip4(g,M);
    }



    public static void drawStrip4(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;


	//first strip

	a1=0;
	a2=1;
	a3=3;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }


    public static void drawStrip1(Graphics2D g,Manager M) {
        Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//second strip

	a1=0;
	a2=3;
	a3=1;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }


    public static void drawStrip3(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//third strip

	a1=2;
	a2=3;
	a3=0;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }





    public static void drawStrip2(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//4th strip

	a1=2;
	a2=1;
	a3=0;


	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);	

        H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }

    public static void drawZone1(Graphics2D g,Manager M,int option) {
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(0,4);

	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)(1);
	p1[1]=(float)(-2);

	p2[0]=(float)(2*0-(NUM1*(-1)-NUM2*(0)));
	p2[1]=(float)(2*(-1)-(NUM1*(0)-NUM2*1));

	p3[0]=(float)(NUM1*0-NUM2*(-1));
	p3[1]=(float)(NUM1*(-1)-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(0,0,180));
	if(option==1) g.setColor(new Color(0,0,180,100));
	g.fill(H0);
	g.setColor(new Color(100,100,100));
	g.draw(H0);
    }




    public static void drawZone2(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(-2,2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)(0);
	p1[1]=(float)(-1);

	p2[0]=(float)(1);
	p2[1]=(float)(-2);

	p3[0]=(float)(2*0-(NUM1*(-1)-NUM2*(0)));
	p3[1]=(float)(2*(-1)-(NUM1*(0)-NUM2*1));

	p4[0]=(float)(NUM1*A-NUM2*0);
	p4[1]=(float)(NUM1*(0)-NUM2*(-1));


	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath();
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
	g.setColor(new Color(160,0,0));
	if(option==1) g.setColor(new Color(160,0,0,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }


    public static void drawZone3(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=z[2].x;
	AffineTransform offset=AffineTransform.getTranslateInstance(-2-2*A,0);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	//sector R3

	p1[0]=(float)(2*A);
	p1[1]=(float)(1);

        w=Vector.findCross2(z[2],z[3],z[2].reflect(z[1]),z[2].reflect(z[0]));
	w=new Complex(2*A*A/(A-1),(1+A)/(1-A));

	p2[0]=(float)(w.x);
	p2[1]=(float)(w.y);

	p3[0]=(float)(NUM1*(0)-NUM2*A);
	p3[1]=(float)(NUM1*1-NUM2*(0));

	p4[0]=(float)(NUM1*A-NUM2*0);
	p4[1]=(float)(NUM1*(0)-NUM2*(-1));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath();
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(0,140,0));
	if(option==1) g.setColor(new Color(0,140,0,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();
    }


    public static void drawZone4(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(-2,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();


        w2=Vector.findCross2(z[2],z[3],z[3].reflect(z[0]),z[3].reflect(z[1]));
	w2=new Complex(2*A/(A-1),(A-3)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(0)-(NUM1*0-NUM2*(-1)));
	p2[1]=(float)(2*1-(NUM1*(-1)-NUM2*(0)));

	p3[0]=(float)(NUM1*(0)-NUM2*A);
	p3[1]=(float)(NUM1*1-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();
	if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(140,0,140));
	if(option==1) g.setColor(new Color(140,0,140,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }


    public static void drawZone5(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(0,-4);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();



	w=new Complex(2*A/(A-1),(3*A-1)/(A-1));
	w2=new Complex(2*A/(A-1),(A-3)/(A-1));

	p1[0]=(float)(-A);
	p1[1]=(float)(2);

	p2[0]=(float)(w.x);
	p2[1]=(float)(w.y);

	p3[0]=(float)(NUM1*(-1)-NUM2*(0));
	p3[1]=(float)(NUM1*(0)-NUM2*1);

	p5[0]=(float)(w2.x);
	p5[1]=(float)(w2.y);

	p4[0]=(float)(2*(0)-(NUM1*0-NUM2*(-1)));
	p4[1]=(float)(2*1-(NUM1*(-1)-NUM2*(0)));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.lineTo(p5[0],p5[1]);
	H0.closePath();	
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(0,0,180));
	if(option==1) g.setColor(new Color(0,0,180,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }




    public static void drawZone6(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();


	w2=new Complex(2/(A-1),(A+1)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(-1)-(NUM1*A-NUM2*0));
	p2[1]=(float)(2*(0)-(NUM1*(0)-NUM2*(-1)));

	p3[0]=(float)(NUM1*(-1)-NUM2*(0));
	p3[1]=(float)(NUM1*(0)-NUM2*1);

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();	
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(160,0,0));
	if(option==1) g.setColor(new Color(160,0,0,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }



public static void drawZone7(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=z[2].x;
	AffineTransform offset=AffineTransform.getTranslateInstance(2+2*A,0);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	w2=new Complex(2/(A-1),(A+1)/(A-1));

	p1[0]=(float)(w2.x);
	p1[1]=(float)(w2.y);

	p2[0]=(float)(2*(-1)-(0));
	p2[1]=(float)(2*(0)-1);

	p3[0]=(float)(2*(-1)-(NUM1*(0)-NUM2*A));
	p3[1]=(float)(2*(0)-(NUM1*1-NUM2*(0)));

	p4[0]=(float)(2*(-1)-(NUM1*A-NUM2*0));
	p4[1]=(float)(2*(0)-(NUM1*(0)-NUM2*(-1)));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath();
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(0,160,0));
	if(option==1) g.setColor(new Color(0,160,0,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
    }




public static void drawZone8(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2,2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	double A=z[2].x;
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)((-1));
	p1[1]=(float)((0));

	p2[0]=(float)(-2);
	p2[1]=(float)(-1);

	p3[0]=(float)(2*(-1)-(NUM1*(0)-NUM2*A));
	p3[1]=(float)(2*(0)-(NUM1*1-NUM2*(0)));

	p4[0]=(float)(NUM1*0-NUM2*(-1));
	p4[1]=(float)(NUM1*(-1)-NUM2*(0));

	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.lineTo(p4[0],p4[1]);
	H0.closePath();	
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(160,0,160));
	if(option==1) g.setColor(new Color(160,0,160,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();
    }



public static void drawZone4sharp(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	double A=z[2].x;
	AffineTransform offset=AffineTransform.getTranslateInstance(-2*A,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();


	p1[0]=(float)(A);
	p1[1]=(float)(0);

	p2[0]=(float)(2*A);
	p2[1]=(float)(1);

	w=new Complex(2*A*A/(A-1),(A+1)/(1-A));

	p3[0]=(float)(w.x);
	p3[1]=(float)(w.y);


	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();
        if(option==1) H0.transform(offset);
	H0=M.P.transform(H0);
        g.setColor(new Color(150,150,150));	
        if(option==1) g.setColor(new Color(150,150,150,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();
    }





public static void drawZone6flat(Graphics2D g,Manager M,int option) {
	Color C=M.C.CON_T.COLORS.L[3].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	double A=z[2].x;
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	float[] p3=new float[2];
	float[] p4=new float[2];
	float[] p5=new float[2];
	AffineTransform offset=AffineTransform.getTranslateInstance(2*A,-2);
	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;
	Complex w=new Complex();
	Complex w2=new Complex();

	p1[0]=(float)((0));
	p1[1]=(float)(1);

	p2[0]=(float)(-A);
	p2[1]=(float)(2);

        w=new Complex(2*A/(A-1),(3*A-1)/(A-1));

	p3[0]=(float)(w.x);
	p3[1]=(float)(w.y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.lineTo(p3[0],p3[1]);
	H0.closePath();	  
        if(option==1) H0.transform(offset);

	H0=M.P.transform(H0);
        g.setColor(new Color(80,80,80));   
        if(option==1) g.setColor(new Color(80,80,80,100));
	g.fill(H0);
	g.setColor(C);
	g.draw(H0);
	H0.reset();

    }



































    public static void drawFrame(Graphics2D g,Manager M) {
	GeneralPath H=new GeneralPath();

	float dx=(float)(Math.pow(2,M.C.CON_T.TCC.INT[0].val));
	float dy=(float)(Math.pow(2,M.C.CON_T.TCC.INT[1].val));

	float a=(float)(1000.0);

	Color COL=M.C.CON_T.COLORS.L[4].C;
        g.setColor(COL);

	//top
	H.reset();
	H.moveTo(dx+a,dy);
	H.lineTo(dx+a,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,dy);
	H=M.P.transform(H);
	g.fill(H);

	//bottom
	H.reset();
	H.moveTo(dx+a,-dy);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(-dx-a,dy-a);
	H.lineTo(-dx-a,-dy);
	H=M.P.transform(H);
	g.fill(H);

	//right
	H.reset();
	H.moveTo(dx,dy+a);
	H.lineTo(dx+a,dy+a);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);

	//left
	H.reset();
	H.moveTo(-dx,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,-dy-a);
	H.lineTo(-dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);


	g.setColor(M.C.CON_T.COLORS.L[0].C);
	H.reset();
	H.moveTo(dx,dy);
	H.lineTo(-dx,dy);
	H.lineTo(-dx,-dy);
	H.lineTo(dx,-dy);
	H.closePath();
	H=M.P.transform(H);
	g.draw(H);
    }




}
