import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeGraph implements Runnable {
    int halt;
    Complex SOURCE;
    Manager M;
    Quad QUAD;


public ComputeGraph() {}

    public ComputeGraph(Complex z,Manager MM) {
	this.M=MM;
	this.SOURCE=z;	
    }

    public void run() {
	QUAD=new Quad(Math.sqrt(5)-2);
	int[] a=new int[2];
	for(int i=0;i<2;++i) a[i]=M.C.CON_G.GC1.ACTION.L[i].on;		
        if(a[1]==1) block(); 
	if(a[0]==1) bothOrbit();
        gridDynamics();
    }



    public int[] toInt(int Vx,int Vy) {
	int choice=M.C.CON_G.GC1.S[0].val;
	choice=choice%2;
	Complex Z=new Complex(Math.sqrt(5)-2,0);
	int a=Vx;
	int c=Vy;
	int b=-(int)(Math.floor(c*Z.y))-1;
	int test=(a+b+c+100000)%2;
	if(test==choice) b=b+1;
	int[] d={a,b,c};
	return(d);
    }

    public  Complex toComplex(int[] d) {
	double offsetY=M.C.getOffsetY();
	double offsetX=M.C.getOffsetX();
        Complex z=new Complex(Math.sqrt(5)-2,0);
	double x=2*d[0]+2*d[2]*z.x+offsetX;
	double y=2*d[1]+2*d[2]*z.y+offsetY;
	Complex w=new Complex(x,y);
	w.x=w.x+.0000001;
	return(w);
    }

     public int[] forwardReturn(int[] d,PolyWedge P) {
 	Complex z=toComplex(d);
        int[] d1=Strips.algebraicReturn(P,z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	d1[2]=d1[2]+d[2];
 	return(d1);
    }

    public int[] backwardReturn(int[] d,PolyWedge P) {
 	Complex z=toComplex(d);
        int[] d1=Strips.inverseAlgebraicReturn(P,z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	d1[2]=d1[2]+d[2];
 	return(d1);
    }


     public void sendMessage(int j) {
 	Integer X=new Integer(j);
 	M.C.message=X.toString();
 	M.C.repaint();
    }

     public void block() {
 	PolyWedge P=new PolyWedge(QUAD);
 	double LIM1=M.C.CON_G.I[0].val;
 	double LIM2=M.C.CON_G.I[1].val;
 	LIM1=Math.pow(2,LIM1);
 	LIM2=Math.pow(2,LIM2);

        GeneralPath gp=new GeneralPath();
        GeneralPath gp2=new GeneralPath();
 	int i=(int)(-LIM1);
 	int j=(int)(-LIM2);
 	halt=1;
 	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);

	Color COL=M.C.CON_G.GC1.ACTION.M[1].C;

 	while(halt==1) {
	     gp2.reset();
	     int[] d1=toInt(y+i,x+j);
	     int[] d2=forwardReturn(d1,P);
             gp2.moveTo(d1[2],d1[0]);
	     gp2.lineTo(d2[2],d2[0]);
	     if((d1[0]!=d2[0])||(d1[2]!=d2[2])) { 
                  gp2.moveTo(d1[2],d1[0]);
	          gp2.lineTo(d2[2],d2[0]);
                  gp.append(gp2,false);
	     }
	     ++i;
	     if(i>LIM1) {
	 	i=(int)(-LIM1);
	 	++j; 
	 	sendMessage(j);
	     }
	     if(j>LIM2) halt=0;
	}
 	halt=0;  
	int thick=M.G.THICK[0].val;
        M.G.nextPath(gp,COL,thick);	  
 	M.G.repaint();
    }


    public void bothOrbit() {
	forwardOrbit();
	backwardOrbit();
    }



    public void forwardOrbit() {
	Color COL=M.C.CON_G.GC1.ACTION.M[0].C;

	PolyWedge P=new PolyWedge(QUAD);
	Complex source=new Complex(SOURCE.y,SOURCE.x);
	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);
	int[] d=toInt(y,x);
	int[] d2={d[0],d[1],d[2]};
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	halt=1;

	int i=0;
	double max=0;
	while((i<LIM)&&(halt==1)) {
	    gp2.reset();
            gp2.moveTo(d[2],d[0]);
	    d=forwardReturn(d,P);
	    Complex test1=toComplex(d);
	    double test2=test1.x;
	    if(max<test2) max=test2;
	    gp2.lineTo(d[2],d[0]);
	    gp.append(gp2,false);
	    if((d[0]==d2[0])&&(d[2]==d2[2])) halt=0;
	    ++i;
	    if(i%1000==0) sendMessage(i);
	}
	halt=0;  	
        int thick=M.G.THICK[0].val;
	M.G.nextPath(gp,COL,thick);
	M.C.repaint();
	M.G.repaint();
    }



    public void backwardOrbit() {	
	Color COL=M.C.CON_G.GC1.ACTION.M[0].C;
	PolyWedge P=new PolyWedge(QUAD);
	Complex source=new Complex(SOURCE.y,SOURCE.x);
	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);
	int[] d=toInt(y,x);
	int[] d2={d[0],d[1],d[2]};
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();


	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	halt=1;

	int i=0;
	while((i<LIM)&&(halt==1)) {

            gp2.reset();
            gp2.moveTo(d[2],d[0]);
	    d=backwardReturn(d,P);
            gp2.lineTo(d[2],d[0]);
	    gp.append(gp2,false);
	    if((d[0]==d2[0])&&(d[2]==d2[2])) halt=0;
	    ++i;
	    if(i%1000==0) sendMessage(i);
	}
	halt=0;	 	
        int thick=M.G.THICK[0].val;
	M.G.nextPath(gp,COL,thick);  
	M.C.repaint();
	M.G.repaint();
    }




    public void gridDynamics() {

	Color COL=Color.white;
	for(int i=0;i<5;++i) {
	    COL=M.C.CON_G.GC1.CP[i].M[2].C;
	    if(M.C.CON_G.GC1.CP[i].L[2].on==1)	gridDynamics(i,COL);
	}

    }



    public  void gridDynamics(int depth,Color COL) {	
        int thick=M.G.THICK[1].val;
	int parity=M.C.CON_G.GC1.S[0].val;
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	GridDynamics GD=new GridDynamics(M,depth,parity);


	Complex z0=new Complex(M.G.SOURCE2);
	Complex z1=new Complex();
	gp=GD.getSegmentPath(z0);

	halt=1;
	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	int i=0;

	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(1,1,z0,0);
	  int TEST=0;
	  z0=GD.goDynamics(1,1,z0,.0001);  
	  gp2=GD.getSegmentPath(z0);  
          gp.append(gp2,false);
	  ++i; 
          if(i%100==0) sendMessage(i);
	}

	z0=new Complex(M.G.SOURCE2);
	z1=new Complex();
	i=0;
	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(-1,-1,z0,0);
	  int TEST=0;
	  z0=GD.goDynamics(-1,-1,z0,.0001);  
	  gp2=GD.getSegmentPath(z0);  
          gp.append(gp2,false);
	  ++i; 
          if(i%100==0) sendMessage(i);
	}


	halt=0;
	M.G.nextPath(gp,COL,2);
	M.C.repaint();
	M.G.repaint();
    }



}

