import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ControlCanvas extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    WordSquare I;
    ListenSquare[] L=new ListenSquare[10];
    int mode=2;
    SelectColor SC;  
    ControlPanel MOUSE,EXPORT,GLOBAL;
    ControlTiling CON_T;
    ControlGraph CON_G;
    Documentation DOC;  
    ListenSquare GO,HALT,RESET_TILE,RESET_GRAPH;
    ComputeGraph CG;
    String message;
    String PROGRESS;

    SelectInteger SI;

    public ControlCanvas addManager(Manager M) {
	ControlCanvas Q=this;
	Q.M=M;
	return(Q);
    }

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 I=new WordSquare(0,0,300,15,"");

	 SC=new SelectColor(M,3,530,420,65);
	 setPanels();
	 CON_T=new ControlTiling(110,10);
	 CON_G=new ControlGraph(110,10);
	 DOC=new Documentation();	 
	 CG=new ComputeGraph();
	 setAction();
     }



    public void setAction() {
         RESET_TILE=new ListenSquare(5,290,80,20,Color.white);
	 RESET_TILE.on=1;

         RESET_GRAPH=new ListenSquare(5,320,80,20,Color.white);
	 RESET_GRAPH.on=1;

         GO=new ListenSquare(3,230,30,20,new Color(200,0,200));
         GO.on=1;

         HALT=new ListenSquare(3,250,80,20,new Color(200,0,200));
         HALT.on=1;
    }

    public double getOffsetX() {
	return(CON_G.GC1.S1.getParameter());
    }

    public double getOffsetY() {
	double t=CON_G.GC1.S2.getParameter();
	return(t);
    }


    public double getOffsetX0() {
	return(CON_G.GC0.S1.getParameter());
    }

    public double getOffsetY0() {
	double t=CON_G.GC0.S2.getParameter();
	return(t);
    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      drawBG(g);
      drawAction(g);
      SC.render(g);
      EXPORT.render(g,0,143,100);
      MOUSE.render(g,0,58,100);
      GLOBAL.render(g,0,3,100);
      if(GLOBAL.mode==0) CON_T.render(g);
      if(GLOBAL.mode==1) CON_G.render(g);
   }


   public void drawBG(Graphics2D g) {
       g.setColor(new Color(0,40,60));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,30,80));
	g.fillRect(103,3,320,520);
	g.setColor(Color.white);
	g.drawRect(103,3,320,520);
    }


    public void drawAction(Graphics2D g) {  
       g.setFont(new Font("Helvetica",Font.PLAIN,12));
       g.setColor(Color.white);
       RESET_TILE.render(g,new Color(200,0,0)); 
       RESET_GRAPH.render(g,new Color(200,0,0)); 
       g.setColor(Color.white);

       int x=(int)(RESET_TILE.x+5);
       int y=(int)(RESET_TILE.y+12);
       g.drawString("reset tiles",x,y);

       x=(int)(RESET_GRAPH.x+5);
       y=(int)(RESET_GRAPH.y+12);
       g.drawString("reset graph",x,y);

       GO.render(g,new Color(200,0,0)); 
       x=(int)(GO.x+5);
       y=(int)(GO.y+12);
       g.drawString("go",x,y);

       if(CG.halt==1) {
         HALT.render(g,new Color(200,0,200));
         x=(int)(HALT.x+6);
         y=(int)(HALT.y+14);
         g.drawString("halt "+message,x,y);
       }
    }

    public void setPanels() {
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,new Color(200,0,200)};
	 Color[] C1={new Color(160,0,160),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(0,160,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C3={new Color(200,0,100),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C4={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

	 //mouse emulator
	 String[] MouseString={"not needed","button 1 (Z)","button 2 (X)", "button 3 (C)", "mouse emulator"};
	 int[] MouseState={1,0,0,0};
         MOUSE=new ControlPanel(C3,MouseString,MouseState,4);

	 //export 
	 String[] ExportString={"no", "yes", "export"};
	 int[] ExportState={1,0};
         EXPORT=new ControlPanel(C3,ExportString,ExportState,2);

	 //global
	 String[] GlobalString={"tiling", "graph", "controls"};
	 int[] GlobalState={0,1};
         GLOBAL=new ControlPanel(C3,GlobalString,GlobalState,2);
	 GLOBAL.mode=1;



    }


    public void resetTile() {
	M.P.tile=0;
	M.P.repaint();
    }

    public void resetGraph() {
	M.G.count=0;
	M.G.repaint();
    }


    public void mouseClicked(MouseEvent e) {	
        DOC.M=this.M;
	MouseData J=MouseData.process(e);
	int test=0;
	if(RESET_TILE.inside(J.X)==1) resetTile();
	if(RESET_GRAPH.inside(J.X)==1) resetGraph();
	int select_color=SC.process(e);
	if(select_color==20) DOC.colorSelectorInfo();
	int mouse= MOUSE.switchMode(J.X);
	if(mouse==20) DOC.mouse_info();
	int export = EXPORT.switchMode(J.X);
	if(export==20) DOC.export_info();
	int global=GLOBAL.switchMode(J.X);
	if(global==20) DOC.global_info();

	if(GLOBAL.mode==0) CON_T.process(e,SC.C,M);
	if(GLOBAL.mode==1) CON_G.process(e,SC.C,M);
	repaint();
	M.P.repaint();
	M.G.repaint();
	if(GO.inside(J.X)==1) doRun();
	if(HALT.inside(J.X)==1) CG.halt=0;
	
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {   
       CON_G.processKey(e);
       repaint();
    }
 
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}





    public void doRun() {
	 CG=new ComputeGraph(M.G.SOURCE,M);
         new Thread(CG).start();
    }





}

