import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlGraph {
    Manager M;
    ControlPanel COLORS,COORD;
    ControlPanelColor BASIC;
    Documentation DOC;
    SelectInteger[] I=new SelectInteger[15];
    int x,y;
    ListenSquare RENORM;
    GridControl GC0,GC1;
    GroupAction GA;

    public ControlGraph(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation();

	 RENORM=new ListenSquare(x,y+380,80,30,null);
	 RENORM.on=1;

	 setControlPanels();
	 setArrows();
	 GC1=new GridControl(450,10);   //this one has the action
	 GC0=new GridControl(450,370);

	 GA=new GroupAction(210,10);
    }




      public void setArrows() {
	 I[0]=new SelectInteger(x+2,y+274,32,16,5,0,18,1);  //block width
	 I[1]=new SelectInteger(x+2,y+298,32,16,5,0,18,1);  //block length
	 I[2]=new SelectInteger(x+2,y+230,40,20,7,0,18,1);  //graph length
	 I[3]=new SelectInteger(x+2,y+77,32,14,10,0,20,1);  //grid width
	 I[4]=new SelectInteger(x+2,y+94,36,18,0,0,1,1);  //grid dynamics 
	 I[5]=new SelectInteger(x+2,y+20,32,14,2,0,20,1);  //grid number
	 I[6]=new SelectInteger(x+2,y+40,32,14,10,0,15,1);  //grid lengths

	 I[10]=new SelectInteger(x+2,y+330,40,20,0,0,3,1);  //grid1 renorm
      }



 public void setControlPanels() {

   Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(50,100,255),Color.white,new Color(150,0,200,180),Color.red,Color.white,new Color(100,0,100,200),Color.orange};

	 String[] CoordString={"outer","grid","absolute","coords"};
	 int[] CoordState={1,0,0};
         COORD=new ControlPanel(C1,CoordString,CoordState,3);

 //toggle display of objects
	 String[] GraphShowString={"axes", "Z+Z","marker","b.line","bg","markings"};
         Color[]  GraphShowColor={new Color(100,100,200,200),new Color(0,100,100,100),new Color(255,0,255),new Color(255,0,255),new Color(0,0,0),Color.white};
	 int[] GraphShowState={0,0,1,1,0};
         BASIC=new ControlPanelColor(C1,GraphShowString,GraphShowState,5,GraphShowColor);
 }




    public void render(Graphics2D g) {
	RENORM.render(g,new Color(200,0,200));
	g.setColor(Color.white);
	g.drawString("get renorm",x+4,y+400);
         COORD.render(g,x,y+115,80); 
         BASIC.render(g,x,y,80); 
	 drawArrows(g);
	 GC0.render(g);
	 GC1.render(g);
	 GA.render(g,GC0,GC1);

    }

    public void doRenorm(Manager M) {
	double d=M.C.getOffsetY();
	int[] n=Renormalize.iteratedRenorm(d);
	for(int i=0;i<4;++i) GC1.S[i+1].val=n[i];
    }


    public void drawArrows(Graphics2D g) {

         g.setColor(new Color(0,0,255));	 
	 g.fillRect(x,y+210,90,115);
	 g.setColor(Color.white);
	 g.drawString("plot amount",x+10,y+222);
	 g.drawRect(x,y+210,90,115);

         I[0].render2(g,Color.red,Color.white,Color.white);
	 I[1].render2(g,Color.red,Color.white,Color.white);
	 I[2].render2(g,Color.red,Color.white,Color.white);
    }

    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
	int test1=BASIC.process(J.X,C);
	if(test1==20) DOC.basicInfo();
	COORD.switchMode(J.X);
	for(int i=0;i<3;++i) I[i].modify(J.X);
	GA.process(J.X,GC0,GC1);

	for(int j=3;j<=6;++j) I[j].modify(J.X);
	I[10].modifyCyclic(J.X);
	if(RENORM.inside(J.X)==1) doRenorm(MM);
	GC0.process(e,C,MM);
	GC1.process(e,C,MM);

    }

    public void processKey(KeyEvent e) {
	GC0.processKey(e);
	GC1.processKey(e);
    }

}

