import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentControlPanel {
    Manager M;
    public DocumentControlPanel(Manager MM) {
	this.M=MM;
    }



    public void display_info() {
	String S="There are a number of auxilliary markings which help make the pictures in Billiard King more clear. We have grouped these objects into 4 categories, and this window lets you select between the 5 categories.  Once you bring up one of the categories, you can then show, hide, and recolor the corresponding objects.";

	S=S+"\n\ngraph: these are objects associated to the arithmetic graph window.";
	S=S+"\n\ntiling: these are objects associated to the tiling window.";
	S=S+"\n\nstrips: these are again objects associated to the tiling window.  It turns out that one can decompose the first return map into 8 simpler maps based on a certain family of strips.  This result, which I call the Pinwheel Lemma, is proved by looking carefully at these strips.";

	S=S+"\n\ntorus: This option lets you access the picture on the Torus Partition Window.  To see the picture, click on the 'polytope' option and you will see some turquoise windows appear.  Drag the mouse over the big turquoise square with the X in it, and you will see the picture appear in the Polytope Exchange window.  You can read about this picture in the documentation for this window.";
	M.E.setExplain(S);
    }

    public void proof2_info() {
	String S="This module performs some computations from part III the monograph.  The computations are activated by the red GO button. There are 3 computations.";

	S=S+"\n\n embedding: These computations pertain to the Embedding Theorem.  They show that various polytopes in 4-space are disjoint.";
	S=S+"\n\n hex 1: These computations pertain to Statement 1 of the Hexagrid Theorem by showing that various polygonal regions are disjoint from various polytopes.";

	S=S+"\n\n hex 2: These computations pertain to Statement 2 of the Hexagrid Theorem by showing that various polygonal regions are disjoint from various polytopes.";

	S=S+"\n\nIn all these case, you can use the torus interface on Billiard King to visually check these computations. The control panel marked 'hex 1 proof' gives a visual tour of the computations associated to the 'hex 1' option on this control panel.  Likewise for 'hex2'.  I would like to do more work on this interface, to make the calculations more transparent.";


	M.E.setExplain(S);
	M.E.repaint();
    }


    public void global_info() {

	String S="control panel switch";
	S=S+"\n\nThis control panel brings forth the controls for the other windows.  The controls for these other windows appear in the dark green window just to the right of this control panel.  There are 2 options.\n\n";

	S=S+"1. The tiling window:  This window lets you draw pictures of the dynamically invariant outer billiards tiling.\n\n";
	S=S+"2. The arithmetic graph window: This window lets you see the arithmetic graph for outer billiards.";

	S=S+"\n\nWhen you click one of the buttons in this control panel, you will see the new controls appear.  You can learn about the function of these new controls using the question buttons on these controls.  You can generally operate one of the other windows without having first selected the controls for that window.  However, if you want to modify the various parameters for that window, you need to bring up the controls.";

	M.E.setExplain(S);
	M.E.repaint();
    }


  public void export_info() {

      String S="export switch";
	S=S+"\n\nWhen you set the option to 'yes' and then click on one of the picture windows, Billiard King writes the result to a tcl file and stores it in the Output subdirectory.  If you then run the tcl programs in this subdirectory, you can save the pictures to postscript.  This is a rather awkward procedure.  Mainly it is present for my own personal use, so that I can illustrate my papers.  Java does have its own postscript generating capabilities, but it is rather complicated and adds a lot of overhead to the program.\n\n ";  

	M.E.setExplain(S);
	M.E.repaint();
  }



  public void mouse_info() {

      String S="3 button mouse emulator";

      S=S+"\n\nBilliard King is designed to work with a 3 button mouse. Generally speaking\n   1. clicking button 1 scales up the picture\n   2. clicking button 2 selects a new point in the window.\n   3. clicking button 3 scales down the picture. \nOn the main control window, all mouse clicks have the same effect.";

      S=S+"\n\nIf you have a 3-button mouse, you should leave this control panel set at 'not needed'. If you don't have a 3 button mouse, you can use this control panel to force the type of mouse click, as indicated. You can also use the keys Z,X,C to simulate a 3 button mouse.";
      S=S+"\n\n(note: last feature is still under development.)";

	M.E.setExplain(S);
	M.E.repaint();
  }




	public void sanityInfo() {

	    String S="calculation selector";

	    S=S+"\n\nThis control panel lets you perform some of the calculations from the monograph.  The first computation serves as sanity check for the Pinwheel Lemma.  The last 3 calculations play the role of small but formal computer-aided proofs.   These calculations do not have much visible output.  The computer simply runs the calculations and then stop.  In several cases, a few lines are printed on the command line, assuming that the program is launched from a terminal. In principle, the user could trace through the code and verify that the given calculation is done.";

	S=S+"\n\npinwheel: This option lets you test the truth of the Pinwheel Lemma, from my papers.  The Pinwheel Lemma states that the first return map for outer billiards on kites is the product of 8 simpler maps, which I call strip maps. When you select this option, you then see 3 integer selectors appear below.  If the first integer selector says 256, it means that you are sampling the parameters 1/256,...,255/256 in the kite parameter interval (0,1).  If the second integer selector says 1024, it means that you are sampling 1024 points per unit.  If the third integer says 8, it means that you are sampling points from the sets (0,8) times {-1,1}. the total number of tests you make is the product of the 3 numbers. You can change these numbers, and their new meanings will be similar.";

	S=S+"\n\nembedding:  This option performs the computation for the Embedding Theorem in the monograph.  The computation shows that various 4 dimensional convex integer polytopes are disjoint.  It is a simple matter of linear algebra, and can also be seen visually using the demo for the Embedding Theorem on the Torus Partition Window.";

	S=S+"\n\nhexagrid 1:  This option performs the computation for Statement 1 of the Hexagrid Theorem in the monograph.  Again, the compution shows that various convex sets are disjoint.  This computation can be checked visually using the demo on the Torus Partition Window.";

	S=S+"\n\nhexagrid 2:  This option performs the computation for Statement 2 of the Hexagrid Theorem in the monograph.  Again, the compution shows that various convex sets are disjoint.  This computation can be checked visually using the demo on the Torus Partition Window.";

	M.E.setExplain(S);
	M.E.repaint();
    }



    public void resetInfo() {}


    public void colorSelectorInfo() {
        String S="color selector.";

S=S+"\n\nMany other parts of Billiard King plot pictures, and you can select the color of the plot using this interface.  You can click and drag the mouse in the three big bars to the left in order to change the red, green, and blue components of the color. You can also click or drag on the bottom bar in order to change the transparency level of the color.  It is best to experiment around to see how this works.  When you have altered the color selector the new color will appear in the vertical bar.";
        S=S+"\n\nThere is also a preset palette of colors on the right hand side of the color selector.  You can select these colors  by clicking on the squares.";
        M.E.setExplain(S);
        M.E.repaint();
    }






}


