import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class FareyTriangle {
    Vector[] V=new Vector[3];


    public FareyTriangle() {}

    public FareyTriangle(FareyTriangle T) {
	for(int i=0;i<3;++i) 	V[i]=new Vector(T.V[i]);
    }


    public FareyTriangle subdivide(int i,int j) {
	Vector w1=new Vector(V[i]);
	Vector w2=Vector.plus(V[i],V[j]);
	Vector w3=Vector.plus(w2,V[3-i-j]);
	FareyTriangle T=new FareyTriangle();
	T.V[0]=w1;
	T.V[1]=w2;
	T.V[2]=w3;
	return(T);
    }



    public static Complex toComplex(Vector V) {
	Complex[] z=new Complex[3];
	z[0]=new Complex(0,1);
	z[1]=new Complex(0,-1);
	z[2]=new Complex(1,0);

	double[] d=new double[3];
	for(int i=0;i<3;++i) {
	    d[i]=V.x[i]/(V.x[0]+V.x[1]+V.x[2]);
	}

	for(int i=0;i<3;++i) z[i]=Complex.times(z[i],new Complex(d[i],0));
	Complex w=new Complex();
	w.x=z[0].x+z[1].x+z[2].x;
	w.y=z[0].y+z[1].y+z[2].y;
	return(w);
    }


    public static float[] toPoint(Vector V) {
	Complex w=toComplex(V);
	float x=(float)(w.x);
	float y=(float)(w.y);
	float[] f={x,y};
	return(f);
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	float[][] f=new float[3][2];
	for(int i=0;i<3;++i) f[i]=toPoint(V[i]);
	gp.moveTo(f[0][0],f[0][1]);
	gp.lineTo(f[1][0],f[1][1]);
	gp.lineTo(f[2][0],f[2][1]);
	gp.closePath();
	return(gp);
    }

    public double minSide() {
	Complex[] z=new Complex[3];
	for(int i=0;i<3;++i) z[i]=toComplex(V[i]);
	double d=10;
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		double dd=Complex.dist(z[i],z[j]);
		if((i!=j)&&(d>dd)) d=dd;
	    }
	}
	return(d);
    }



    public int inside(Complex z) {
	GeneralPath gp=this.toGeneralPath();
	if(gp.contains(z.x,z.y)==true) return(1);
	return(0);
    }

}


