import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class GraphCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Complex SOURCE=new Complex(0,0);
    Complex SOURCE2=new Complex(0,0.0001);
    GeneralPath[] X=new GeneralPath[100000];
    Color[] COL=new Color[100000];
    int[] type=new int[100000];
    int count=0;  
    Point JX;
    ComputeGraph CG;
    ListenSquare L;
    SelectInteger[] THICK=new SelectInteger[2];

    public GraphCanvas addManager(Manager M) {
	GraphCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public GraphCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,30);
	 CG=new ComputeGraph();
	 L=new ListenSquare(0,0,0,44,Color.white);
	 L.on=1;
	 THICK[0]=new SelectInteger(100,10,40,20,1,1,5,1);
	 THICK[1]=new SelectInteger(250,10,40,20,1,1,5,1);
     }

    public void nextPath(GeneralPath gp,Color COL0,int t) {
	X[count]=new GeneralPath(gp);
	COL[count]=COL0;
	type[count]=t;
	++count;
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBackground(g);
      drawMarkings(g);
      drawPaths(g);
      drawControls(g);
   }

    public void drawPaths(Graphics2D g) {
	int export=M.C.EXPORT.mode;
	Output temp=new Output();
	if(export==1) temp=new Output("Output/graph");
	double A=Math.sqrt(5)-2;
	int choice=M.C.CON_G.COORD.mode;

	GeneralPath gp=new GeneralPath();
	int t=1;

        g.setStroke(new BasicStroke((float)(THICK[1].val)));
	for(int i=0;i<count;++i) {   
	    t=type[i]-1;
	    if(t==1) {
	      gp=new GeneralPath(X[i]);
	      gp=transform(gp,A,choice);
	      g.setColor(COL[i]);
	      g.draw(gp);
	      if(export==1) temp.blockWrite(gp,COL[i],THICK[1].val);
	    }
	}

        g.setStroke(new BasicStroke((float)(THICK[0].val)));
	for(int i=0;i<count;++i) {   
	    t=type[i]-1;
	    if(t==0) {
	      gp=new GeneralPath(X[i]);
	      gp=transform(gp,A,choice);
	      g.setColor(COL[i]);
	      g.draw(gp);  
              if(export==1) temp.blockWrite(gp,COL[i],THICK[0].val);
	    }
	}

        g.setStroke(new BasicStroke(4));
	for(int i=0;i<count;++i) {   
	    t=type[i]-1;
	    if(t==2) {
	      gp=new GeneralPath(X[i]);
	      gp=transform(gp,A,choice);
	      g.setColor(COL[i]);
	      g.draw(gp);  
              if(export==1) temp.blockWrite(gp,COL[i],4);
	    }
	}



	g.setStroke(new BasicStroke(1));
    }




    public void drawBackground(Graphics2D g) {
	Color COL=Color.black;
	try {
	    COL=M.C.CON_G.BASIC.M[4].C;
	}
	catch(Exception e) {}
	g.setColor(COL);
	g.fillRect(0,0,getWidth(),getHeight());  
    }

    public void drawControls(Graphics2D g) {
        L.w=this.getWidth();
        L.render(g,new Color(0,0,255));
	THICK[0].render(g,Color.red,Color.red,Color.white);
	THICK[1].render(g,Color.red,Color.red,Color.white);	
        Integer X0=new Integer((int)(SOURCE.x));
	Integer X1=new Integer((int)(SOURCE.y));
        g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(Color.white);
	g.drawString(X0.toString(),6,20);
	g.drawString(X1.toString(),6,40);
    }




    public void drawMarkings(Graphics2D g) {
	double A=Math.sqrt(5)-2;
	int choice=M.C.CON_G.COORD.mode;
	if(M.C.CON_G.BASIC.L[0].on==1) GraphMarkings.drawAxes(g,M);
	if(M.C.CON_G.BASIC.L[1].on==1) GraphMarkings.drawGrid(g,M);
        if(M.C.CON_G.BASIC.L[2].on==1) drawSource(g,M.C.CON_G.BASIC.M[2].C,SOURCE,.25,A,choice);
        if(M.C.CON_G.BASIC.L[2].on==1) drawSource(g,M.C.CON_G.BASIC.M[2].C,SOURCE2,.01,A,choice);
	if(M.C.CON_G.BASIC.L[3].on==1) GraphMarkings.drawBaseline(g,M);	
	GraphMarkings.grid(g,M);
    }

    public void drawSource(Graphics2D g) {
    }



    public double[] boundingBox(Manager M) {

	int width=this.getWidth();
	int height=this.getHeight();
	Point P0=new Point();
	P0.x=0;
	P0.y=height;
	double a=Math.sqrt(5)-2;
	int choice=M.C.CON_G.COORD.mode;
	Complex z0=unTransform(P0,a,choice);
	P0.x=width;
	P0.y=0;
	Complex z1=unTransform(P0,a,choice);
	if(choice==0) {
	   z1=Complex.minus(z1,z0);
	   double[] d={z0.x,z0.y,z1.x,z1.y};
	   return(d);
	}

	double w=Complex.dist(z0,z1);
	Complex zz=Complex.average(z0,z1);
	double[] d={zz.x-5*w,zz.y-5*w,10*w,10*w};
	return(d);
    }








     public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

    public void mouseDragged(MouseEvent e) {}


   public void mouseMoved(MouseEvent e) {
       try {MouseData J=MouseData.process(e,M.C.MOUSE.mode);
	   JX=J.X; }
       catch (Exception ee) {}
   }


   public void mouseClicked(MouseEvent e) { 
       MouseData J=MouseData.process(e,M.C.MOUSE.mode);
       doMouseClick(J.X,J.mode);
   }



    public void doMouseClick(Point JX,int mode) {
      if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;
      double a=Math.sqrt(5)-2;
	int choice=M.C.CON_G.COORD.mode;
      if(L.inside(JX)==0) {
        if(mode==1) scaleUp(JX,-1);
        if(mode==3) scaleUp(JX,+1);
	if(mode==2) {
            Complex temp=unTransform(JX,a,choice);
	    SOURCE.x=Math.floor(temp.x+.5);
	    SOURCE.y=Math.floor(temp.y+.5);
	    SOURCE2.x=temp.x;
	    SOURCE2.y=temp.y;
	}
      }
	THICK[0].modify(JX);
	THICK[1].modify(JX);
	repaint();
	M.P.repaint();
    }




    public void keyTyped(KeyEvent e) {

	char ch=e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(test>0) doMouseClick(JX,test);

	if(ch=='a') forceGo(0);
	if(ch=='s') forceGo(1);
    }
 
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

    public void forceGo(int j) {
	M.C.CON_G.GC1.ACTION.forceMode(j);
	M.C.repaint();
    	CG=new ComputeGraph(SOURCE,M);
        new Thread(CG).start();
    }



}
