import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GraphMarkings {
    public GraphMarkings() {
    }




    public static void drawAxes(Graphics2D g,Manager M) {

	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,-100);
	gp.lineTo(0, 100);
	gp.moveTo(-100,0);
	gp.lineTo( 100,0);
	double A=Math.sqrt(5)-2;
	int choice=M.C.CON_G.COORD.mode;
	gp=M.G.transform(gp,A,choice);
	g.setColor(M.C.CON_G.BASIC.M[0].C);
	g.draw(gp);
    }

    public static void drawGrid(Graphics2D g,Manager M) {

	GeneralPath gp=new GeneralPath();
	for(int i=-50;i<50;++i) {
	    gp.reset();
	    Complex z=M.G.SOURCE;
	    int x=(int)(z.x);
	    int y=(int)(z.y);
	    gp.moveTo(x+i,y-50);
	    gp.lineTo(x+i,y+50);
	    gp.moveTo(x-50,y+i);
	    gp.lineTo(x+50,y+i);
	    double A=Math.sqrt(5)-2;
            int choice=M.C.CON_G.COORD.mode;
	    gp=M.G.transform(gp,A,choice);
	    g.setColor(M.C.CON_G.BASIC.M[1].C);
	    g.draw(gp);
	}
    }



    public static void drawBaseline(Graphics2D g,Manager M) { 
	Output temp=new Output();
	if(M.C.EXPORT.mode==1) temp=new Output("Output/baseline");
	double d=M.C.getOffsetX();
	GeneralPath gp=new GeneralPath();  
        double A=Math.sqrt(5)-2;
	 gp.moveTo(-100,(float)( 100*A-.5*d));
	 gp.lineTo( 100,(float)(-100*A-.5*d));
         int choice=M.C.CON_G.COORD.mode;
         gp=M.G.transform(gp,A,choice);
  	 Color COL=M.C.CON_G.BASIC.M[3].C;
  	 g.setColor(COL);
  	 g.draw(gp);
	 if(M.C.EXPORT.mode==1) temp.lineWrite(gp,COL,1);
    }


    public static void grid(Graphics2D g,Manager M) {
	grid0(g,M);
	grid1(g,M);
    }


    public static void grid0(Graphics2D g,Manager M) {
	int absolute=0;
        if(M.C.CON_G.COORD.mode==2) absolute=1;;

      Renormalize R=new Renormalize(M,0);
      double A=Math.sqrt(5)-2;
      Color CC=Color.white;
      GeneralPath gp=new GeneralPath();
      int parity=M.C.CON_G.GC0.S[0].val;

      for(int i=0;i<5;++i) {
	      for(int j=1;j<=4;++j) {
		  int jj=(j-1)/2;  
                  CC=M.C.CON_G.GC0.CP[i].M[jj].C;
                  int test=M.C.CON_G.GC0.CP[i].L[jj].on;  
                  int choice2=M.C.CON_G.COORD.mode;

		    if(test==1) {
		      gp=R.finalGrid0(i,j,parity,absolute);  
                      gp=M.G.transform(gp,A,choice2);
                      g.setColor(CC);
                      g.draw(gp); 
		    }
	      }
      }
    }


    public static void grid1(Graphics2D g,Manager M) {
	int absolute=0;
        if(M.C.CON_G.COORD.mode==2) absolute=1;;
	Renormalize R=new Renormalize(M,1);
      double A=Math.sqrt(5)-2;
      Color CC=Color.white;
      GeneralPath gp=new GeneralPath();
      int parity=M.C.CON_G.GC1.S[0].val;

      for(int i=0;i<5;++i) {
	      for(int j=1;j<=4;++j) {
		  int jj=(j-1)/2;  
                  CC=M.C.CON_G.GC1.CP[i].M[jj].C;
                  int test=M.C.CON_G.GC1.CP[i].L[jj].on;  
                  int choice2=M.C.CON_G.COORD.mode;
		    if(test==1) {
			gp=R.finalGrid1(i,j,parity,absolute);  
                      gp=M.G.transform(gp,A,choice2);
                      g.setColor(CC);
                      g.draw(gp); 
		    }
	      }
      }
    }







}
