import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class GridControl {
    Manager M;
    int x,y;
    ControlPanelColor[] CP=new ControlPanelColor[5];

    ListenSquare[] L=new ListenSquare[5];
    SelectInteger[] S=new SelectInteger[5];
    ShapeEntryBasic S1,S2;
    ControlPanelColor ACTION;


    public GridControl(int X,int Y) {

	x=X;
	y=Y;
	for(int i=0;i<5;++i) {
   	   L[i]=new ListenSquare(x+66*i,y+180,20,20,Color.white);
	   S[i]=new SelectInteger(-6+x+66*i,y+205,30,15,0,1,3,1);
	}
	S[0]=new SelectInteger(-6+x,y+205,40,20,1,1,2,1);  //parity


       Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};

       Color[][] GridColor=new Color[5][3];

       GridColor[0][0]=new Color(160,0,0);
       GridColor[0][1]=new Color(0,0,160);
       GridColor[0][2]=new Color(30,80,255);

       GridColor[1][0]=new Color(240,80,0);
       GridColor[1][1]=new Color(0,80,240);
       GridColor[1][2]=new Color(0,250,200);

       GridColor[2][0]=new Color(255,150,50);
       GridColor[2][1]=new Color(0,150,250);
       GridColor[2][2]=new Color(250,0,250);

       GridColor[3][0]=new Color(255,0,250);
       GridColor[3][1]=new Color(255,0,250);
       GridColor[3][2]=new Color(255,0,250);

       GridColor[4][0]=new Color(25,250,250);
       GridColor[4][1]=new Color(255,0,250);
       GridColor[4][2]=new Color(25,250,250);

       String[] GridString={"P","Q","d","grid"};

       int[] GridState={0,0,0};

       for(int i=0;i<5;++i) {
         CP[i]=new ControlPanelColor(C0,GridString,GridState,3,GridColor[i]);
       }

       S1=new ShapeEntryBasic(x,y);
       S2=new ShapeEntryBasic(x,y+45);
       S1.I[0].val=0;
       S1.I[1].val=1;
       S2.I[0].val=1;
       S2.I[1].val=1;

	 //object actions
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={Color.white,new Color(50,100,255)};
	 String[] ActionString={"outer path","outer all","action"};
	 int[] ActionState={1,0};
         ACTION=new ControlPanelColor(C1,ActionString,ActionState,2,C2);
	 ACTION.mode=1;

    }


    public void setOffsets(double offsetX,double offsetY) {
	int[] a1=MathRational.approximate(offsetX,.00000001);
	int[] a2=MathRational.approximate(offsetY,.00000001);
	S1.I[0].val=a1[0];
	S1.I[1].val=a1[1];
	S2.I[0].val=a2[0];
	S2.I[1].val=a2[1];
    }


    //force controls
    public void setParity(int k) {
	S[0].val=k;
    }

    public void setRenorm(int k,int q) {
	for(int i=0;i<5;++i) L[i].on=0;
	for(int i=0;i<5;++i) {
	    for(int j=0;j<3;++j) {
		CP[i].L[j].on=0;
	    }
	}
	L[k].on=1;
	S[k].val=q;
        for(int j=0;j<3;++j) {
		CP[k].L[j].on=1;
	}

    }





    public void changeState(Point X) {
	for(int i=0;i<5;++i) {
	    if(L[i].inside(X)==1) {
                  L[i].on=1-L[i].on;
	          for(int j=0;j<3;++j) CP[i].L[j].on=L[i].on;
	    }
	}

    }





    public void render(Graphics2D g) {
	for(int i=0;i<5;++i) {
               L[i].render(g,Color.red);
	       if(i>0) S[i].render(g,Color.red,Color.white,Color.white);
	       if(i==0) S[i].render(g,Color.green,Color.white,Color.white);
	       CP[i].render(g,-6+x+66*i,y+100,46);
	}	
        S1.render(g);
	S2.render(g);  
	ACTION.render(g,x+200,y,100);
    }

    public void process(MouseEvent e,Color C,Manager MM) {
        MouseData J=MouseData.process(e);
	changeState(J.X);
	for(int i=0;i<5;++i) S[i].modifyCyclic(J.X);
	for(int i=0;i<5;++i) CP[i].process(J.X,C);	
        ACTION.process(J.X,C);
	S1.processMouse(e);
	S2.processMouse(e);
    }

    public void processKey(KeyEvent e) {
	S1.processKey(e);
	S2.processKey(e);
    }


}