import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class GroupAction {
    int x,y;
    double A;
    ListenSquare[] MAP=new ListenSquare[15];
    ListenTriangle[] FRAC = new ListenTriangle[10];
    ListenSquare BIG,FINE;
    double FINE_PARAMETER;
    AffineTransform AFF1,AFF2;

    public GroupAction(int X,int Y) {
	this.x=X;
	this.y=Y;  
        A=Math.sqrt(5)-2;
        setBars();
	setTriangles();  
      
    }


   public void setBars() {
	MAP[0]=new ListenSquare(x,y+f(A),20,300*A,null);	
	MAP[1]=new ListenSquare(x,y+f(1),20,300*A,null);	
	MAP[2]=new ListenSquare(x,y+f(1-A),20,600*phi(-4),null);
	MAP[3]=new ListenSquare(x,y+f(1-A-2*phi(-4)),20,300*phi(-5),null);
	MAP[4]=new ListenSquare(x,y+f(2*phi(-4)),20,300*phi(-6),null);
	MAP[5]=new ListenSquare(x,y+f(phi(-2)),20,300*phi(-8),null);   //top
	MAP[6]=new ListenSquare(x,y+f(phi(-2)-phi(-8)),20,-300*phi(-8)+300*phi(-5),null); 
	BIG=new ListenSquare(x,y,211,500,null);
	for(int i=0;i<7;++i) MAP[i].on=1;
   }


    public Complex shrink(Complex z1,Complex z2) {
	Complex z3=new Complex();
	z3.x=(1-A)*z1.x+A*z2.x;
	z3.y=(1-A)*z1.y+A*z2.y;
	return(z3);
    }

    public void setTriangles() {

	Complex z1=new Complex(A,0);
	Complex z2=new Complex(0,1);
	Complex z3=new Complex(phi(-1),phi(1));

	Complex z31=shrink(z3,z1);
	Complex z32=shrink(z3,z2);
	Complex z21=shrink(z2,z1);
	Complex z23=shrink(z2,z3);
	Complex z12=shrink(z1,z2);
	Complex z13=shrink(z1,z3);

	Complex w21=new Complex(2*A-z21.x,z21.y);
	Complex w23=new Complex(2*A-z23.x,z23.y);
	Complex w2=new Complex(2*A-z2.x,z2.y);

	Complex w13=new Complex(2*A-z13.x,z13.y);
	Complex w12=new Complex(2*A-z12.x,z12.y);
	Complex w1=new Complex(2*A-z1.x,z1.y);

	FRAC[0]=new ListenTriangle(z1,z2,z3);
	FRAC[1]=new ListenTriangle(z31,z32,z3); 
	FRAC[2]=new ListenTriangle(z13,z12,z1); 
 	FRAC[3]=new ListenTriangle(z21,z23,z2);   
 	FRAC[4]=new ListenTriangle(w21,w23,w2);     
 	FRAC[5]=new ListenTriangle(w12,w13,w1);  

        AFF1=AffineTransform.getScaleInstance(300,-300);
	AFF2=AffineTransform.getTranslateInstance(x+25,y+500);

    }


    public double f(double h) {
	return(500-300*h);
    }

    public static double phi(double n) {  
        double PHI=(1+Math.sqrt(5))/2;
	return(Math.pow(PHI,n));
    }



    public void render(Graphics2D g,GridControl GC0,GridControl GC1) {
	drawBars(g);
	drawTriangles(g);
	drawMarkers(g,GC0,GC1);
    }


    //fits inside interval [d0,d1]

    public double fit(double d0,double d1,double x) {
	double y=(1-x)*d0+x*d1;
	return(y);
    }


   public void drawBars(Graphics2D g) {
	BIG.renderSmooth(g,Color.black,Color.white);
	MAP[0].renderSmooth(g,Color.red,Color.white);
	MAP[1].renderSmooth(g,Color.red,Color.white);
	MAP[2].renderSmooth(g,new Color(0,0,255),Color.white);
	MAP[3].renderSmooth(g,new Color(50,100,255),Color.white);
	MAP[4].renderSmooth(g,new Color(0,235,0),Color.white);
	MAP[5].renderSmooth(g,new Color(0,200,0),Color.white);
	MAP[6].renderSmooth(g,new Color(0,180,0),Color.white);
     }
	
    public void drawMarkers(Graphics2D g,GridControl GC0,GridControl GC1) {

	    GeneralPath gp=new GeneralPath();

	double t=GC1.S2.getParameter();
	gp=new GeneralPath();
	gp.moveTo((float)(x+5),(float)(y+f(t)));
	gp.lineTo((float)(x+210),(float)(y+f(t)));
	g.setColor(Color.white);
	g.draw(gp);

	t=GC0.S2.getParameter();
	gp=new GeneralPath();
	gp.moveTo((float)(x+20),(float)(y+f(t)));
	gp.lineTo((float)(x+195),(float)(y+f(t)));
	g.setColor(Color.orange);
	g.draw(gp);	


	t=FINE_PARAMETER;
	gp.reset();
	gp.moveTo((float)(x+65),(float)(y+f(t)));
	gp.lineTo((float)(x+75),(float)(y+f(t)));
	g.setColor(Color.orange);
	g.draw(gp);	
        g.setStroke(new BasicStroke(1));
	}


    public GeneralPath transform(GeneralPath gp) {
	GeneralPath gp2=new GeneralPath(gp);
	gp2.transform(AFF1);
	gp2.transform(AFF2);
	return(gp2);
    }

     public void drawTriangles(Graphics2D g) {
	GeneralPath gp=new GeneralPath();

	 for(int i=0;i>=0;--i) {
	  gp=FRAC[i].getPath();
	  gp=transform(gp);
	  g.setColor(new Color(50,155,200));
	  g.fill(gp); 
	  g.setColor(Color.white);
	  g.draw(gp);
	}

	 for(int i=5;i>=1;--i) {
	  g.setColor(Color.blue);
	  gp=FRAC[i].getPath();
	  gp=transform(gp);
	  g.fill(gp); 
	  g.setColor(Color.white);
	  g.draw(gp);
	}


     }


     public void doMap0(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    x1=A;
	    double x2=A;
	    double y2=y1/A;

	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x2,y2);
	    GC1.setRenorm(0,0);
	    GC1.setParity(1);
	    GC0.setRenorm(0,0);  
            GC0.setParity(1);
     }


     public void doMap1(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(0,y1);
	    GC0.setOffsets(0,y2);
	    GC1.setRenorm(1,0);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
            GC0.setParity(1);
     }

     public void doMap2(GridControl GC0,GridControl GC1) {

	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    x1=phi(1)+phi(-3);
            x1=phi(-2)-phi(-6);

	    double y2=2*phi(-2)-y1;
            double x2=phi(-4);

	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x2,y2);
	    GC1.setRenorm(1,2);
	    GC0.setRenorm(0,0);   
            GC1.setParity(1);
	    GC0.setParity(1);
     }



     public void doMap3(GridControl GC0,GridControl GC1) {

	    double y1=GC1.S2.getParameter();
            double x2=phi(-4);
	    double x1=phi(1)+phi(-3);
	    x1=phi(-2)-phi(-6);

	    double y2=2*phi(-2)-y1;
	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x2,y2);
	    GC0.setRenorm(1,0);
	    GC0.setParity(1);
	    GC1.setParity(1);
	    GC1.setRenorm(1,2);
     }

     public void doMap4(GridControl GC0,GridControl GC1) {
	    double y1=GC1.S2.getParameter();
            double x1=phi(-2)-phi(-6);
	    double y2=2-y1/A;
	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x1,y2);
	    GC0.setRenorm(1,0);
	    GC0.setParity(1);
	    GC1.setParity(1);
	    GC1.setRenorm(1,2);
     }


     public void doMap5(GridControl GC0,GridControl GC1) {
	    double y1=GC1.S2.getParameter();
            double x1=phi(-2)-phi(-6);
	    double y2=2-y1/A;
	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x1,y2);
	    GC0.setRenorm(1,2);
	    GC0.setParity(1);
	    GC1.setParity(1);
	    GC1.setRenorm(1,0);
	    GC1.setRenorm(2,0);
     }


     public void doMap6(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
            x1=phi(-2)-phi(-6);
	    double y2=2-y1/A;
	    GC1.setOffsets(x1,y1);
	    GC0.setOffsets(x1,y2);
	    GC0.setRenorm(1,2);
	    GC0.setParity(1);
	    GC1.setParity(1);
	    GC1.setRenorm(1,0);
     }




    public void doMap11(GridControl GC0,GridControl GC1) {
	doMap1(GC0,GC1);
    }


     public void doMap12(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(0,y1);
	    GC0.setOffsets(0,y2);
	    GC1.setRenorm(1,2);
	    GC1.setRenorm(2,0);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
	    GC0.setRenorm(1,2);
            GC0.setParity(1);
     }

     public void doMap13(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(0,y1);
	    GC0.setOffsets(0,y2);
	    GC1.setRenorm(1,2);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
	    GC0.setRenorm(1,2);
            GC0.setParity(1);
     }


     public void doMap14(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(2*A,y1);
	    GC0.setOffsets(2*A,y2);
	    GC1.setRenorm(1,0);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
            GC0.setParity(1);
     }


     public void doMap15(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(2*A,y1);
	    GC0.setOffsets(2*A,y2);
	    GC1.setRenorm(1,2);
	    GC1.setRenorm(2,0);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
	    GC0.setRenorm(1,2);
            GC0.setParity(1);
     }

     public void doMap16(GridControl GC0,GridControl GC1) {
	    double x1=GC1.S1.getParameter();
	    double y1=GC1.S2.getParameter();
	    double y2=(y1+A-1)/A;
	    GC1.setOffsets(2*A,y1);
	    GC0.setOffsets(2*A,y2);
	    GC1.setRenorm(1,2);
	    GC1.setParity(0);
	    GC0.setRenorm(0,0);
	    GC0.setRenorm(1,2);
            GC0.setParity(1);
     }














    public void triangleMap1(GridControl GC0,GridControl GC1) {
	    double y1=GC1.S2.getParameter();
	    double y2=y1/A - 1 - 1/A;
	    GC1.setOffsets(phi(-1),y1);
	    GC0.setOffsets(-phi(-4),y2);
	    GC1.setRenorm(1,0);
	    GC1.setParity(1);
	    GC0.setRenorm(0,0);
            GC0.setParity(1);
     }


    public void triangleMap2(GridControl GC0,GridControl GC1) {
	doMap0(GC0,GC1);
     }

    public void triangleMap3(GridControl GC0,GridControl GC1) {
        double y1=GC1.S2.getParameter();
	if(y1<=1) doMap11(GC0,GC1);
	if((y1>1)&&(y1<1+phi(-6))) doMap12(GC0,GC1);
	if(y1>1+phi(-6)) doMap13(GC0,GC1);
     }

    public void triangleMap4(GridControl GC0,GridControl GC1) {
        double y1=GC1.S2.getParameter();
	if(y1<=1) doMap14(GC0,GC1);
	if((y1>1)&&(y1<1+phi(-6))) doMap15(GC0,GC1);
	if(y1>1+phi(-6)) doMap16(GC0,GC1);
     }





    public void process(Point X,GridControl GC0,GridControl GC1) {
	setParameter(X,GC1);
	doMap(X,GC0,GC1);
	doMap2(X,GC0,GC1);
    }


    public void setParameter(Point X,GridControl GC1) {
        if(BIG.inside(X)==1) {
         double x1=GC1.S1.getParameter();
	 double t=1-1.0*(X.y-y-200)/300;
         GC1.setOffsets(x1,t+.00001*FINE_PARAMETER);
	}
    }

   public void doMap(Point X,GridControl GC0,GridControl GC1) {
	 if(MAP[0].inside(X)==1) doMap0(GC0,GC1);
	 if(MAP[1].inside(X)==1) doMap1(GC0,GC1);
	 if(MAP[2].inside(X)==1) doMap2(GC0,GC1);
	 if(MAP[3].inside(X)==1) doMap3(GC0,GC1);
	 if(MAP[4].inside(X)==1) doMap4(GC0,GC1);
	 if(MAP[5].inside(X)==1) doMap5(GC0,GC1);
	 if(MAP[6].inside(X)==1) doMap6(GC0,GC1);
   }


   public void doMap2(Point X,GridControl GC0,GridControl GC1) {
       int test=-1;
       for(int i=1;i<5;++i) {
         GeneralPath gp=FRAC[i].getPath();
         gp=transform(gp);
	 if(gp.contains(X.x,X.y)==true) test=i;
       }

       if(test==1) triangleMap1(GC0,GC1);
       if(test==2) triangleMap2(GC0,GC1);
       if(test==3) triangleMap3(GC0,GC1);
       if(test==4) triangleMap4(GC0,GC1);
   }



}

