import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class KiteGrid {
    Manager M;


    public KiteGrid() {}




    public static double[] tube(int N,double width,double offset1,double offset2,double offset3,int k,int parity) {

	double slope=(3-Math.sqrt(5))/2;
	double x,y,z;
	int count=0;
	double[] n=new double[2*N+1];
	double test=0;
	for(int i=-N;i<N;++i) {
	    x=i+offset2;
	    z=1.0*x*slope;
	    for(int j=-2;j<=2;++j) {
		y=Math.floor(x*slope)+j;
		test=Math.abs(y-z+offset1); 

		if(test<width/4.0+.0000001) {
		    n[count]=x;
		    n[count]=project(x,y,offset3);
		    ++count;
		}
	    }
	}
	double[] m=new double[count];
	for(int i=0;i<count;++i) m[i]=n[i];
	return(m);
    }

    public static double project(double x,double y,double offset) {
	double phi=(1+Math.sqrt(5))/2.0;
	double a=phi*phi;
	double b=1/a;
	double z=(a*x-y)/(a-b);
	z=z+offset;
	return(z);
    }




    public static double[] fixOffset(double x0) {
	double x1=x0/2;
	double[] y=new double[2];
	y[0]=Math.floor(x1);
	y[1]=x1-Math.floor(x1);
	y[0]=2*y[0];
	y[1]=2*y[1];
	return(y);
    }

    /*
    offset 1:  this is the amount the strip is shifted in the plane
    offset 2:  this is the amount the lattice is horizontally shifted
    offset 3:  this is the amount the final grid lines are shifted
    */




    public static double[] doGrid(int k,double width,double offset,int parity) {
	double A=Math.sqrt(5)-2;
	double phi=(1+Math.sqrt(5))/2;
	double width2=width;

	//double[] fix=fixOffset(offset0);
	//double offset=fix[1];

	double offset1=(offset+1)/4.0;
	double offset2=0;
	double offset3=0;
        if(parity==0) offset1=(offset-1)/4;

	if(k<=2) {
            offset1=(offset-1)/4.0;
            offset2=.5;
            offset3=A;
	    width2=width2*A;
	    if(parity==0) offset1=(offset+1)/4.0;
	}

	double[] x=tube(20000,width2,offset1,offset2,offset3,k,parity);
	return(x);
    }





    public static double[] specialVector(int k) {
	double[] d=new double[2];
	if(k==1) {d[0]=1; d[1]=-Math.sqrt(5)+1;}
	if(k==2) {d[0]=1; d[1]=.5*(3-Math.sqrt(5));}
	if(k==3) {d[0]=0; d[1]=1;}
	if(k==4) {d[0]=-1; d[1]=-.5*(5-Math.sqrt(5));}
	return(d);
    }

    public static double[] unitize(double[] x) {
	double d=Math.sqrt(x[0]*x[0]+x[1]*x[1]);
	double[] y=new double[2];
	y[0]=x[0]/d;
	y[1]=x[1]/d;
	return(y);
    }

    public static double[] specialPerp(int k) {
	double[] x=specialUnit(k);
	double[] y={-x[1],x[0]};
	return(y);
    }

    public static double[] specialUnit(int k) {
	double[] x=specialVector(k);
	double[] y=unitize(x);
	return(y);
    }

}

  