import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class MouseCanvas extends Canvas implements MouseListener {
    ListenSquare[] L=new ListenSquare[8];
    int mouse,mode;
    Manager M;
    
    public  MouseCanvas() {
        addMouseListener(this);
        L[1]=new ListenSquare(3,3,25,Color.white);
        L[2]=new ListenSquare(32,3,25,Color.white);
        L[3]=new ListenSquare(3,80,16,Color.white);
        L[4]=new ListenSquare(22,80,16,Color.white);
        L[5]=new ListenSquare(41,80,16,Color.white);
        L[6]=new ListenSquare(3,104,12,12,Color.black);
        L[6].on=1;
        L[2].on=1;
        L[4].on=1;
        mouse=1;
        mode=2;
    }

    public MouseCanvas addManager(Manager M) {
	MouseCanvas Q=this;
	Q.M=M;
	return(Q);
    }



    
    public void paint(Graphics gfx) {
        Graphics2D g=(Graphics2D) gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
        
        Dimension D=this.getSize();
        g.setColor(new Color(100,0,100));
        g.fillRect(0,0,D.width-1,D.height-1);
        for(int i=1;i<=2;++i) L[i].render(g,Color.blue);
        
        
        if(mouse==0) {
            for(int i=3;i<=5;++i) L[i].render(g,Color.blue);
        }
        g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
        g.drawString("1",13,19);
        g.drawString("3",42,19);
        g.drawString("mouse",12,42);
        if(mouse==0) g.drawString("mode",14,74);
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
    }
    
    
    public void mouseReleased(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();
        int test=0;
        for(int i=1;i<=6;++i) {
            if(L[i].inside(X)==1) test=i;
        }
        
        
        if(test==1) {
            mouse=0;
            mode=2;
            L[1].on=1;
            L[2].on=0;
            L[3].on=0;
            L[4].on=1;
            L[5].on=0;
        }
        if(test==2) {
            mouse=1;
            L[2].on=1;
            L[1].on=0;
        }
        if((mouse==0)&&(test>2)) {
            mode=test-2;
            L[3].on=0;
            L[4].on=0;
            L[5].on=0;
            L[test].on=1;
        }
        repaint();        
    }
    
    public int determineMode(MouseEvent e) {
	if(mouse==0) return(mode);
	if(mouse==1) {
	    if(e.getButton()==MouseEvent.BUTTON1) return(1);
	    if(e.getButton()==MouseEvent.BUTTON2) return(2);
	    if(e.getButton()==MouseEvent.BUTTON3) return(3);
	}
	return(0);
    }




    
}
