

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class Orbiter {
    public Orbiter() {}



    public static int goodVertex(Complex w,Quad Q,int j) {
	for(int i=0;i<4;++i) {
	    if(i!=j) {
		if(ConvexIntersector.orientation(w,Q.z[j],Q.z[i])==-1) return(0);
		if(Complex.dist(w,Q.z[i])<.00001) return(0);
	    }
	}
	return(1);
    }


    public static int findGoodVertex(Complex w,Quad Q) {

	int test=0;
	for(int i=0;i<4;++i) {
	    test=goodVertex(w,Q,i);
	    if(test==1) return(i);
	}
	return(-1);
    }


    public static String generateString(Complex w,Quad QQ) {
	String W="";
	Quad Q=new Quad();
	for(int i=0;i<4;++i) 	Q.z[i]=QQ.z[i];

	int digit=0;
	Integer DIGIT=new Integer(0);
	int test=0;
	int count=0;
	while((test==0)&&(count<50000)) {
	    digit=findGoodVertex(w,Q);
	    DIGIT=new Integer(digit);
	    W=W+DIGIT.toString();
	    Q=Q.rotate(digit);
	    test=Quad.compare(Q,QQ);
	    ++count;
	}
	return(W);
    }
	    


    public static String rotate(String W,int i) {
	int n=W.length();
          String W1=W.substring(i,n);
          String W0=W.substring(0,i);
          return(W1+W0);
    }


    public static PolyWedge nextPoly(PolyWedge P,Quad Q) {
	int k=findGoodVertex(P.getCenter(),Q);
	PolyWedge PP=new PolyWedge();
	for(int i=0;i<P.count;++i) {
	    PP.z[i]=new Complex(2*Q.z[k].x-P.z[i].x,2*Q.z[k].y-P.z[i].y);
	}
	PP.count=P.count;
	return(PP);
    }

    public static Complex nextPoint(Complex z,Quad Q) {
	int k=findGoodVertex(z,Q);
	Complex w=new Complex(2*Q.z[k].x-z.x,2*Q.z[k].y-z.y);
	return(w);
    }




    public static int runway(Complex z) {
	if(z.x< -1) return(0);
	if(z.y<-2) return(0);
	if(z.y> 2) return(0);
	if(z.x+z.y<-1) return(0);
	if(z.x-z.y<-1) return(0);
	return(1);
    }

    public static int runway(PolyWedge P) {
	Complex z=P.getCenter();
	return(runway(z));
    }





    public static PolyWedge returnMap(PolyWedge P,Quad Q) {
	int test=0;
	int count=0;
	PolyWedge PP=new PolyWedge(P);
	while((test==0)&&(count<10000)) {
	    ++count;
	    PP=nextPoly(PP,Q);
	    PP=nextPoly(PP,Q);
	    test=runway(PP);
	}
	return(PP);
    }



    public static Complex returnMap(Complex z,Quad Q) {
	int test=0;
	int count=0;
	Complex zz=new Complex(z);
	while((test==0)&&(count<10000)) {
	    ++count;
	    zz=nextPoint(zz,Q);
	    zz=nextPoint(zz,Q);
	    test=runway(zz);
	}
	return(zz);
    }







}
