#! /usr/local/bin/wish  -f

canvas .plot -width 600 -height 600 -bg black
canvas .post -width 600 -height 20 -bg black
pack .post
pack .plot
.plot create rectangle -10 -10 1000 1000 -fill black -outline black -tag bg
######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

.plot itemconfigure bg -fill black -outline black

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}
######################################


source tilemark
source tiling 
.plot itemconfigure X -outline black



.post create rectangle 0 0 70 50 -fill green -tag export
.post create rectangle 200 0 270 50 -fill orange -tag aspect
.post bind up <Button-1> {.plot scale X 300 300 1 0.9}
.post bind up <Button-2> {.plot scale X 300 300 1 1.111111}
.post bind up <Button-3> {.plot scale X 300 300 1 1.111111}

.post bind export <Any-Button> post
.post create text 8 13 -anchor w -text "export" -fill black -tag post
.post create text 108 13 -anchor w -text "scale" -fill black -tag up
.post create text 208 13 -anchor w -text "aspect" -fill black -tag aspect

.plot scale X 0 0 20 -20
.plot move X 300 300

proc post {} {
.plot postscript -pageheight 600 \
-height 600 \
-file "temp.ps"
}
