import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Renormalize {
    Manager M;
    int CHOICE;





    public Renormalize(Manager MM,int choice) {
	this.M=MM;
	this.CHOICE=choice;
    }


    public Renormalize(Manager MM) {
	this.M=MM;
	this.CHOICE=1;
    }


    public double[] makeInitialSequence(int choice,int parity) {
	double offset1=M.C.getOffsetY();
	double offset2=M.C.getOffsetX();
	if(CHOICE==0) offset1=M.C.getOffsetY0();
	if(CHOICE==0) offset2=M.C.getOffsetX0();
      double[] d={offset1,offset2};
      double[] x=KiteGrid.doGrid(choice,d[0],d[1],parity);
      return(x);
    }


    public double[] finalSequence1(int depth,int choice,int parity) {
	double[] x=makeInitialSequence(choice,parity);  
	 for(int i=0;i<depth;++i) {
	     int rc=M.C.CON_G.GC1.S[i+1].val;
	     x=basicRenormalize(rc,x);
	 }
	 return(x);


    }

    public GeneralPath finalGrid1(int depth,int choice,int parity,int absolute) { 
	double A=Math.sqrt(5)-2;
          GeneralPath gp=new GeneralPath();
         double[] bb=M.G.boundingBox(M); 
	 double[] x=finalSequence1(depth,choice,parity);
        if(x==null) return(gp);
	double t=1;
	if(absolute==1) t=absoluteScale(choice,x);
        gp=makeGrid(choice,bb,x,t);
	AffineTransform AFF=AffineTransform.getScaleInstance(t,t);
	gp.transform(AFF);
      return(gp);
    }


    public double[] finalSequence0(int depth,int choice,int parity) {
	double[] x=makeInitialSequence(choice,parity);  
	 for(int i=0;i<depth;++i) {
	     int rc=M.C.CON_G.GC0.S[i+1].val;
	     x=basicRenormalize(rc,x);
	 }
	 return(x);


    }

    public GeneralPath finalGrid0(int depth,int choice,int parity,int absolute) { 
	double A=Math.sqrt(5)-2;
          GeneralPath gp=new GeneralPath();
         double[] bb=M.G.boundingBox(M); 
	 double[] x=finalSequence0(depth,choice,parity);
        if(x==null) return(gp);
	double t=1;
	if(absolute==1) t=absoluteScale(choice,x);
        gp=makeGrid(choice,bb,x,t);
	AffineTransform AFF=AffineTransform.getScaleInstance(t,t);
	gp.transform(AFF);
      return(gp);
    }








    public static GeneralPath makeGrid(int choice,double[] bb,double[] x,double t) {
        GeneralPath gp=new GeneralPath();
        GeneralPath gp2=new GeneralPath();
        double X,Y;
        double[] v=KiteGrid.specialUnit(choice);
        v[0]=Math.pow(2.0,15)*v[0];
        v[1]=Math.pow(2.0,15)*v[1];
	double A=Math.sqrt(5)-2;
	for(int i=0;i<x.length;++i) { 
	    X=x[i];
            Y=-A*X;
	    gp2.reset();

	    gp2.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	    gp2.lineTo((float)(X+v[0]),(float)(Y+v[1]));

	    if(gp2.intersects(bb[0]/t,bb[1]/t,bb[2]/t,bb[3]/t)==true) {
                      gp.append(gp2,false);
	    }
	}
	return(gp);
    }




    public static double[] differenceSequence(double[] a) {
	double[] b=new double[a.length-1];
	for(int i=0;i<a.length-1;++i) b[i]=a[i+1]-a[i];
	return(b);
    }


    public static  double[] newGrid(int choice,double[] d,int renorm_choice,int parity) {
        double[] x=KiteGrid.doGrid(choice,d[0],d[1],parity);
	double[] y=basicRenormalize(renorm_choice,x);
	return(y);
    }


    public static double[] basicRenormalize(int choice,double[] x) {
	double[] g=differenceSequence(x);
	double[] gap=getGapSizes(g);
	double[] y=renormSequence(x,gap[choice]);
	return(y);
    }

    public static double[] renormSequence(double[] a,double gap) {
	double[] b=new double[a.length];
	int count=0;
	for(int i=0;i<a.length-1;++i) {
	    double test=a[i+1]-a[i];
	    double test2=Math.abs(test-gap);
	    if(test2<.00001) {
		b[count]=a[i]+.5*gap;
		++count;
	    }
	}
	double[] c=new double[count];
	for(int i=0;i<count;++i) c[i]=b[i];
	return(c);
    }





    public static double[] getGapSizes(double[] g) {

	double[] val={-1,-1,-1};
	val[0]=g[0];
	int test=0;
	int i=1;
	while((test==0)&&(i<g.length)) {
            double test0=Math.abs(g[i]-val[0]);
	    if(test0>.0001) { 
                val[1]=g[i];
		test=1;
	    }
	    ++i;
	}

	i=2;
	test=0;
	while((test==0)&&(i<g.length)) {
	    double test0=Math.abs(g[i]-val[0]);
	    double test1=Math.abs(g[i]-val[1]);
	    if((test0>.0001)&&(test1>.0001)) {
                val[2]=g[i];
		test=1;
	    }
	    ++i;
	}
	double temp=0;

	//sort
	for(int j=0;j<3;++j) {
	    for(int k=j+1;k<3;++k) {
	      if(val[j]>val[k]) {
	        temp=val[j];
	        val[j]=val[k];
	        val[k]=temp;
	      }
	    }
	}
	return(val);
    }

    public static double absoluteScale(int choice,double[] g) {
	double A=Math.sqrt(5)-2;
	double[] gap=getGapSizes(differenceSequence(g));
	double t=gap[0]+gap[1]+gap[2];
	if(choice<=2) t=t*A;
	return(2/t);
    }



    /* This works off the basic sequence*/

    public static double[] gapFrequency(double[] x) {
	double[] g=differenceSequence(x);
	double[] gap=getGapSizes(g);
	double[] f={0,0,0};
	for(int i=0;i<g.length;++i) {
	    if(Math.abs(g[i]-gap[0])<.1) f[0]=f[0]+1;
	    if(Math.abs(g[i]-gap[1])<.1) f[1]=f[1]+1;
	    if(Math.abs(g[i]-gap[2])<.1) f[2]=f[2]+1;
	}
	double tot=f[0]+f[1]+f[2];
	f[0]=f[0]/tot;
	f[1]=f[1]/tot;
	f[2]=f[2]/tot;
	return(f);

    }







    //finds intersection point

    public static Complex intersection(int type1,double index1,int type2,double index2) {
	double[] v1=KiteGrid.specialVector(type1);
	double[] v2=KiteGrid.specialVector(type2);
	double A=Math.sqrt(5)-2;
	Complex z=new Complex();
	z.x=index1;
	z.y=-A*z.x;
	double d=GridDynamics.functional(type2,v1[0],v1[1]);
	d=(index2-index1)/d;
	z.x=z.x+d*v1[0];
	z.y=z.y+d*v1[1];
	return(z);
    }


    public static Complex[] intersection(int type1,double index1,int type2,double[] index2) {

	Complex z0=new Complex();
	Complex z1=new Complex();
	Complex z2=new Complex();
	z0=intersection(type1,index1,type2,index2[0]);
	z1=intersection(type1,index1,type2,index2[1]);
	z2=Complex.minus(z0,z1);
	double[] v1=KiteGrid.specialVector(type1);
	double test=v1[0]*z2.x+v1[1]*z2.y;
	Complex[] Z=new Complex[2];
	Z[0]=new Complex(z0);
	Z[1]=new Complex(z1);
	if(test<0) {
	    Z[0]=new Complex(z1);
	    Z[1]=new Complex(z0);
	}
	return(Z);
    }


    public static int[] iteratedRenorm(double d1) {
	int[] n=new int[5];
	double d2=d1;
	for(int i=0;i<5;++i) {
	    n[i]=suggestRenorm(d2);
	    d2=penroseMap(d2);
	}
	return(n);
    }







    public static int suggestRenorm(double d1) {
	double d=fixRange(d1);
	double P=(1+Math.sqrt(5.0))/2;
	if((d>2/(P*P))&&(d<=1)) return(0);
	if((d>1/(P*P))&&(d<=2/(P*P))) return(2);
	if((d>2/(P*P*P*P))&&(d<1/(P*P))) return(0);
	if((d>1/(P*P*P))&&(d<=2/(P*P*P*P))) return(2); 
	return(0);
    }

   public static double penroseMap(double x) {
       double y=fixRange(x);	
       double A=Math.sqrt(5)-2;
       int test=4;
       if(y>=1-3*A) test=3;
       if(y>=(1-A)/2) test=2;
       if(y>=1-A) test=1;
       y=g(test,y);
       y=fixRange(y);
       return(y);
   }



    public static double g1(double x) {
	double PHI=(1+ Math.sqrt(5))/2;
      double y=(1+2*PHI)*x - 2*PHI;
      return(y);
    }

    public static double g2(double x) {	
        double PHI=(1+ Math.sqrt(5))/2;
	double y=-x+2/(PHI*PHI);
	return(y);
    }

    public static double g3(double x) {
	return(2+g1(x));
    }

    public static double g4(double x) {
	return(-2-g1(x));
    }

    public static double g(int choice,double x) {
	if(choice==1) return(g1(x));
	if(choice==2) return(g2(x));
	if(choice==3) return(g3(x));
	if(choice==4) return(g4(x));
	return(0);
    }


    public static double fixRange(double x) {
	double A=Math.sqrt(5)-2;
	double a1=Math.log(x)/Math.log(A);
	a1=Math.floor(a1);
        double y=x*Math.pow(A,-a1);
	return(y);
    }





}