import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntryBasic {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[2];
    ListenSquare REDUCE,RANDOM;
    SelectInteger SHIFT;
    ListenSquare[] INFO=new ListenSquare[10];
    int X,Y;
    double DEFAULT;


    public ShapeEntryBasic(int x,int y) {
	 X=x;
	 Y=y;
	 I[0]=new SelectIntegerKeyboard(x+3,y+3,   48,13,2,9999999);  //xcoord numerator
	 I[1]=new SelectIntegerKeyboard(x+3,y+21,48,13,3,9999999);  //ycoord denominator
	 SHIFT=new SelectInteger(x+120,y+10,40,20,0,0,0,0);
         REDUCE=new ListenSquare(x+63,y,50,15,Color.white);
	 REDUCE.on=1; 
	 DEFAULT=1.0/3.0;   
         RANDOM=new ListenSquare(x+64,y+22,48,15,Color.white);
	 RANDOM.on=1;
    }

    public void render(Graphics2D g) {

            drawFractionsBasic(g);
            drawButtonsBasic(g);

    }


    public void drawButtonsBasic(Graphics2D g) {
	  REDUCE.render(g,new Color(150,0,150));
	  g.drawString("reduce",X+70,Y+11);    
           RANDOM.render(g,new Color(150,0,150));  
           g.drawString("random",X+70,Y+33); 
	   SHIFT.render(g,new Color(150,0,150),Color.white,new Color(0,0,0,0));
    }


	public void drawFractionsBasic(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,10));

	  //main entry
	  g.setColor(new Color(160,0,160));  
	  g.fillRect(X,Y,55,37);
	  g.setColor(Color.white);
	  g.drawRect(X,Y,55,37);

          for(int i=0;i<=1;++i) {
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
	  }
	}

    public void doShift(Point X) {
	int val=SHIFT.upOrDown(X);
	I[0].val=I[0].val+val;
    }


    public void getRandom() {
	double d1=Math.random();
	double d2=Math.random();
	d2=d2*1000;
	d1=d1*d2;

	int p=(int)(d1);
	int q=(int)(d2);
	if(p<=0) {p=1;q=2;}
	if(p==q) p=q-1;
	I[0].val=p;
	I[1].val=q;
	reduce();
    }

    public void reduce() {
	if(I[0].val*I[1].val>0) {
           int s=MathRational.GCD(I[0].val,I[1].val);
           I[0].val=I[0].val/s;
           I[1].val=I[1].val/s;
	}
    }


    public double getParameter() {
	double t=DEFAULT;
	  t=1.0*I[0].val/I[1].val;
	  if(t>4) t=1;
	  return(t);
    }

  public int processMouse(MouseEvent e) {
	MouseData J=MouseData.process(e);

       for(int i=0;i<=1;++i) {
	  I[i].on=0;
	  if(I[i].inside(J.X)==1) I[i].on=1;
       }
       if(REDUCE.inside(J.X)==1) reduce();  
       if(RANDOM.inside(J.X)==1) getRandom();
       doShift(J.X);
       return(0);
  }

    public void processKey(KeyEvent e) {
	if(I[0].on==1) I[0].modifySign(e);
	if(I[1].on==1) I[1].modifySign(e);
    }

}




