import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntryQuadratic {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[15];
    SelectInteger APPROX;
    int x,y;	
    ListenSquare[] L=new ListenSquare[3];


    public ShapeEntryQuadratic(int x,int y) {
	 I[0]=new SelectIntegerKeyboard(x+3,y+3,   48,13,1,9999999);  //x rational numerator
	 I[1]=new SelectIntegerKeyboard(x+3,y+21,48,13,3,9999999);  //y rational denominator

	 APPROX=new SelectInteger(x+65,y+5,36,18,0,1,10,1);
	 L[0]=new ListenSquare(x+3,y+47,45,17,Color.white);
	 L[0].on=0;
	 L[1]=new ListenSquare(x+53,y+47,45,17,Color.white);
	 L[1].on=0;
	 L[2]=new ListenSquare(x+103,y+47,45,17,Color.white);
	 L[2].on=1;
    }


    public void render(Graphics2D g) {
	  drawFractionsBasic(g);
	  APPROX.render(g,new Color(200,0,200),Color.white,Color.white);
	  for(int i=0;i<3;++i)
	      L[i].render(g,new Color(200,0,200));
	  g.drawString("odd",(int)(L[0].x+5),(int)(L[0].y+13));
	  g.drawString("even",(int)(L[1].x+5),(int)(L[1].y+13));
	  g.drawString("both",(int)(L[2].x+5),(int)(L[2].y+13));
    }


	public void drawFractionsBasic(Graphics2D g) {
          for(int i=0;i<2;++i) {
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
	  }

	}


    public void getApprox() {

	double t=getQuadratic();
	double tol=Math.pow(.1,APPROX.val);

	int[] a=MathRational.approximate(t,tol);

	int a0=a[0];
	int a1=a[1];

	int test=(a[0]*a[1])%2;

	if((test==0)&&(L[0].on==1)) { 

	    int[] b=MathRational.oppositeType(a0,a1);
	    a0=b[0];
	    a1=b[1];
	}

	if((test==1)&&(L[1].on==1)) {
	    int[] b=MathRational.oppositeType(a0,a1);
	    a0=b[0];
	    a1=b[1];
	}

	I[0].val=a0;
	I[1].val=a1;
    }



    public void processMouse(MouseEvent e) {
	MouseData J=MouseData.process(e);
	APPROX.modify(J.X);
	getApprox();
	setApproxType(J.X);
    }



    public double getParameter() {
	double t=1.0*I[0].val/I[1].val;
	return(t);
    }


    public double getQuadratic() {
	return(Math.sqrt(5.0)-2);
    }

    public void setApproxType(Point X) {
	int test=-1;
	for(int i=0;i<3;++i) {
	    if(L[i].inside(X)==1) test=i;
	}
	if(test!=-1) {
	    for(int i=0;i<3;++i) L[i].on=0;
	    L[test].on=1;
	}




    }


}





