

import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class Strips {
    public Strips() {}


    public static int farthest(PolyWedge P,int n) {
	int n0=n;

	int n1=(n+1)%P.count;
	int n2=0;
	Complex z1=P.z[n0];
	Complex z2=P.z[n1];

	double area=0;
	double max=0;
	int index=0;
	for(int i=0;i<P.count;++i) {
	    n2=i%P.count;
	    Complex z3=P.z[n2];
	    area=Math.abs(Complex.area(z1,z2,z3));
	    if(max<area) {
		max=area;
		index=n2;
	    }
	}
	return(index);
    }

    public static Complex[] stripData(PolyWedge P,int n) {
	int n0=n;
	int n1=(n+1)%P.count;
	int n2=farthest(P,n);
	Complex z1=P.z[n0];
	Complex z2=P.z[n1];
	Complex z3=P.z[n2];
	Complex w1=new Complex(2*z3.x-z1.x,2*z3.y-z1.y);
	Complex w2=new Complex(2*z3.x-z2.x,2*z3.y-z2.y);
	Complex[] X=new Complex[4];
	X[0]=new Complex(z1);
	X[1]=new Complex(z2);
	X[2]=new Complex(w1);
	X[3]=new Complex(w2);
	return(X);
    }



    public static GeneralPath strip(PolyWedge P,int n) {
	Complex[] X=stripData(P,n);
	Complex z1=X[0];
	Complex z2=X[1];
	Complex w1=X[2];
	Complex w2=X[3];
	Complex a1=new Complex(1000*z1.x-999*z2.x,1000*z1.y-999*z2.y);
	Complex a2=new Complex(1000*z2.x-999*z1.x,1000*z2.y-999*z1.y);
	Complex b1=new Complex(1000*w1.x-999*w2.x,1000*w1.y-999*w2.y);
	Complex b2=new Complex(1000*w2.x-999*w1.x,1000*w2.y-999*w1.y);

	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(a1.x),(float)(a1.y));
	gp.lineTo((float)(a2.x),(float)(a2.y));
	gp.lineTo((float)(b1.x),(float)(b1.y));
	gp.lineTo((float)(b2.x),(float)(b2.y));
	gp.closePath();
	return(gp);
    }


    public static int insideStrip(PolyWedge P,int n,Complex u) {
	Complex[] X=stripData(P,n);
	Complex z1=X[0];
	Complex z2=X[1];
	Complex w1=X[2];
	Complex w2=X[3];
	double a1=Complex.area(z1,z2,u);
	double a2=Complex.area(w1,w2,u);
	if(a1<0) return(0);
	if(a2<0) return(0);
	return(1);
    }



    public static double relStrip(PolyWedge P,int n,Complex u) {
	Complex[] X=stripData(P,n);
	Complex z1=X[0];
	Complex z2=X[1];
	Complex w1=X[2];
	Complex w2=X[3];
	double a1=Complex.area(z1,z2,u);
	double a2=Complex.area(z1,z2,w1);
	double a3=a1/a2;
	if(n==1) a3=-a3+1;
	if(n==2) a3=-a3+1;
	return(a3);
    }


    public static double inverseRelStrip(PolyWedge P,int n,Complex u) {
	int nn=-1;
	if(n==0) nn=1;
	if(n==1) nn=3;
	if(n==2) nn=0;
	if(n==3) nn=2;
	double a=relStrip(P,nn,u);
	if(n==3) a=-a+1;
	return(a);
    }






    public static Complex translationVector(PolyWedge P,int n) {
	Complex z=new Complex();
	if(n==0) z=new Complex(0,-4);
	if(n==1) z=new Complex(-2,-2);
	if(n==2) z=new Complex(2,-2);
	if(n==3) z=new Complex(-2*P.z[3].x-2,-2*P.z[3].y);
	return(z);
    }




    public static Complex map0(PolyWedge P,int n,Complex u) {	
	Complex v=translationVector(P,n);
	double a=relStrip(P,n,u);
	a=Math.floor(a);
	v=new Complex(a*v.x,a*v.y);
	Complex w=Complex.minus(u,v);
	return(w);
    }

    public static double psiInteger(Complex u) {
	    double d=Math.floor(.25*u.y+.5);
	    return(d);
    }
    public static Complex psi0(Complex u) {
	double d=psiInteger(u);
	Complex v=new Complex(u.x,u.y-4*d);
	return(v);
    }


    public static PolyWedge psi(PolyWedge X) {
	PolyWedge Y=new PolyWedge(X);
	for(int i=0;i<X.count;++i) {
	    Y.z[i]=psi0(X.z[i]);
	}
	return(Y);
    }


    public static Complex inverseMap0(PolyWedge P,int n,Complex u) {
	Complex v=translationVector(P,n);
	double a=inverseRelStrip(P,n,u);
	a=Math.floor(a);
	v=new Complex(a*v.x,a*v.y);
	Complex w=Complex.minus(u,v);
	return(w);
    }






    /*algebraic version*/

    public static int[] map1(PolyWedge P,int n,Complex u) {

	Complex v=translationVector(P,n);
	double a=relStrip(P,n,u);
	a=Math.floor(a);
	int[] d={0,0,0};
	if(n<3) {
	    d[0]=(int)(-a*v.x/2);
	    d[1]=(int)(-a*v.y/2);
	    d[2]=0;
	}
	if(n==3) {
	    d[0]=(int)(a);
	    d[1]=0;
	    d[2]=(int)(a);
	}
	return(d);
    }





    public static int[] inverseMap1(PolyWedge P,int n,Complex u) {

	Complex v=translationVector(P,n);
	double a=inverseRelStrip(P,n,u);
	a=Math.floor(a);
	int[] d={0,0,0};
	if(n<3) {
	    d[0]=(int)(-a*v.x/2);
	    d[1]=(int)(-a*v.y/2);
	    d[2]=0;
	}
	if(n==3) {
	    d[0]=(int)(a);
	    d[1]=0;
	    d[2]=(int)(a);
	}
	return(d);
    }









    public static PolyWedge map(PolyWedge P,int n,PolyWedge X) {
	PolyWedge Y=new PolyWedge(X);
	for(int i=0;i<X.count;++i) {
	    Y.z[i]=map0(P,n,X.z[i]);
	}
	return(Y);
    }

    public static PolyWedge inverseMap(PolyWedge P,int n,PolyWedge X) {
	PolyWedge Y=new PolyWedge(X);
	for(int i=0;i<X.count;++i) {
	    Y.z[i]=inverseMap0(P,n,X.z[i]);
	}
	return(Y);
    }




    public static PolyWedge returnMap(PolyWedge P,PolyWedge X) {
	PolyWedge Y=new PolyWedge(X);
	Y=Y.homothety(.0001);
	int[] s={0,2,3,1,0,2,3,1};
	for(int i=0;i<8;++i)  Y=map(P,s[i],Y);
	Y=psi(Y);
	Y=Y.homothety(10000);
	return(Y);
    }



    public static Complex returnMap(PolyWedge P,Complex y) {
	Complex Y=new Complex(y);
	int[] s={0,2,3,1,0,2,3,1};
	for(int i=0;i<8;++i) Y=map0(P,s[i],Y);
	Y=psi0(Y);
	return(Y);
   }

    public static PolyWedge inverseReturnMap(PolyWedge P,PolyWedge X) {
	PolyWedge Y=new PolyWedge(X);
	Y=Y.homothety(.0001);
	int[] s={1,3,2,0,1,3,2,0};
	for(int i=0;i<8;++i)  Y=inverseMap(P,s[i],Y);
	Y=psi(Y);
	Y=Y.homothety(10000);
	return(Y);
    }

    public static Complex inverseReturnMap(PolyWedge P,Complex y) {
	Complex Y=new Complex(y);
	int[] s={1,3,2,0,1,3,2,0};
	for(int i=0;i<8;++i) Y=inverseMap0(P,s[i],Y);	
        Y=psi0(Y);
	return(Y);
    }

    public static int[] algebraicReturn(PolyWedge P,Complex y) {
	int[] d1={0,0,0};
	int[] d2={0,0,0};
	int[] s={0,2,3,1,0,2,3,1};	
        Complex Y=new Complex(y);
	for(int i=0;i<8;++i) {
	  d2=map1(P,s[i],Y);
	  Y= map0(P,s[i],Y);

	  for(int j=0;j<3;++j) d1[j]=d1[j]+d2[j];
	}
	int x=(int)(psiInteger(Y));
	d1[1]=d1[1]-2*x;
	return(d1);
    }


    public static int[] inverseAlgebraicReturn(PolyWedge P,Complex y) {
	int[] d1={0,0,0};
	int[] d2={0,0,0};
	int[] s={0,1,3,2,0,1,3,2};
        Complex Y=new Complex(y);
	for(int i=0;i<8;++i) {
	  d2=inverseMap1(P,s[i],Y);  
          Y=inverseMap0(P,s[i],Y);
	  for(int j=0;j<3;++j) d1[j]=d1[j]+d2[j];
	}	
        int x=(int)(psiInteger(Y));
	d1[1]=d1[1]-2*x;
	return(d1);
    }








}
