import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class TileCoordsDisplay {
    SelectInteger I1,I2;
    int vertex;
    ControlPanel TYPE;
    int X,Y;   
    PolyWedge W;

    public TileCoordsDisplay(int X, int Y) {
        Color[] C0={new Color(0,180,180),Color.white,Color.white,Color.white,new Color(0,50,200)};
        String[] S0={"decimal","Q",""};
	int[] state0={0,1};
  	TYPE=new ControlPanel(C0,S0,state0,2,0);
	I1=new SelectInteger(32,35,26,13,4,4,10,1);
	I2=new SelectInteger(2,2,26,13,0,0,0,1);
	this.X=X;
	this.Y=Y;
	W=new PolyWedge();
   }

    public void render(Graphics2D g,int mode) {


	g.translate(X,Y);

	g.setColor(new Color(0,180,180));
	g.fillRect(0,0,176,50);
	g.setColor(Color.white);
	g.drawRect(0,0,176,50);

	TYPE.render(g,0,0,85);
	I1.render(g,Color.red,Color.white,Color.white);
	I2.render(g,Color.red,Color.white,Color.white);

	try{
	if(TYPE.mode==0) renderDecimal(g);
	if(TYPE.mode==1) renderRational(g,I1.val);
	}
	catch(Exception e) {}
  	g.translate(-X,-Y);
    }


    public int process(MouseEvent e) {
        I2.max=W.count;
	if(I2.val>=I2.max) I2.val=0;

        MouseData J=MouseData.process(e);
	Point XX=new Point();
	XX.x=J.X.x-X;
	XX.y=J.X.y-Y;
	int type=TYPE.switchMode(XX);
	I1.modify(XX);
	if(I2.max>0) I2.modifyCyclic(XX);
	if(type==20) return(20);
	return(0);
    }








    public void renderDecimal(Graphics2D g) {
	double x=W.z[I2.val].x;
	double y=W.z[I2.val].y;
	Double xx=new Double(x);
	Double yy=new Double(y);

        String v1=xx.toString();
	if(Math.abs(x)<.0000000001) v1="0";
	String v2=yy.toString();
	if(Math.abs(y)<.0000000001) v2="0";
	try {
	    v1=v1.substring(0,12);
	}
	catch(Exception e) {} 

	try {
	   v2=v2.substring(0,12);
	}
	catch(Exception e) {}
	g.setColor(Color.white); 
        g.setFont(new Font("Helvetica",Font.PLAIN,10));
	g.drawString(v1,90,15);
	g.drawString(v2,90,42);
    }


    public int[][] getVertexRational(int i,int DEPTH) {
        double x,y;
	int[][] vtx=new int[2][2];
	if(i>=W.count) return(null);
	double tol=Math.pow(10,-DEPTH);
	x=W.z[i].x;
	y=W.z[i].y;
        vtx[0]=MathRational.approximate(x,tol);
	vtx[1]=MathRational.approximate(y,tol);
	return(vtx);
    }


    public void renderRational(Graphics2D g,int DEPTH) {
	int select=I2.val;
	int[][] vtx=getVertexRational(select,DEPTH);
	if(vtx!=null) {

	    Integer[][] VTX=new Integer[2][2];
	    for(int i=0;i<2;++i) {
		for(int j=0;j<2;++j) {
		    VTX[i][j]=new Integer(vtx[i][j]);
		}
	    } 
	    g.translate(85,1);
            g.setFont(new Font("Helvetica",Font.PLAIN,10));
            g.setColor(Color.white);
	    g.drawString(VTX[0][0].toString(),5,9);
	    g.drawLine(5,11,75,11);
	    g.drawString(VTX[0][1].toString(),5,21);
	    g.drawString(VTX[1][0].toString(),5,35);
            g.drawLine(5,37,75,37);
	    g.drawString(VTX[1][1].toString(),5,47);
	    g.translate(-85,-1);
	}
    }




}
