import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TilingMarkings {
    public TilingMarkings() {
    }

    public static void drawX(Graphics2D g,Manager M,Output OUT) {
	GeneralPath H=new GeneralPath();  
        Color COL=M.C.CON_T.COLORS.L[3].C;
	g.setColor(COL);
	for(int i=-100;i<100;++i) {
	  H.reset();
	  H.moveTo(-1000,1+2*i);
	  H.lineTo(1000,1+2*i);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);
	}

	double A=Math.sqrt(5.0)-2.0;
          H.reset();
	  H.moveTo(-1000,0);
	  H.lineTo(1000,0);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);

    }


    public static void drawStrips(Graphics2D g,Manager M) {
	drawStrip1(g,M);
	drawStrip2(g,M);
	drawStrip3(g,M);
	drawStrip4(g,M);
    }

    public static void drawCrosshairs(Graphics2D g,Manager M) {
	drawCrosshairs(0,g,M,Color.orange);
	drawCrosshairs(1,g,M,Color.white);
    }


    public static void drawCrosshairs(int choice, Graphics2D g,Manager M,Color CC) {
	GeneralPath gp=new GeneralPath();
	double offsetX=M.C.CON_G.GC1.S1.getParameter();
	double offsetY=M.C.CON_G.GC1.S2.getParameter();
	int parity=M.C.CON_G.GC1.S[0].val;
	if(choice==0) {
	    offsetX=M.C.CON_G.GC0.S1.getParameter();
	    offsetY=M.C.CON_G.GC0.S2.getParameter(); 
            parity=M.C.CON_G.GC0.S[0].val;
	}

       gp.moveTo(0,(float)(offsetY));
	gp.lineTo(100,(float)(offsetY));
	gp.moveTo(0,(float)(offsetY-2));
	gp.lineTo(100,(float)(offsetY-2));

	Complex Z=M.G.SOURCE;
	double a=Math.sqrt(5)-2;

	int xx=(int)(Z.x);
	int yy=(int)(Z.y);
	int test=(xx+yy+10001+parity)%2;	
        offsetX=offsetX+2*a*Z.x+2*Z.y;
	if(test==0) {
	   gp.moveTo((float)(offsetX),0);
           gp.lineTo((float)(offsetX),2);
	}
	if(test==1) {
	   gp.moveTo((float)(offsetX),0);
           gp.lineTo((float)(offsetX),-2);
	}

	offsetX=offsetX+2*a*Z.x+2*Z.y;

	gp=M.P.transform(gp);
        g.setColor(CC);
	g.draw(gp);
    }







    public static void drawStrip4(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;


	//first strip

	a1=0;
	a2=1;
	a3=3;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }


    public static void drawStrip1(Graphics2D g,Manager M) {
        Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//second strip

	a1=0;
	a2=3;
	a3=1;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();


	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }


    public static void drawStrip3(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//third strip

	a1=2;
	a2=3;
	a3=0;

	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);
	H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();
    }





    public static void drawStrip2(Graphics2D g,Manager M) {
	Color C=M.C.CON_T.COLORS.L[5].C;
	GeneralPath H0=new GeneralPath();
	Complex[] z=new Complex[4];
	for(int i=0;i<4;++i) z[i]=M.P.QUAD.z[i];
	Complex[] zz=new Complex[4];
	float[] p1=new float[2];
	float[] p2=new float[2];
	g.setColor(C);
	int a1,a2,a3;


	int NUM1=(int)(Math.pow(2,M.C.CON_T.TCC.INT[0].val)+Math.pow(2,M.C.CON_T.TCC.INT[1].val));
	int NUM2=NUM1-1;

	//4th strip

	a1=2;
	a2=1;
	a3=0;


	p1[0]=(float)(NUM1*z[a1].x-NUM2*z[a2].x);
	p2[0]=(float)(NUM1*z[a2].x-NUM2*z[a1].x);
	p1[1]=(float)(NUM1*z[a1].y-NUM2*z[a2].y);
	p2[1]=(float)(NUM1*z[a2].y-NUM2*z[a1].y);
	H0.moveTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);

	zz[a1]=new Complex(2*z[a3].x-z[a1].x,2*z[a3].y-z[a1].y);
	zz[a2]=new Complex(2*z[a3].x-z[a2].x,2*z[a3].y-z[a2].y);

	p1[0]=(float)(NUM1*zz[a1].x-NUM2*zz[a2].x);
	p2[0]=(float)(NUM1*zz[a2].x-NUM2*zz[a1].x);
	p1[1]=(float)(NUM1*zz[a1].y-NUM2*zz[a2].y);
	p2[1]=(float)(NUM1*zz[a2].y-NUM2*zz[a1].y);
	H0.lineTo(p1[0],p1[1]);
	H0.lineTo(p2[0],p2[1]);	

        H0.closePath();
	H0=M.P.transform(H0);
	g.fill(H0);
	g.draw(H0);
	H0.reset();

    }


    public static void drawFrame(Graphics2D g,Manager M) {
	GeneralPath H=new GeneralPath();

	float dx=(float)(Math.pow(2,M.C.CON_T.TCC.INT[0].val));
	float dy=(float)(Math.pow(2,M.C.CON_T.TCC.INT[1].val));

	float a=(float)(1000.0);

	Color COL=M.C.CON_T.COLORS.L[4].C;
        g.setColor(COL);

	//top
	H.reset();
	H.moveTo(dx+a,dy);
	H.lineTo(dx+a,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,dy);
	H=M.P.transform(H);
	g.fill(H);

	//bottom
	H.reset();
	H.moveTo(dx+a,-dy);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(-dx-a,dy-a);
	H.lineTo(-dx-a,-dy);
	H=M.P.transform(H);
	g.fill(H);

	//right
	H.reset();
	H.moveTo(dx,dy+a);
	H.lineTo(dx+a,dy+a);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);

	//left
	H.reset();
	H.moveTo(-dx,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,-dy-a);
	H.lineTo(-dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);


	g.setColor(M.C.CON_T.COLORS.L[0].C);
	H.reset();
	H.moveTo(dx,dy);
	H.lineTo(-dx,dy);
	H.lineTo(-dx,-dy);
	H.lineTo(dx,-dy);
	H.closePath();
	H=M.P.transform(H);
	g.draw(H);
    }




}
