import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeGraph implements Runnable {
    int halt;
    Complex SOURCE;
    Manager M;


public ComputeGraph() {}

    public ComputeGraph(Complex z,Manager MM) {
	this.M=MM;
	this.SOURCE=z;	
    }

    public void run() {
	int mode=M.C.CON_G.ACTION.mode;
	M.P.Q[0]=M.C.SES.getQuad();
	int[] a=new int[7];
	for(int i=0;i<7;++i) a[i]=M.C.CON_G.ACTION.L[i].on;	
        if(a[0]==1) gridDynamics(0,0);    //raw path
        if(a[1]==1) gridDynamics(1,0);    //corrected path
        if(a[2]==1) gridDynamics(1,1);	  //defects along path
        if(a[3]==1) defects();
	if(a[4]==1) bothOrbit();
	if(a[5]==1) block(); 
        if(a[6]==1) gridDynamicsRenorm();
    }


    public int[] toInt(int Vx,int Vy) {
	Complex Z=M.C.SES.getComplex();
	int a=Vx;
	int c=Vy;
	int b=-(int)(Math.floor(c*Z.y))-1;
	int test=(a+b+c+100000)%2;
	if(test==1) b=b+1;
	int[] d={a,b,c};
	return(d);
    }

    public  Complex toComplex(int[] d) {
	double offsetY=M.C.SB1.getParameter2(1);	  //y direction
	double offsetX=M.C.SB2.getParameter2(0);	  //x direction
        Complex z=M.C.SES.getComplex();
	double x=2*d[0]+2*d[2]*z.x+offsetX;
	double y=2*d[1]+2*d[2]*z.y+offsetY;
	Complex w=new Complex(x,y);
	w.x=w.x+.0000001;
	return(w);
    }

     public int[] forwardReturn(int[] d,PolyWedge P) {
 	Complex z=toComplex(d);
        int[] d1=Strips.algebraicReturn(P,z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	d1[2]=d1[2]+d[2];
 	return(d1);
    }

    public int[] backwardReturn(int[] d,PolyWedge P) {
 	Complex z=toComplex(d);
        int[] d1=Strips.inverseAlgebraicReturn(P,z);
 	d1[0]=d1[0]+d[0];
 	d1[1]=d1[1]+d[1];
 	d1[2]=d1[2]+d[2];
 	return(d1);
    }


     public void sendMessage(int j) {
 	Integer X=new Integer(j);
 	M.C.message=X.toString();
 	M.C.repaint();
    }

     public void block() {
 	PolyWedge P=new PolyWedge(M.P.Q[0]);
 	double LIM1=M.C.CON_G.I[0].val;
 	double LIM2=M.C.CON_G.I[1].val;
 	LIM1=Math.pow(2,LIM1);
 	LIM2=Math.pow(2,LIM2);

        GeneralPath gp=new GeneralPath();
        GeneralPath gp2=new GeneralPath();
 	int i=(int)(-LIM1);
 	int j=(int)(-LIM2);
 	halt=1;
 	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);

	Color COL=M.C.CON_G.ACTION.M[5].C;

 	while(halt==1) {
	     gp2.reset();
	     int[] d1=toInt(y+i,x+j);
	     int[] d2=forwardReturn(d1,P);
             gp2.moveTo(d1[2],d1[0]);
	     gp2.lineTo(d2[2],d2[0]);
	     if((d1[0]!=d2[0])||(d1[2]!=d2[2])) { 
                  gp2.moveTo(d1[2],d1[0]);
	          gp2.lineTo(d2[2],d2[0]);
                  gp.append(gp2,false);
	     }
	     ++i;
	     if(i>LIM1) {
	 	i=(int)(-LIM1);
	 	++j; 
	 	sendMessage(j);
	     }
	     if(j>LIM2) halt=0;
	}

 	halt=0;  
	int thick=M.G.THICK[0].val;
        M.G.nextPath(gp,COL,thick);	  
 	M.G.repaint();
    }


    public void bothOrbit() {
	forwardOrbit();
	backwardOrbit();
    }



    public void forwardOrbit() {
	Color COL=M.C.CON_G.ACTION.M[4].C;

	PolyWedge P=new PolyWedge(M.P.Q[0]);
	Complex source=new Complex(SOURCE.y,SOURCE.x);
	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);
	int[] d=toInt(y,x);
	int[] d2={d[0],d[1],d[2]};
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	halt=1;

	int i=0;
	double max=0;
	while((i<LIM)&&(halt==1)) {
	    gp2.reset();
            gp2.moveTo(d[2],d[0]);
	    d=forwardReturn(d,P);
	    Complex test1=toComplex(d);
	    double test2=test1.x;
	    if(max<test2) max=test2;
	    gp2.lineTo(d[2],d[0]);
	    gp.append(gp2,false);
	    if((d[0]==d2[0])&&(d[2]==d2[2])) halt=0;
	    ++i;
	    if(i%1000==0) sendMessage(i);
	}
	halt=0;  	
        int thick=M.G.THICK[0].val;
	M.G.nextPath(gp,COL,thick);
	M.C.repaint();
	M.G.repaint();
    }



    public void backwardOrbit() {	
	Color COL=M.C.CON_G.ACTION.M[4].C;
	PolyWedge P=new PolyWedge(M.P.Q[0]);
	Complex source=new Complex(SOURCE.y,SOURCE.x);
	int x=(int)(SOURCE.x);
 	int y=(int)(SOURCE.y);
	int[] d=toInt(y,x);
	int[] d2={d[0],d[1],d[2]};
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();


	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	halt=1;

	int i=0;
	while((i<LIM)&&(halt==1)) {

            gp2.reset();
            gp2.moveTo(d[2],d[0]);
	    d=backwardReturn(d,P);
            gp2.lineTo(d[2],d[0]);
	    gp.append(gp2,false);
	    if((d[0]==d2[0])&&(d[2]==d2[2])) halt=0;
	    ++i;
	    if(i%1000==0) sendMessage(i);
	}
	halt=0;	 	
        int thick=M.G.THICK[0].val;
	M.G.nextPath(gp,COL,thick);  
	M.C.repaint();
	M.G.repaint();
    }



    public  void gridDynamics(int choice,int defects) {	
        int thick=M.G.THICK[1].val;
	KiteGrid KG=new KiteGrid();
	int[] pq=M.C.SES.kiteIntegers();
	int p=pq[0];
	int q=pq[1];
        double offset1=M.C.SB1.getParameter2(1);
        double offset2=M.C.SB2.getParameter2(0);
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();

	Color COL0=M.C.CON_G.ACTION.M[0].C; //raw path
	Color COL1=M.C.CON_G.ACTION.M[1].C; //correct path
	Color COL2=M.C.CON_G.ACTION.M[2].C; //defects
	Color COL=Color.white;
	if(defects==1) COL=COL2;
	if((choice==0)&&(defects==0)) COL=COL0;
	if((choice==1)&&(defects==0)) COL=COL1;

	GridDynamics GD=new GridDynamics(p,q,offset1,offset2);

	Complex z0=new Complex(M.G.SOURCE2);
	Complex z1=new Complex();
	if(defects==0) gp=GD.getSegmentPath(z0);

	halt=1;
	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);

	int i=0;
	int sign=1;
	int SWITCH=0;

	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(sign,sign,z0,0);
	  int TEST=0;

          if(choice==1) TEST=GridCorrect.decorate(GD,z1);

          if(TEST==2) {  
              Complex[] Z=GD.tripleDynamics(sign,z0,z1,.0001);
	      if(Z[1].x<-100) halt=0;
	      z0=new Complex(Z[0]);
	  }

	  if(TEST==1) {
	       z0=GD.goDynamics(sign,-sign,z0,.0001);
               sign=-sign;
	  }

	  if(TEST==0) {
	      z0=GD.goDynamics(sign,sign,z0,.0001);  
	  }

	  if(defects==0) {
	    gp2=GD.getSegmentPath(z0);  
            gp.append(gp2,false);
	  }

          if((defects==1)&&(TEST>0)) {
	       gp2=GridCorrect.marker(z1);
               gp.append(gp2,false);    
	   }

	  ++i; 
          if(i%100==0) sendMessage(i);
	}


	halt=1;
	i=0; 
        z0=new Complex(M.G.SOURCE2);
	sign=-1;
	SWITCH=0;

	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(sign,sign,z0,0);

	  int TEST=0;
          if(choice==1) TEST=GridCorrect.decorate(GD,z1);

	  if(TEST==0) {
             z0=GD.goDynamics(sign,sign,z0,.00001);  
	  }


	  if(TEST==1) {
	       z0=GD.goDynamics(sign,-sign,z0,.00001);
               sign=-sign;
	  }

          if(TEST==2) {  
              Complex[] Z=GD.tripleDynamics(sign,z0,z1,.00001);
	      if(Z[1].x<-100) halt=0;
	      z0=new Complex(Z[0]);
	  }

           if(defects==0) {
	    gp2=GD.getSegmentPath(z0);
	    gp.append(gp2,false);  
	  }

	   if((defects==1)&&(TEST>0)) {
	       gp2=GridCorrect.marker(z1);
               gp.append(gp2,false);  
	   }

	  ++i;  
          if(i%100==0) sendMessage(i);
	}


	halt=0;


	M.G.nextPath(gp,COL,2+defects);  
	M.C.repaint();
	M.G.repaint();
    }

















    public int inside(double[] bb,Complex z) {
	if(z.x<bb[0]) return(0);
	if(z.x>bb[0]+bb[2]) return(0);	
        if(z.y<bb[1]) return(0);
	if(z.y>bb[1]+bb[3]) return(0);
	return(1);
    }



    public void defects() {
      double offset1=M.C.SB1.getParameter2(1);
      double offset2=M.C.SB2.getParameter2(0);
      int[] pq=M.C.SES.kiteIntegers();
      GridDynamics GD=new GridDynamics(pq[0],pq[1],offset1,offset2);
      Color COL=M.C.CON_G.ACTION.M[3].C;
      double[] IND0=GD.doGrid(1);
      double[] IND1=GD.single();
      int number=M.C.CON_G.I[5].val;
      IND0=GD.possibleIndices(0,pq[1],IND0,number);
      IND1=GD.possibleIndices(0,pq[1],IND1,number);
      GeneralPath gp=new GeneralPath();
      Complex w=new Complex();
      double[] bb=M.G.boundingBox(M);

      if(IND1!=null) {
        gp=getDefects(GD,3,4,IND1,IND1,bb);
        M.G.nextPath(gp,COL,3);
        gp=getDefects(GD,1,3,IND0,IND1,bb);
        M.G.nextPath(gp,COL,3);
        gp=getDefects(GD,2,3,IND0,IND1,bb);
        M.G.nextPath(gp,COL,3);
        gp=getDefects(GD,1,4,IND0,IND1,bb);
        M.G.nextPath(gp,COL,3);
        gp=getDefects(GD,2,4,IND0,IND1,bb);
        M.G.nextPath(gp,COL,3);
      }
      M.C.repaint();
      M.G.repaint();
    }


    public GeneralPath getDefects(GridDynamics GD,int i0,int i1,double[] IND0,double[] IND1,double[] bb) {

	int p=GD.P;
	int q=GD.Q;
	int i=0;
	int j=0;
	Complex w=new Complex();
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	halt=1;  
	while((halt==1)&&(i<IND0.length)) {
	    w=KiteGrid.intersection(i0,IND0[i],i1,IND1[j],p,q);
	    if(inside(bb,w)==1) {
	      int test=GridCorrect.decorate(GD,w);
	      if(test!=0) {
		  gp2=GridCorrect.marker(w);
	          gp.append(gp2,false);
	      }
	    }

	    ++j;
	    if(j==IND1.length) {
	       ++i;
	       j=0;
               sendMessage(i);
	    }
	}
	halt=0;
	return(gp);
    }


    public void gridDynamicsRenorm() {

	Color COL=Color.white;
	for(int i=0;i<5;++i) {
	    COL=M.C.CON_G.RC.CP[i].M[2].C;
	    if(M.C.CON_G.RC.CP[i].L[2].on==1)	gridDynamicsRenorm(i,COL);
	}

    }



    public  void gridDynamicsRenorm(int depth,Color COL) {	
        int thick=M.G.THICK[1].val;
	GeneralPath gp=new GeneralPath();
	GeneralPath gp2=new GeneralPath();
	GridDynamics GD=new GridDynamics(M,depth);


	Complex z0=new Complex(M.G.SOURCE2);
	Complex z1=new Complex();
	gp=GD.getSegmentPath(z0);

	halt=1;
	double LIM=M.C.CON_G.I[2].val;
	LIM=Math.pow(2,LIM);
	int i=0;

	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(1,1,z0,0);
	  int TEST=0;
	  z0=GD.goDynamics(1,1,z0,.0001);  
	  gp2=GD.getSegmentPath(z0);  
          gp.append(gp2,false);
	  ++i; 
          if(i%100==0) sendMessage(i);
	}

	z0=new Complex(M.G.SOURCE2);
	z1=new Complex();
	i=0;
	while((i<LIM)&&(halt==1)) {
	  z1=GD.goDynamics(-1,-1,z0,0);
	  int TEST=0;
	  z0=GD.goDynamics(-1,-1,z0,.0001);  
	  gp2=GD.getSegmentPath(z0);  
          gp.append(gp2,false);
	  ++i; 
          if(i%100==0) sendMessage(i);
	}


	halt=0;
	M.G.nextPath(gp,COL,2);
	M.C.repaint();
	M.G.repaint();
    }



}

