import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ControlCanvas extends Canvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    WordSquare I;
    ListenSquare[] L=new ListenSquare[10];
    int mode=2;
    SelectColor SC;  
    ControlPanel MOUSE,EXPORT,GLOBAL;
    ControlTiling CON_T;
    ControlGraph CON_G;
    Documentation DOC;  
    ShapeEntrySystem SES;
    ListenSquare GO,HALT;
    ComputeGraph CG;
    String message;
    ShapeEntryBasic2 SB1;
    ShapeEntryBasic SB2;

    SelectInteger SI;

    public ControlCanvas addManager(Manager M) {
	ControlCanvas Q=this;
	Q.M=M;
	return(Q);
    }

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 I=new WordSquare(0,0,300,15,"");
         L[0]=new ListenSquare(5,290,40,20,Color.white);
	 L[0].on=1;
	 SC=new SelectColor(M,3,530,420,65);
	 setPanels();
	 CON_T=new ControlTiling(110,10);
	 CON_G=new ControlGraph(110,10);
	 DOC=new Documentation();	 
         SES=new ShapeEntrySystem(427,3);
	 CG=new ComputeGraph();
         GO=new ListenSquare(3,230,30,20,new Color(200,0,200));
         GO.on=1;
         HALT=new ListenSquare(3,250,80,20,new Color(200,0,200));
         HALT.on=1;
	 SB1=new ShapeEntryBasic2(695,225);
	 SB1.I[0].val=1;
	 SB1.I[1].val=1;
	 SB2=new ShapeEntryBasic(540,175);
	 SB2.I[0].val=0;
	 SB2.I[1].val=1;
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      drawBG(g);
      drawAction(g);
      SC.render(g);
      EXPORT.render(g,0,143,100);
      MOUSE.render(g,0,58,100);
      GLOBAL.render(g,0,3,100);
      if(GLOBAL.mode==0) CON_T.render(g);
      if(GLOBAL.mode==1) CON_G.render(g);
      drawShape(g);
      SES.render(g);
      SB1.render(g);
      SB2.render(g);
   }

   public void drawBG(Graphics2D g) {
       g.setColor(new Color(0,40,60));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(new Color(0,30,80));
	g.fillRect(103,3,320,520);
	g.setColor(Color.white);
	g.drawRect(103,3,320,520);
	g.setColor(new Color(70,0,70));
	g.fillRect(427,3,372,160);
	g.setColor(Color.white);
	g.drawRect(427,3,372,160);
    }


    public void drawAction(Graphics2D g) {  
       g.setFont(new Font("Helvetica",Font.PLAIN,12));
       g.setColor(Color.white);
       L[0].render(g,new Color(200,0,0)); 
       g.setColor(Color.white);
       int x=(int)(L[0].x+5);
       int y=(int)(L[0].y+12);
       g.drawString("reset",x,y);
       GO.render(g,new Color(200,0,0)); 
       x=(int)(GO.x+5);
       y=(int)(GO.y+12);
       g.drawString("go",x,y);

       if(CG.halt==1) {
         HALT.render(g,new Color(200,0,200));
         x=(int)(HALT.x+6);
         y=(int)(HALT.y+14);
         g.drawString("halt "+message,x,y);
       }


    }


    public void setShape() {
	M.P.Q[0]=SES.getQuad();
    }

    public void setPanels() {
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,new Color(200,0,200)};
	 Color[] C1={new Color(160,0,160),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(0,160,0),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C3={new Color(200,0,100),Color.white,Color.white,Color.black,new Color(50,90,255)};
       	 Color[] C4={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};

	 //mouse emulator
	 String[] MouseString={"not needed","button 1 (Z)","button 2 (X)", "button 3 (C)", "mouse emulator"};
	 int[] MouseState={1,0,0,0};
         MOUSE=new ControlPanel(C3,MouseString,MouseState,4);

	 //export 
	 String[] ExportString={"no", "yes", "export"};
	 int[] ExportState={1,0};
         EXPORT=new ControlPanel(C3,ExportString,ExportState,2);

	 //global
	 String[] GlobalString={"tiling", "graph", "controls"};
	 int[] GlobalState={0,1};
         GLOBAL=new ControlPanel(C3,GlobalString,GlobalState,2);
	 GLOBAL.mode=1;



    }



    public void drawShape(Graphics2D g) {
	float r=(float)(0.5);
	if(r>1) r=1;
	AffineTransform AT1=AffineTransform.getScaleInstance(80,-80);
	AffineTransform AT2=AffineTransform.getTranslateInstance(520,380);

	Quad Q2=new Quad(SES.getParameter());

	GeneralPath[] gp=new GeneralPath[10];

	for(int i=1;i<=6;++i)  gp[i]=new GeneralPath();


	gp[1]=new GeneralPath();
	gp[1].moveTo(0,1);
	gp[1].lineTo(2,-1);
	gp[1].moveTo(0,-1);
	gp[1].lineTo(2,1);
	gp[1].moveTo(-1,0);
	gp[1].lineTo(1,2);
	gp[1].lineTo(2,1);



	gp[2]=Q2.toGeneralPath();

	gp[3].moveTo(0,0);
	gp[3].lineTo(0,2);
	gp[3].lineTo(2,2);
	gp[3].lineTo(2,0);
	gp[3].closePath();

	float t1=(float)(SB1.getParameter2(1));
	gp[4].moveTo(0,t1);
	gp[4].lineTo(2,t1);

	float t2=(float)(SB2.getParameter2(0));
	gp[5].moveTo(t2,0);
	gp[5].lineTo(t2,1);

	gp[6].moveTo((float)(t2-.01),(float)(t1-.01));
	gp[6].lineTo((float)(t2-.01),(float)(t1+.01));
	gp[6].lineTo((float)(t2+.01),(float)(t1+.01));
	gp[6].lineTo((float)(t2+.01),(float)(t1-.01));

	for(int i=1;i<=6;++i) {
	   gp[i].transform(AT1);
	   gp[i].transform(AT2);
    	}

        g.setColor(new Color(255,255,255,100));
	g.draw(gp[1]);

        g.setColor(new Color(50,100,255));
	g.fill(gp[2]);
	g.setColor(Color.white);
	g.draw(gp[2]);

	g.setColor(new Color(0,0,0,100));
	g.fill(gp[3]);	
        g.setColor(new Color(100,100,100));
	g.draw(gp[3]);

        g.setColor(new Color(255,150,0,100));
	g.draw(gp[4]);
	g.draw(gp[5]);

	g.setColor(new Color(255,255,0));
	g.setStroke(new BasicStroke(3));
	g.draw(gp[6]);
	g.setStroke(new BasicStroke(1));
    }

    public void goWord() {
	M.P.goWord(I.W);
	M.P.repaint();
    }


    public void clear() {
	M.P.tile=0;
	M.P.repaint();
	M.G.count=0;
	M.G.repaint();
    }

    public void mouseClicked(MouseEvent e) {	
        DOC.M=this.M;
	MouseData J=MouseData.process(e);
	int test=0;
	if(L[0].inside(J.X)==1) clear();
	int select_color=SC.process(e);
	if(select_color==20) DOC.colorSelectorInfo();
	int mouse= MOUSE.switchMode(J.X);
	if(mouse==20) DOC.mouse_info();
	int export = EXPORT.switchMode(J.X);
	if(export==20) DOC.export_info();
	int global=GLOBAL.switchMode(J.X);
	if(global==20) DOC.global_info();

	if(GLOBAL.mode==0) CON_T.process(e,SC.C,M);
	if(GLOBAL.mode==1) CON_G.process(e,SC.C,M);
	int sh_info=SES.process(e);	
        SB1.processMouse(e);	
        SB2.processMouse(e);	
	if(sh_info==20) DOC.shapeInfo();
	setShape();
	repaint();
	M.P.repaint();
	M.G.repaint();
	if(GO.inside(J.X)==1) doRun();
	if(HALT.inside(J.X)==1) CG.halt=0;
	
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {   
	SES.processKey(e);	
        SB1.processKey(e);	
        SB2.processKey(e);	
       CON_G.processKey(e);
       setShape();
       repaint();
    }
 
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}





    public void doRun() {
	if(SES.OPTION.mode!=0) SES.SB.reduce();
	if(SES.OPTION.mode!=0) SES.kiteToBarycenter();
	 CG=new ComputeGraph(M.G.SOURCE,M);
         new Thread(CG).start();
    }





}

