import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlGraph {
    Manager M;
    ControlPanel COLORS,COORD;
    ControlPanelColor BASIC,GRID,ACTION;
    Documentation DOC;
    SelectInteger[] I=new SelectInteger[15];
    int x,y;
    ListenSquare TEST;
    RenormalizeControl RC;

    public ControlGraph(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation();
      



	 TEST=new ListenSquare(x+190,y+100,60,30,null);
	 TEST.on=1;

	 setControlPanels();
	 setArrows();
	 RC=new RenormalizeControl(115,390);

    }



      public void setArrows() {
	 I[0]=new SelectInteger(x+200,y+264,32,16,5,0,18,1);  //block width
	 I[1]=new SelectInteger(x+200,y+288,32,16,5,0,18,1);  //block length
	 I[2]=new SelectInteger(x+200,y+220,40,20,7,0,18,1);  //graph length
	 I[3]=new SelectInteger(x+200,y+77,32,14,10,0,20,1);  //grid width
	 I[4]=new SelectInteger(x+200,y+94,32,14,5,0,15,1);  //grid dynamics - not used
	 I[5]=new SelectInteger(x+200,y+20,32,14,2,0,20,1);  //grid number
	 I[6]=new SelectInteger(x+200,y+40,32,14,10,0,15,1);  //grid lengths

	 I[10]=new SelectInteger(x+200,y+330,40,20,0,0,3,1);  //grid1 renorm
      }



 public void setControlPanels() {

   Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 Color[] C2={new Color(0,150,50),new Color(50,80,255),Color.red,Color.red,Color.white,new Color(100,0,100,200),Color.orange};



	 //object colors
	 String[] ColorString={"bg","colors"};
	 Color[] COL={Color.black};
	 int[] ColorState={0};
         COLORS=new ControlPanel(C1,ColorString,ColorState,1,COL);

	 //graph coordinates
	 String[] CoordString={"outer","grid","coords"};
	 int[] CoordState={1,0};
         COORD=new ControlPanel(C1,CoordString,CoordState,2);



	 //object actions
	 String[] ActionString={"grid:raw","grid:correct","decor path","decor all","outer path","outer all","renorm:raw","action"};

	 int[] ActionState={0,1,0,0,0,0,0};
         ACTION=new ControlPanelColor(C1,ActionString,ActionState,7,C2);
	 ACTION.mode=1;

 //toggle display of objects
	 String[] GraphShowString={"axes", "Z+Z","marker","baseline","cross","markings"};
         Color[]  GraphShowColor={new Color(100,100,200,200),new Color(0,100,100,100),new Color(255,0,255),new Color(255,0,255),new Color(100,100,100,100)};
	 int[] GraphShowState={0,0,1,1,0};
         BASIC=new ControlPanelColor(C1,GraphShowString,GraphShowState,5,GraphShowColor);


	 //grids
	 String[] GridShowString={"P1","P2","Q1","Q2","widths","multigrid"};
         Color[]  GridShowColor={new Color(80,0,0),new Color(80,0,0),new Color(0,0,120),new Color(0,0,120),new Color(150,50,150,100)};
	 int[] GridShowState={0,0,0,0,0};
         GRID=new ControlPanelColor(C1,GridShowString,GridShowState,5,GridShowColor);
 }









    public void render(Graphics2D g) {
	TEST.render(g,new Color(180,0,110));
	g.setColor(Color.white);
	g.drawString("penrose",x+205,y+120);
         COLORS.render2(g,x,y+100,90); 
         COORD.render(g,x,y+140,60); 
         ACTION.render(g,x,y+200,110); 
         BASIC.render(g,x,y,90); 
         GRID.render(g,x+97,y,90); 
	 drawArrows(g);
	 RC.render(g);
    }

    public void doTest(Manager M) {
        double offset=M.C.SB1.getParameter2(1);
	double d=PenroseRenormalize.fixRange(offset);
	int[] n=PenroseRenormalize.iteratedRenorm(d);

	for(int i=0;i<5;++i) RC.S[i].val=n[i];

    }


    public void drawArrows(Graphics2D g) {
	 g.setColor(new Color(0,0,255));	 
         g.fillRect(x+190,y,100,95);
	 g.setColor(Color.white);
	 g.drawString("grid parameters",x+200,y+12);
	 g.drawRect(x+190,y,100,95);

         g.setColor(new Color(0,0,255));	 
	 g.fillRect(x+190,y+200,100,115);
	 g.setColor(Color.white);
	 g.drawString("plot amount",x+200,y+212);
	 g.drawRect(x+190,y+200,100,115);

         I[0].render2(g,Color.red,Color.white,Color.white);
	 I[1].render2(g,Color.red,Color.white,Color.white);
	 I[2].render2(g,Color.red,Color.white,Color.white);

	 I[3].render(g,new Color(200,0,200),Color.white,Color.white);
	 I[5].render(g,new Color(200,0,200),Color.white,Color.white);
	 I[6].render2(g,new Color(200,0,200),Color.white,Color.white);

	 I[10].render(g,new Color(200,0,200),Color.white,Color.white);
    }

    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
	int test2=COLORS.recolor(J.X,C);
	int test1=BASIC.process(J.X,C);
	if(test1==20) DOC.basicInfo();
	int action=ACTION.process(J.X,C);
	COORD.switchMode(J.X);
	if(action==20) DOC.AGPInfo();
	for(int i=0;i<3;++i) I[i].modify(J.X);

	int test3=GRID.process(J.X,C); 
	for(int j=3;j<=6;++j) I[j].modify(J.X);
	I[10].modifyCyclic(J.X);
	if(TEST.inside(J.X)==1) doTest(MM);
	RC.process(e,C,MM);

    }

    public void processKey(KeyEvent e) {
    }

}

