import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class ControlTiling {
    Manager M;
    ControlPanel COLORS,ACTION,MULTI,POWER;
    ControlPanelColor MARKER;	 
    TileCoordsDisplay VCD;
    TilingClipControl TCC;  
    SelectInteger[] INT=new SelectInteger[4];
    int x,y;
    Documentation DOC;

    public ControlTiling(int xx,int yy) {
	x=xx;
	y=yy;
	DOC=new Documentation();
         Color[] C0={new Color(50,100,255),Color.white,Color.white,Color.black,Color.red};
	 Color[] C1={new Color(0,180,180),Color.white,Color.white,Color.black,new Color(50,90,255)};


	 //toggle display of objects

	 //toggle display of objects
	 String[] TileShowString={"diamonds", "frame","strips","display"};
         Color[]  TileShowColor={new Color(100,100,100,100),new Color(0,30,150),new Color(255,0,0,30)};
	 int[] TileShowState={0,1,0};
         MARKER=new ControlPanelColor(C1,TileShowString,TileShowState,3,TileShowColor);

	 //object colors
	 String[] ColorString={"edge","bg","kite","colors"};
	 Color[] COL={Color.white,Color.black,new Color(50,90,255)};
	 int[] ColorState={0,0,0};
         COLORS=new ControlPanel(C1,ColorString,ColorState,3,COL);

	 //power of map
	 String[] PowerString={"1","2","power"};
	 int[] PowerState={0,1};
         POWER=new ControlPanel(C1,PowerString,PowerState,2);
	 POWER.mode=1;


	 //button 2 selector
	 String[] ActionState={"plot","recolor orbit","erase orbit","recolor tile","tile coords","button 2"};
	 int[] ButtonState={1,0,0,0,0,0};
         ACTION=new ControlPanel(C1,ActionState,ButtonState,5,0);

	 //tile coords display
         VCD=new TileCoordsDisplay(x,y+263); 
	 //orbit tracer

	 //orbit type selector
	 String[] IterationString={"whole orbit","#","return","plot type"};
	 int[] IterationState={1,0,0};
         MULTI=new ControlPanel(C1,IterationString,IterationState,3);
	 MULTI.mode=0;	      
         INT[0]=new SelectInteger(x+135,y+35,30,13,1,1,20,1);  //orbit length
	 TCC=new TilingClipControl(x,y+140); 


    }

    public void render(Graphics2D g) {
         MULTI.render2(g,x+100,y,90);   
         POWER.render(g,x+200,y,90);   
         COLORS.render2(g,x,y+70,90); 
         MARKER.render(g,x,y,90);
         INT[0].render(g,Color.red,Color.white,Color.black);  
	 TCC.render(g);
    }




  public void vertexCoordsProcess(MouseEvent e) {
	int stats=VCD.process(e);
	if(stats==1) M.P.repaint();
	if(stats==20) DOC.stats_info();
     }
  public void modifyOrbitType(Point X) {
	int multi=MULTI.switchMode(X);               	
	if(multi==20) DOC.multiInfo();
        INT[0].modify(X);
     }

    public void process(MouseEvent e,Color C,Manager MM) {
	DOC.M=MM;	
        MouseData J=MouseData.process(e);
	int test1=MARKER.process(J.X,C);
	if(test1==20) DOC.markerInfo();
	int test2=COLORS.recolor(J.X,C);
	if(test2==20) DOC.colorInfo();
	int pcc=TCC.processMouse(J.X,DOC);   
	int power=POWER.switchMode(J.X);  
	if(power==20) DOC.power_info();            
	vertexCoordsProcess(e);
	modifyOrbitType(J.X);	 
    }

}

