import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class DocumentTiling {
    Manager M;
    public DocumentTiling(Manager MM) {
	this.M=MM;
    }


  public void pictureCanvasInfo() {
	String S="tiling window. ";

	S=S+"\n\n The tiling window displays a certain tiling associated to a rational outer billiards system. In general, an outer billiards system is based on a convex shape S.  Starting with a point x0 outside of S, we let x1 be the point such that the line segment x0x1 is tangent to S at the midpoint, and S lies to the right of this line segment.  By this we mean that a person walking from x0 to x1 would encounter S on the right. There are certain points x0 for which this construction does not work, but it does work in the complement of a countable set of lines.  The iteration x0-->x1--x2... is then defined for almost all points in the complement of S.  This is the outer billiards system.";

	S=S+"\n\nWe say that the outer billiards system is rational if S is a convex polygon with rational vertices. Thi program lets you investigate the structure of rational outer billiards systems based on quadrilaterals.";

	S=S+"\n\nIn the case of a rational outer billiard system, there is a locally finite tiling of the complement of S, with the following property:  Any two points in the same tile have the same combinatorial orbit under the outer billiards map.  If you click on a point in the tiling window, Billiard King computes the tile containing that point and draws its orbit.  If you click on many points, you can recover the entire tiling, within some predetermined bounding box.";

	S=S+"\n\nThe color of the tiles is determined by the color selector, one of the other windows of Billiard King.  If you modify the color on the color selector then the tiles are drawn in a different color.  In this way, you can see some of the dynamical properties of the tiling.  \n\nOnce you have drawn an orbit you can modify its appearance in several ways.  For instance, you can recolor the entire orbit, or recolor an individual tile within the orbit.  Also, you can erase the orbit.  These actions are always done with the middle mouse button (button 2).  You use the control panel to select which action button 2 has.";
	S=S+"\n\nYou can also use the control panel to change the bounding box.  The  X and  Y fields allow you to do this.  Finally, you can scale the picture in the tiling window using the left and right mouse buttons.  There are a variety of other ways you can interact with the tiling, and the documentation for the control panel explains this.";

	M.E.setExplain(S);
	M.E.repaint();
    }




    public void multiInfo() {

	String S="plot controls";

	S=S+"\n\nThis control panel lets you decide how much of the orbit you want to plot. No matter what you decide, Billiard King computes the full orbit of any point you select.  What Billiard King actually computes is the maximal convex polygon of orbits all having the same combinatorial type as the point you have selected.  There are then three things you can do with this polygon and its orbit:";

	S=S+"\n\nwhole orbit: Up to certain limits, you can plot the whole orbit. First, Billiard King only plots the tiles that lie within the bounding box set by X and Y keys in the 'limits' control panel. Second, Billiard king only plots up to the number of tiles specified by the # key in the 'limits' control panel.   Even with these limits in place, you should use this option with caution.  Even for relatively simply rationals, some of the orbits can get huge.  These orbits, if plotted without any constraints, will hang up the program.  A nice option is to set the Y number very small, so that you are just plotting in a thin strip around the X axis.  With practice, you can learn to deduce the structure of the whole orbit from the picture in a thin strip.";


	S=S+"\n\n#: You can select a number between 1 and 19 using the arrow keys.  Then you will plot this number of tiles from the beginning part of the orbit.";



	S=S+"\n\nreturn:This option shows the return of the square outer billirds map to the strip mentioned above.";


	M.E.setExplain(S);
	M.E.repaint();
    }


    public void actionInfo() {

	String S="tile modification";
	S=S+"\n\nThis control panel controls the action of button 2 on the main tiling window.  We will explain the different options one at a time.";

	S=S+"\n\nplot: This is the normal mode.  When you are using this option, and you click on the main window, you cause Billiard King to compute the orbit of one of the tiles in the tiling associated to the outer billiards system. If you don't know that this means, you should read the documentation for the main window.";

	S=S+"\n\nrecolor orbit: When this option is activated, you can recolor an orbit on the main window according to the current color on the color selector.";

	S=S+"\n\nerase orbit: This is self-explanatory.";

	S=S+"\n\nrecolor tile: This option is like the option for recoloring orbits, except that here you recolor individual tiles.";


	S=S+"\n\ntile coords: This option lets you see the coordinates of the vertices of the tiles you have plotted in the tiling window.  When you select this option, an orange window pops up on the right.  If you click on a tile, you can see the coordinates of one of its vertices.  You can use the arrow keys in the orange window to select different vertices within the same tile.  The selected vertex is indicated by a white pointer drawn over the tile. ";
	M.E.setExplain(S);
    }


    public void power_info() {

	String S="map selector";

	S=S+"\n\nWith this control panel, you can select either the outer billiards map itself or the square of the outer billiards map.  The number 1 corresponds to the outer billiards map, and the number 2 corresponds to the square.";

	S=S+"\n\nThis note refers to the '#' option on the iteration window.  When you select the 1 option, the number of tiles you plot is twice the number as indicated by the arrow key.  When you select the 2 option, you get exactly the number as indicated on the arrow key.";

	S=S+"\n\nThe 'strip' option of plotting forces the square of the outer billiards map.  This corresponds to the convention in the monograph.";

	S=S+"\n\nThe '1st return option' of plotting also forces the square of the outer billiards map.";

	M.E.setExplain(S);
	M.E.repaint();
    }


    public void stats_info() {

	String S="coordinate display";

	S=S+"\n\nThis console displays the coordinates of the vertices of a tile in the main tiling window. There are 2 options for the display:";

	S=S+"\n\n decimal: computes a decimal approximation to the vertex.";

	S=S+"\n\n Q: computes a rational approximation to the vertex, using the classical continued fraction algorithm.  The arrow keys control the accuracy of the approximation. ";

	S=S+"\n\nThe arrow keys let you cycle through the vertices of the selected tile";

	S=S+"\n\nYou can see this window in action as follows.  First plot a tile in the tiling window.  Then reset the 'button 2' control panel to 'tile coords' to again bring up this window. Finally, click on  the tile using button 2.  Then you will see the coordinates of a tile vertex, as well as a white segment that points to that vertex.";

	M.E.setExplain(S);
    }





    public void clipInfo() {

	String S="plot limit control";

	S=S+"\n\nThis control panel lets you set limits on the amount of plotting done by the program. Setting these limits are important because the orbits tend to be huge even for fairly simple rational parameters.";

	S=S+"\n\nThe 'X' and 'Y' buttons control the size of the frame around the tiling. Billiard King only plots the tiles which intersect the unframed part of the window, though it computes all the tiles in the orbit.";

	S=S+"\n\nThe # button controls the maximum number of tiles Billiard King will plot from a single orbit. ";

M.E.setExplain(S);
    }




    public void stripInfo() {

	String S="strip manager ";

	S=S+"\n\nThis control panel lets you manage the display of 4 infinite strips on the tiling window.  These strips control the structure of the outer billiards map on the kite.";

	S=S+"\n\nYou can best appreciate what these strips mean by setting the 'iteration' window to 'first return', and then plotting the orbit of a point of the form (x,1) or (x,-1) where x is a positive real number.  To guide you in choosing such a point, you should turn on the 'X lines' option.  You access the 'X lines' option by setting the 'display' window to 'tiling'.  Once you have selected a point of the form we have described, you can plot its first return map and see that the orbit travels in a straight line until it lands in one of the strips.";

	S=S+"\n\nIt turns out that we can factor the first return map into a product of 8 maps, which we call strip maps.  The data for each strip map is a pair (S,V), where S is a strip and V is a vector that points from one boundary line of S to the other.  Given a point not in S, we can add a suitable integer multiple of V until the resulting point lies in the strip. This is the strip map.   In other words, the point p is mapped to q=p+nV, where n is chosen such that q lies in S.";

	S=S+"\n\nIf you consider the first return map for points of the form (x,1) and (x,-1), where x is a large positive number, you can probably get a sense of how the factorization works.  The amazing thing is that the same factorization works for all x>0.  In order to prove this, we make a careful study of how the strips interact with the regions we call 'zones'.  If you click on the documentation for the 'zone' window, you can read about the zones.";

	S=S+"\n\nThere is one more feature of the strip interface we would like to point out.  Billiard King draws these strips in a certain order, but you can change this order by using the 4x4 checkerboard beneath the 'strip' control panel.  This 4x4 grid essentially represents a permutation, which you can specify.  If you change the permutation, you permute the order in which the strips are drawn.  This feature is useful if you want to understand how the strips overlap.";

	M.E.setExplain(S);
	M.E.repaint();
    }



    public void markerInfo() {

	String S="window markings";

	S=S+"\n\nThis control panel toggles the display of some auxilliary objects.  The left button beside each object controls the color and the right button toggles the display.";

	S=S+"\n\nX lines: This option displays the set of evenly spaced horizontal lines that is invariant under the outer billiards map.  The X axis is also drawn, even though the X axis is not part of the family of horizintal lines we have in mind.";

S=S+"\n\nframe: This simply draws a frame around the tiling.  You can change the size of the frame using the 'X' and 'Y' fields on the 'plot range' control panel.  You can recolor the frame using the 'frame' button on the 'colors' control panel.";

S=S+"\n\n diamonds:  This is another grid related to the structure of outer billiards on kites.  The outer billiards tiling is always a sub-partition of these diamonds.   Each diamond is bisected by the x-axis, and there is a union of 4-6 tiles centered on the axis of symmetry.  You can see these tiles by setting the 'iteration' window to 'diamonds' and then clicking anywhere on the tiling window.";

S=S+"\n\nstrips: This button turns on an additional control panel.  The additional control panel manages a certain collection of 4 strips that play an important role for outer billiards on kites.  You can read more about these strips in the documentation for the additional control panel when it appears.";

S=S+"\n\nnecklace: This turns on the display of a line segment in the tiling window.  The endpoints of the line segment touch a portion of the tiling called a necklace.  If you plot the full orbit of the endpoint of this segment, you will see what a necklace is.";

	M.E.setExplain(S);
	M.E.repaint();
    }




    public void stripColorInfo() {
	String S="This window lets you color the 4 infinite strips on the tiling window.  You should read the documentation for the strip window to learn about the significance of these strips.";

	M.E.setExplain(S);
	M.E.repaint();
    }






    public void zoneInfo() {
	String S="This window lets you plot 10 regions (or zones) that control the structure of outer billiards on kites.";

	S=S+"\n\nLet F denote the square of the outer billiards map.  Then F (when defined) acts on each point as a translation.  That is, for each point p, there is a vector V(p) such that F(p)=p+V(p).  The assignment p->V(p) is locally constant.   The vector V(p) is always twice the difference between a pair of vertices of the kite.  Thus, there are 12 possibilities for V(p).  In fact, 10 of these choices actually appear.";

	S=S+"\n\nThus, there are 10 zones, which we call R1,R3,R3,R4,R4s,R5,R6f,R6,R7,R8.  Corresponding to Rn there is the vector Vn.  So, if p lies in Rn then V(p)=Vn. The regions R1,R2,...,R8 are noncompact and the regions R4s and R6f are compact.  You can best appreciate the decomposition by turning on all the zones, and then using the slider to change the kite parameter.  Dragging the mouse on the slider, you get a nice animated view of the zones.";

	S=S+"\n\nIf you want to see how the zone control the map F, you should set the 'iteration' window to '#', and set the adjacent integer selector to 2.  Then, when you click on the tiling window, you will plot both a tile and its image under F.";

	S=S+"\n\nUnderstanding the zones Rn is only half the story.  To really understand the dynamical picture, you should really understand both Rn and Rn+Vn.  The window entitled 'shift' lets you draw these shifted zones (that is, Rn+Vn) and compare them to the original zones.  In proving our Pinwheel Lemma, we make a careful study of the sets (Ra+Va) intersect Vb.  These intersections, which give us combinatorial information about the outer billiards orbit, are closely related to the intersections of the strips.  By playing with the strips and the zones at the same time, you can understand all possible intersections.";

	M.E.setExplain(S);
	M.E.repaint();
    }

    public void zoneShiftInfo() {
	String S="This window lets you plot the shifts of the 10 regions (or zones) that control the structure of outer billiards on kites.";

	S=S+"\n\nLet F denote the square of the outer billiards map.  Then F (when defined) acts on each point as a translation.  That is, for each point p, there is a vector V(p) such that F(p)=p+V(p).  The assignment p->V(p) is locally constant.   The vector V(p) is always twice the difference between a pair of vertices of the kite.  Thus, there are 12 possibilities for V(p).  In fact, 10 of these choices actually appear.";

	S=S+"\n\nThus, there are 10 zones, which we call R1,R3,R3,R4,R4s,R5,R6f,R6,R7,R8.  Corresponding to Rn there is the vector Vn.  So, if p lies in Rn then V(p)=Vn. The regions R1,R2,...,R8 are noncompact and the regions R4s and R6f are compact.  You can best appreciate the decomposition by turning on all the zones, and then using the slider to change the kite parameter.  Dragging the mouse on the slider, you get a nice animated view of the zones.";

	S=S+"\n\nIf you want to see how the zone control the map F, you should set the 'iteration' window to '#', and set the adjacent integer selector to 2.  Then, when you click on the tiling window, you will plot both a tile and its image under F.";

	S=S+"\n\nUnderstanding the zones Rn is only half the story.  To really understand the dynamical picture, you should really understand both Rn and Rn+Vn.  The window entitled 'shift' lets you draw these shifted zones (that is, Rn+Vn) and compare them to the original zones.  In proving our Pinwheel Lemma, we make a careful study of the sets (Ra+Va) intersect Vb.  These intersections, which give us combinatorial information about the outer billiards orbit, are closely related to the intersections of the strips.  By playing with the strips and the zones at the same time, you can understand all possible intersections.";

	M.E.setExplain(S);
	M.E.repaint();
    }

    public void colorInfo() {
	String S="color scheme";

    S=S+"\n\nThis control panel lets you change the colors of various objects on the tiling window. You should first select a color using the color selector at the bottom of the control panel.  Once you have selected a color you like, you can click on one of the buttons in this window.  Some of the options refer to already existing objects, such as the background color, and other options refer to objects that will appear when you plot them.";

	M.E.setExplain(S);
	    M.E.repaint();
    }





}


