import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class FareyCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex SOURCE=new Complex(0,0);
    FareyTriangle[] FT=new FareyTriangle[10000];
    Color[] COL=new Color[10000];
    int count;
    ControlPanel ACTION;
    int CHOICE;
    int VERTEX;
    Documentation DOC;



    public FareyCanvas addManager(Manager M) {
	FareyCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public FareyCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,100);
	 initialize();  
         setPanel();
	 DOC=new Documentation();
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawTriangles(g);
      drawVertex(g);
      ACTION.render(g,0,0,80);
   }


    public void drawTriangles(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	    gp=FT[i].toGeneralPath();
	    g.setColor(COL[i]);
	    gp=transform(gp);
	    g.fill(gp);
	    g.setColor(Color.white);
	    g.draw(gp);
	}
    }

    public void drawVertex(Graphics2D g) {
	Vector V=FT[CHOICE].V[VERTEX];
	float[] f=FareyTriangle.toPoint(V);
	GeneralPath gp=new GeneralPath();
	double d=FT[CHOICE].minSide();
	d=d*.1;
	gp.moveTo((float)(f[0]-d),(float)(f[1]-d));
	gp.lineTo((float)(f[0]-d),(float)(f[1]+d));
	gp.lineTo((float)(f[0]+d),(float)(f[1]+d));
	gp.lineTo((float)(f[0]+d),(float)(f[1]-d));
	gp.closePath();
	gp=transform(gp);
	g.setColor(new Color(0,0,0,120));
	g.fill(gp);
	g.setColor(new Color(255,255,255,120));
	g.draw(gp);
    }




    public void setPanel() {
	Color[] C0={new Color(50,100,255,100),Color.white,Color.white,Color.white,new Color(20,100,255)};
	String[] ActionString={"subdivide","select","clear","options"};
	int[] ActionState={1,0,0};
         ACTION=new ControlPanel(C0,ActionString,ActionState,3);
    }


    public void initialize() {
        COL[0]=new Color(0,50,250);
	FT[0]=new FareyTriangle();
	FT[0].V[0]=new Vector(1,0,0);
	FT[0].V[1]=new Vector(0,1,0);
	FT[0].V[2]=new Vector(0,0,1);
	CHOICE=0;
	VERTEX=0;
	count=1;
    }

    public int getInside() {
	int index=-1;
	for(int i=0;i<count;++i) {
	    if(FT[i].inside(SOURCE)==1) index=i;
	}
	return(index);
    }

    public void getVertex() {

	FareyTriangle T=new FareyTriangle(FT[CHOICE]); 
	FareyTriangle TT=new FareyTriangle();
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(i!=j) {
		    TT=T.subdivide(i,j);
		    if(TT.inside(SOURCE)==1) VERTEX=i;
		}
	    }
	}
    }



    public void next() {
	if(ACTION.mode==0) subdivide();
	if(ACTION.mode==1) select();
    }

    public void subdivide() {
	GeneralPath gp=new GeneralPath();
	int k=getInside();
	FareyTriangle TT=new FareyTriangle();
	if(k!=-1) {
	     FareyTriangle T=new FareyTriangle(FT[k]);
	     for(int i=0;i<3;++i) {
		 for(int j=0;j<3;++j) {
		     if(i!=j) {
	                 TT=T.subdivide(i,j);
			     FT[count]=new FareyTriangle(TT);
                             COL[count]=M.C.SC.C;
			     ++count;
		     }
		 }
	     }
	}
    }

    public void select() {
	GeneralPath gp=new GeneralPath();
	int k=getInside();
	FareyTriangle TT=new FareyTriangle();
	if(k!=-1) CHOICE=k;
	COL[CHOICE]=M.C.SC.C;
	getVertex();

	Vector V=FT[CHOICE].V[VERTEX];
	M.C.SES.S.I[0].val=(int)(V.x[2]);
	M.C.SES.S.I[1].val=(int)(V.x[1]);
	M.C.SES.S.I[2].val=(int)(V.x[0]);
	M.P.Q[0]=M.C.SES.getQuad();
	M.P.repaint();
	M.C.repaint();
	M.G.repaint();
    }













     public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
	DOC.M=this.M;
	MouseData J=MouseData.process(e);
	int mode=J.mode;
	if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;

	int test1=ACTION.mode;
	int test=ACTION.switchMode(J.X);
	if(test==20) DOC.fareyInfo();
	if(test==2) {count=1;ACTION.forceMode(test1);}

	if(test==-1) {

           if(mode==1) scaleUp(J.X,-1);
           if(mode==3) scaleUp(J.X,+1);

	  if(mode==2) {
               SOURCE=unTransform(J.X);
	       next();
	  }
	}
	repaint();
  	M.C.repaint();
    }
}
