import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GraphMarkings {
    public GraphMarkings() {
    }




    public static void drawAxes(Graphics2D g,Manager M) {

	GeneralPath gp=new GeneralPath();
	gp.moveTo(0,-100);
	gp.lineTo(0, 100);
	gp.moveTo(-100,0);
	gp.lineTo( 100,0);
	double A=M.C.SES.kiteParameter();
	int choice=M.C.CON_G.COORD.mode;
	gp=M.G.transform(gp,A,choice);
	g.setColor(M.C.CON_G.BASIC.M[0].C);
	g.draw(gp);
    }

    public static void drawGrid(Graphics2D g,Manager M) {

	GeneralPath gp=new GeneralPath();
	for(int i=-50;i<50;++i) {
	    gp.reset();
	    Complex z=M.G.SOURCE;
	    int x=(int)(z.x);
	    int y=(int)(z.y);
	    gp.moveTo(x+i,y-50);
	    gp.lineTo(x+i,y+50);
	    gp.moveTo(x-50,y+i);
	    gp.lineTo(x+50,y+i);
	    double A=M.C.SES.kiteParameter();	
            int choice=M.C.CON_G.COORD.mode;
	    gp=M.G.transform(gp,A,choice);
	    g.setColor(M.C.CON_G.BASIC.M[1].C);
	    g.draw(gp);
	}
    }



    public static void drawBaseline(Graphics2D g,Manager M) { 
	Output temp=new Output();
	if(M.C.EXPORT.mode==1) temp=new Output("Output/baseline");
	double d=M.C.SB2.getParameter2(0);
	GeneralPath gp=new GeneralPath();
	Complex z=M.C.SES.getComplex();
	 gp.moveTo(-100,(float)( 100*z.x-.5*d));
	 gp.lineTo( 100,(float)(-100*z.x-.5*d));
         double A=M.C.SES.kiteParameter();	
         int choice=M.C.CON_G.COORD.mode;
         gp=M.G.transform(gp,A,choice);
  	 Color COL=M.C.CON_G.BASIC.M[3].C;
  	 g.setColor(COL);
  	 g.draw(gp);
	 if(M.C.EXPORT.mode==1) temp.lineWrite(gp,COL,1);
    }



    public static void thinGrid(Graphics2D g,Manager M,int choice) {	
      KiteGrid KG=new KiteGrid();
      double[] bb=M.G.boundingBox(M);
      double offset1=M.C.SB1.getParameter2(1);
      double offset2=M.C.SB2.getParameter2(0);
      int[] pq=M.C.SES.kiteIntegers();
      int p=pq[0];
      int q=pq[1];
      int number=M.C.CON_G.I[5].val;
      int extent=M.C.CON_G.I[6].val;
      double[] d={offset1,offset2};
      GeneralPath gp=KG.thinGrid(choice,p,q,d,number,extent,bb);  
      Color CC=M.C.CON_G.GRID.M[choice-1].C;
      double A=1.0*p/q;	
      int choice2=M.C.CON_G.COORD.mode;
      gp=M.G.transform(gp,A,choice2);
      g.setColor(CC);
      g.draw(gp); 	 
      if(M.C.EXPORT.mode==1) {
        Integer CHOICE=new Integer(choice);
        String S="Output/grid"+CHOICE.toString();
	Output temp=new Output(S);
        temp.blockWrite(gp,CC,1);
      }
    }



    public static void thickGrid(Graphics2D g,Manager M) {
	thickGrid(g,M,1);
	thickGrid(g,M,2);
	thickGrid(g,M,3);
	thickGrid(g,M,4);
    }

    public static void thickGrid(Graphics2D g,Manager M,int choice) {
      KiteGrid KG=new KiteGrid();  
      double[] bb=M.G.boundingBox(M);
      double offset1=M.C.SB1.getParameter2(1);
      double offset2=M.C.SB2.getParameter2(0);  
      double[] d={offset1,offset2};
      int[] pq=M.C.SES.kiteIntegers();
      int p=pq[0];
      int q=pq[1];
      double A=1.0*p/q;
      double width=1.0*M.C.CON_G.I[3].val/40.0;
      int number=M.C.CON_G.I[5].val;
      int extent=M.C.CON_G.I[6].val;

      GeneralPath gp=KG.thickGrid(choice,p,q,d,width,number,extent,bb);	
      int choice2=M.C.CON_G.COORD.mode;
      gp=M.G.transform(gp,A,choice2); 
      Color CC=M.C.CON_G.GRID.M[4].C;
      g.setColor(CC);
      g.fill(gp); 
    }


    public static void cross(Graphics2D g,Manager M,Complex SOURCE2) {

      KiteGrid KG=new KiteGrid();
      double offset=M.C.SB1.getParameter2(1);
      int[] pq=M.C.SES.kiteIntegers();
      int p=pq[0];
      int q=pq[1];  
      double A=1.0*p/q;
      int extent=M.C.CON_G.I[6].val;
      GeneralPath gp=KG.extraGrid(p,q,SOURCE2,extent);
      Color CC=M.C.CON_G.BASIC.M[4].C;	
      int choice=M.C.CON_G.COORD.mode;
      gp=M.G.transform(gp,A,choice);
      g.setColor(CC);
      g.draw(gp); 
    }


    public static void thinGridRenorm(Graphics2D g,Manager M) {

      Renormalize R=new Renormalize(M);
      int[] pq=M.C.SES.kiteIntegers();
      int p=pq[0];
      int q=pq[1];  
      double A=1.0*p/q;
      Color CC=Color.white;
      GeneralPath gp=new GeneralPath();

      for(int i=0;i<5;++i) {
	      for(int j=1;j<=4;++j) {
		  int jj=(j-1)/2;
		    if(M.C.CON_G.RC.CP[i].L[jj].on==1) {
                      gp=R.finalGrid(i,j);   
		      CC=M.C.CON_G.RC.CP[i].M[jj].C;
                      int choice2=M.C.CON_G.COORD.mode;
                      gp=M.G.transform(gp,A,choice2);
                      g.setColor(CC);
                      g.draw(gp); 
		    }
	      }
      }
    }





}
