import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class GridDynamics {
    Manager M;
    double[] P_INDEX=new double[100000];
    double[] Q_INDEX=new double[100000];
    int P;
    int Q;
    double OFFSET1,OFFSET2;
    int RENORM1;
    int SWITCH;


    public GridDynamics() {}

    public GridDynamics(int p,int q,double offset1,double offset2) {
	this.P=p;
	this.Q=q;
	this.OFFSET1=offset1;
	this.OFFSET2=offset2;
	double[] d={offset1,offset2};
	this.P_INDEX=KiteGrid.pGrid(p,q,d);
	this.Q_INDEX=KiteGrid.qGrid(p,q,d);
	SWITCH=0;
    }


    public GridDynamics(int p,int q,double offset1,double offset2,int renorm1) {
	this.P=p;
	this.Q=q;
	this.OFFSET1=offset1;
	this.OFFSET2=offset2;
	this.RENORM1=renorm1;
	double[] d={offset1,offset2};
	this.P_INDEX=Renormalize.newGrid(1,p,q,d,renorm1);
	this.Q_INDEX=Renormalize.newGrid(3,p,q,d,renorm1);
	SWITCH=1;
    }


    public GridDynamics(Manager MM,int depth) {
	Renormalize R=new Renormalize(MM);
	int[] pq=MM.C.SES.kiteIntegers();
	P=pq[0];
	Q=pq[1];
	P_INDEX=R.finalSequence(depth,1);
	Q_INDEX=R.finalSequence(depth,3);
	SWITCH=1;
    }






    public double[] doGrid(int k) {
	if(k==1) return(P_INDEX);
	if(k==2) return(P_INDEX);
	if(k==3) return(Q_INDEX);
	if(k==4) return(Q_INDEX);
	return(null);
    }





    public static double rawFunctional1(int p,int q,double x,double y) {
	double[] d=new double[2];
	d[0]=1.0*p*(p-q)/(p+q);
	d[1]=1.0*p*(-p*p+4*p*q+q*q)/(2.0*q*(p+q));
	double f=d[1]*x-d[0]*y;
	return(f);
    }



    public static double rawFunctional2(int p,int q,double x,double y) {
	double[] d=new double[2];
	d[0]=1.0*p;
	d[1]=1.0*p*(q-p)/(2.0*q);	
        double f=d[1]*x-d[0]*y;
	return(f);
    }


    public static double rawFunctional3(int p,int q,double x,double y) {
	return(x);
    }


    public static double rawFunctional4(int p,int q,double x,double y) {
	double[] d=new double[2];
	d[0]=2.0*p*q/(p+q);
	d[1]=(-3.0*p*p+2.0*p*q+q*q)/(2.0*p+2.0*q);
	double f=d[1]*x-d[0]*y;
	return(f);
    }



    public static double rawFunctional(int choice,int p,int q,double x,double y) {
	if(choice==1) return(rawFunctional1(p,q,x,y));
	if(choice==2) return(rawFunctional2(p,q,x,y));
	if(choice==3) return(rawFunctional3(p,q,x,y));
	if(choice==4) return(rawFunctional4(p,q,x,y));
	return(0);
    }



    public static double functional(int choice, int p,int q,double x,double y) {
	double t1=rawFunctional(choice,p,q,q,-p);
	double t2=rawFunctional(choice,p,q,x,y);
	double t3=q*t2/t1;
	return(t3);
    }

    public double functional(int choice,double x,double y) {
	return(functional(choice,P,Q,x,y));
    }
	       





    public static double[] possibleIndices(int f,int q,double[] IND) {
	return(possibleIndices(f,q,IND,6));
    }

    public static double[] possibleIndices(int f,int q,double[] IND,int stretch) {
	if(IND==null) return(null);
	int l=IND.length;
	double[] IND2=new double[stretch*l];
	int jj=0;
	for(int i=0;i<l;++i) {
	    for(int j=0;j<stretch;++j) {
		jj=j-stretch/2;
	        IND2[i+j*l]=IND[i]+f*q+jj*q*2;
	    }
	}
	return(IND2);
    }










    public double[] single() {
	if(Q_INDEX==null) return(null);
	int len=Q_INDEX.length;
	double[] list=new double[2*len];
	int count=0;
	for(int i=0;i<len-1;++i) {
	    if(Q_INDEX[i+1]==Q_INDEX[i]+1) {
                  list[count]=Q_INDEX[i];
                  list[count+1]=Q_INDEX[i]+1;
		  count=count+2;
		}
	}
	if(count==0) return(null);
	double[] list2=new double[count];
	for(int i=0;i<count;++i) list2[i]=list[i];
	return(list2);
    }






    /*returns the index of the nearest line, plus the functional distance to that line*/






    public double[] lineIndex1(int choice,Complex z) {
	double x=z.x;
	double y=z.y;
	double[] IND=doGrid(choice);
	double f1=functional(choice,x,y);
	double f2=Math.floor(f1/Q);
	if((2000+f2)%2==1) f2=f2+1;
	int ind=(int)(f2);
	IND=possibleIndices(ind,Q,IND);
	if(IND==null) return(null);

	double near=0;
	double min=10000;
	double test=0;

	for(int i=0;i<IND.length;++i) {
	    double ii=IND[i];
	    test=Math.abs(f1-ii);
	    if(test<min) {
		min=test;
		near=ii;
	    }
	}
	double[] NEAR={near,min};
	return(NEAR);
    }












    /*returns the index and type of line that is closest in the functional sense.*/




    public double[] lineIndex2(Complex z) {

	double[][] near=new double[5][2];

	for(int i=1;i<5;++i) {
	    near[i]=lineIndex1(i,z);
	}
	double min=1000;
	int choice=0;
	double test=0;
	for(int i=1;i<5;++i) {
	    if(near[i]!=null) {
	     test=near[i][1];
	     if(min>test) {
		min=test;
		choice=i;
	     }
	    }
	}

	    double ind=near[choice][0];
	    double[] IND={choice,ind};
	    return(IND);
    }









    //gets the pair of flanking indices for the line choice



    public double[] lineIndex3(int choice,Complex z) {
	double x=z.x;
	double y=z.y;

	double[] IND=doGrid(choice);
	if(IND==null) return(null);
	double f1=functional(choice,x,y);
	double f2=Math.floor(f1/Q);
	if((2000+f2)%2==1) f2=f2+1;
	int ind=(int)(f2);
	IND=possibleIndices(ind,Q,IND);

	double[] near={-1000,-1000};
	double[] val={-100000,100000};

	for(int i=0;i<IND.length;++i) {
	    double ii=IND[i];
	    if((ii<=f1)&&(ii>val[0])) {
		near[0]=ii;
		val[0]=ii;
	    }
	    if((ii>=f1)&&(ii<val[1])) {
		near[1]=ii;
		val[1]=ii;
	    }
	}

	return(near);
    }






    //used when z is a triple point

    public int[] lineIndex4(Complex z) {
	double[][] d=new double[5][2];
	for(int i=1;i<5;++i) {
	    d[i]=lineIndex1(i,z);
	}

	int[] ind=new int[3];
	int count=0;
	for(int i=1;i<5;++i) {
	    if(d[i][1]<.0000001) {
		ind[count]=i;
                ++count;
	    }
	}
	return(ind);
    }








    public Complex[] getSegment0(int choice,Complex z) {

	double[] ind0=lineIndex1(choice,z);
	if(ind0==null) return(null);
	double ind1=ind0[0];
	double[][] end=new double[5][2];
	for(int i=1;i<5;++i) {
	    if(i!=choice) end[i]=lineIndex3(i,z);
	}

	Complex[][] w=new Complex[5][2];
	for(int i=1;i<5;++i) {
	    if((i!=choice)&&(end[i]!=null))
	        if(SWITCH==0) w[i]=KiteGrid.intersection(choice,ind1,i,end[i],P,Q);
	        if(SWITCH==1) w[i]=Renormalize.intersection(choice,ind1,i,end[i],P,Q);
	    if((i!=choice)&&(end[i]==null)) w[i]=null;
	}




	Complex[] Z=new Complex[3];
	Z[0]=new Complex();
	Z[1]=new Complex();
	Z[2]=new Complex();

	double test0=0;
	double min0=100000;
	double test1=0;
	double min1=100000;

	for(int i=1;i<5;++i) {

	    if((i!=choice)&&(w[i]!=null)) {
		test0=Complex.dist(z,w[i][0]);
		if(test0<min0) {
		    min0=test0;
		    Z[0]=new Complex(w[i][0]);
		    Z[2].x=i;
		}
		test1=Complex.dist(z,w[i][1]);
		if(test1<min1) {
		    min1=test1;
		    Z[1]=new Complex(w[i][1]);
		    Z[2].y=i;
		}
	    }
	}
	return(Z);
    }







    public Complex[] getSegment(Complex z) {
	double[] ind=lineIndex2(z);
	return(getSegment0((int)(ind[0]),z));
    }


    public GeneralPath getSegmentPath(Complex z) {
	Complex[] Z=getSegment(z);
	if(Z==null) return(null);
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(Z[0].x),(float)(Z[0].y));
	gp.lineTo((float)(Z[1].x),(float)(Z[1].y));
	return(gp);
    }


    public Complex[] tripleDynamics(int sign,Complex z0,Complex z1,double tol) {

	double[] ind0=lineIndex2(z0);
	int[] ind1=lineIndex4(z1);
	int[] ind2=new int[3];
	ind2[0]=(int)(ind0[0]);
	int count=1;
	for(int i=0;i<3;++i) {
	    if(ind1[i]!=ind2[0]) {
		ind2[count]=ind1[i];
		++count;
	    }
	}

	double[][] w=new double[5][2];
	for(int k=1;k<=4;++k) {
     	   w[k]=KiteGrid.specialUnit(k,P,Q);
	}
	int kk=0;

	if((ind2[0]==1)&&(ind2[1]==3)&&(ind2[2]==4)) kk=3;
	if((ind2[0]==4)&&(ind2[1]==1)&&(ind2[2]==3)) kk=4;
	if((ind2[0]==3)&&(ind2[1]==1)&&(ind2[2]==4)) kk=1;
	if((ind2[0]==2)&&(ind2[1]==3)&&(ind2[2]==4)) kk=4;
	if((ind2[0]==3)&&(ind2[1]==2)&&(ind2[2]==4)) kk=3;
	if((ind2[0]==4)&&(ind2[1]==2)&&(ind2[2]==3)) kk=2;

	Complex[] Z=new Complex[2];
	if(kk==0) {
	    Z[0]=new Complex(0,0);
	    Z[1]=new Complex(-999,0);
	}


	if(kk!=0) {
	    Z[0]=new Complex(z1.x-sign*tol*w[kk][0],z1.y-sign*tol*w[kk][1]);
	    Z[1]=new Complex(1,0);
	}
	return(Z);
    }




    public Complex goDynamics(int sign1,int sign2,Complex z,double tol) {
	Complex[] Z=getSegment(z);
       	int ind=(int)(Z[2].x);                       //choice of line
	if(sign1==1) ind=(int)(Z[2].y);
       	double[] w2=KiteGrid.specialUnit(ind,P,Q);   //unit vector parallel to line
       	Complex w3=new Complex();
	Complex ZZ=new Complex(Z[1]);
	if(sign1==-1) ZZ=new Complex(Z[0]);
       	w3.x=ZZ.x-sign2*tol*w2[0];                       
       	w3.y=ZZ.y-sign2*tol*w2[1];                       
	return(w3);
    }











    public int sliceNumber(int choice,double index,Complex[] z) {
	int count1=0;
	int count2=0;
	double test;
	for(int i=0;i<z.length;++i) {
	    test=functional(choice,z[i].x,z[i].y);
	    if(Math.abs(test-index)>.000001) {
	       if(test<index) ++count1;
	       if(test>index) ++count2;
	    }
	}
	int count=count1;
	if(count>count2) count=count2;
	return(count);
    }







    public int between(int choice,Complex z,Complex w) {
	Complex zz=Complex.average(z,w);
	double[] ind=lineIndex3(choice,zz);
	Complex[] Z={z,w};
	int count1=sliceNumber(choice,ind[0],Z);
	int count2=sliceNumber(choice,ind[1],Z);
	if(count1==1) return(1);
	if(count2==1) return(1);
	return(0);
    }



    public int cleanDiamond(Complex[] z) {

	Complex w=new Complex();
	w.x=.25*(z[0].x+z[1].x+z[2].x+z[3].x);
	w.y=.25*(z[0].y+z[1].y+z[2].y+z[3].y);
	double[] ind1=lineIndex3(1,w);
	double[] ind2=lineIndex3(2,w);

	int count1=sliceNumber(1,ind1[0],z);
	int count2=sliceNumber(1,ind1[1],z);
	int count3=sliceNumber(2,ind2[0],z);
	int count4=sliceNumber(2,ind2[1],z);

	if(count1*count3>0) return(1);  //cross
	if(count1*count4>0) return(1);  //cross
	if(count2*count3>0) return(1);  //cross
	if(count2*count4>0) return(1);  //cross

	if(count1==1) return(2);
	if(count2==1) return(2);
	if(count3==1) return(2);
	if(count4==1) return(2);
	return(0);
    }





}

  