import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class KiteGrid {
    Manager M;


    public KiteGrid() {}


    public static double fudge1(int choice) {
	if(choice<=2) return(.5);
	    return(0);
    }

    public static GeneralPath thinGrid(int choice,int p,int q,double[] d,int number,int extent,double[] bb) {
      GeneralPath gp=new GeneralPath();
      double[] x=doGrid(choice,p,q,d);	
      GeneralPath gp2=new GeneralPath();
      double X,Y;
      double[] v=specialUnit(choice,p,q);
      v[0]=Math.pow(2.0,extent)*v[0];
      v[1]=Math.pow(2.0,extent)*v[1];

      for(int k=-number;k<number;++k) {
	for(int i=0;i<x.length;++i) { 
	    X=x[i]+2*q*k;
            Y=-1.0*p*X/q;
	    gp2.reset();
	    gp2.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	    gp2.lineTo((float)(X+v[0]),(float)(Y+v[1]));
	    if(gp2.intersects(bb[0],bb[1],bb[2],bb[3])==true) gp.append(gp2,false);
	}
      }
	return(gp);
    }





    public static GeneralPath thickGrid(int choice,int p,int q,double[] d,double width,int number,int extent,double[] bb) {
      GeneralPath gp=new GeneralPath();  
      GeneralPath gp2=new GeneralPath();
      double[] x=doGrid(choice,p,q,d);

      if(x==null) return(gp);
    
      double[] v=specialUnit(choice,p,q);  
      v[0]=Math.pow(2.0,extent)*v[0];
      v[1]=Math.pow(2.0,extent)*v[1];

      double X,Y;  
      double[] y=specialPerp(choice,p,q);
      y[0]=y[0]*width;
      y[1]=y[1]*width;

      for(int k=-number;k<number;++k) {
	for(int i=0;i<x.length;++i) { 
	    X=x[i]+2*q*k;
            Y=-1.0*p*X/q;
	    gp2.reset();
	    gp2.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	    gp2.lineTo((float)(X+v[0]),(float)(Y+v[1]));
	    gp2.lineTo((float)(X+v[0]-y[0]),(float)(Y+v[1]-y[1])); 
            gp2.lineTo((float)(X-v[0]-y[0]),(float)(Y-v[1]-y[1]));
	    gp2.closePath(); 
            if(gp2.intersects(bb[0],bb[1],bb[2],bb[3])==true) gp.append(gp2,false);
	}
      }
      return(gp);
    }




    public static GeneralPath extraGrid(int p,int q,Complex z,int extent) {
      GeneralPath gp=new GeneralPath();
      double X,Y;
      double[] v=specialVector(5,p,q);
      v[0]=Math.pow(2.0,extent)*v[0];
      v[1]=Math.pow(2.0,extent)*v[1];
	X=z.x;
        Y=z.y;
	gp.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	gp.lineTo((float)(X+v[0]),(float)(Y+v[1]));
        v=specialVector(6,p,q);
        v[0]=Math.pow(2.0,extent)*v[0];
        v[1]=Math.pow(2.0,extent)*v[1];
	X=z.x;
        Y=z.y;
	gp.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	gp.lineTo((float)(X+v[0]),(float)(Y+v[1]));
	return(gp);
    }








    //finds intersection point



    public static Complex intersection(int type1,double index1,int type2,double index2,int p,int q) {
	double[] v1=specialVector(type1,p,q);
	double[] v2=specialVector(type2,p,q);
	Complex z=new Complex();
	z.x=index1;
	z.y=-1.0*p*z.x/q;
	double d=GridDynamics.functional(type2,p,q,v1[0],v1[1]);
	d=(index2-index1)/d;
	z.x=z.x+d*v1[0];
	z.y=z.y+d*v1[1];
	return(z);
    }


    public static Complex[] intersection(int type1,double index1,int type2,double[] index2,int p,int q) {

	Complex z0=new Complex();
	Complex z1=new Complex();
	Complex z2=new Complex();
	z0=intersection(type1,index1,type2,index2[0],p,q);
	z1=intersection(type1,index1,type2,index2[1],p,q);
	z2=Complex.minus(z0,z1);
	double[] v1=specialVector(type1,p,q);
	double test=v1[0]*z2.x+v1[1]*z2.y;
	Complex[] Z=new Complex[2];
	Z[0]=new Complex(z0);
	Z[1]=new Complex(z1);
	if(test<0) {
	    Z[0]=new Complex(z1);
	    Z[1]=new Complex(z0);
	}
	return(Z);
    }








    public static double[] doGrid(int k,int p,int q,double[] d) {
	if(k==1) return(pGrid(p,q,d));
	if(k==2) return(pGrid(p,q,d));
	if(k==3) return(qGrid(p,q,d));
	if(k==4) return(qGrid(p,q,d));
	return(null);
    }






    public static void printOut(int[] y) {
	for(int i=0;i<y.length;++i) {
	    System.out.print(y[i]+" ");
	}
	System.out.println("");
    }


    public static double fract(double d) {
	double dd=d-Math.floor(d);
	if(dd>.99999999) dd=dd-1;
	return(dd);
    }

    public static double circleDistance(double d1,double d2) {
	double e=d1-d2;
	if(e<0) e=-e;
	e=e-Math.floor(e);
	if(e>.5) e=e-1;
	e=Math.abs(e);
	return(e);
    }


    public static double[] qGrid(int p,int q,double[] d) {
	int count=0;
	double[] list=new double[2*q];
	for(int k=0;k<2*q;++k) {
	    if(qCheck(p,q,d,k)==1) {
		list[count]=k;
		++count;
	    }
	}
	    double[] list2=new double[count];
	    for(int k=0;k<count;++k) list2[k]=list[k];
	    return(list2);
    }


    public static int qCheck(int p,int q,double[] d,int k) {
	double A=1.0*p/q;
	double B=(1.0-A)/2.0;
	double dist=circleDistance(k*B,0.25+.25*d[1]);
        double BOUNDARYCASE=Math.abs(dist-d[0]/4.0);
	int good=0;
	if(dist<d[0]/4.0+.0000001) good=1;
	if(BOUNDARYCASE>.000001) return(good);
	int odd=(p*q)%2;
	if((odd==1)&&(k==q)) return(0);
	if((odd==0)&&(k==q)) return(1);
	return(0);
    }

    public static double[] pGrid(int p,int q,double[] d) {
	int count=0;
	double[] list=new double[2*q];
	for(int k=0;k<2*q;++k) {
	    double kk=k+.5;
	    if(pCheck(p,q,d,kk)==1) {
		list[count]=kk;
		++count;
	    }
	}
	    double[] list2=new double[count];
	    for(int k=0;k<count;++k) list2[k]=list[k];
	    return(list2);
    }




    public static int pCheck(int p,int q,double[] d,double k) {
	if(Math.abs(k-.5-q)<.0001) return(0);
	double A=1.0*p/q;
	double B=(1.0-A)/2.0;
	double dist=circleDistance(k*B,-0.25+.25*d[1]);
	if(dist<d[0]*A/4.0+.000001) return(1);
	return(0);
    }




    public static double[] specialVector1(int p,int q) {
	double[] d=new double[2];
	d[0]=-1.0*p*(p-q)/(p+q);
	d[1]=-1.0*p*(-p*p+4*p*q+q*q)/(2.0*q*(p+q));
	return(d);
    }

    public static double[] specialVector2(int p,int q) {
	double[] d=new double[2];
	d[0]=1.0*p;
	d[1]=1.0*p*(q-p)/(2.0*q);
	return(d);
    }

    //vertical Q1
    public static double[] specialVector3(int p,int q) {
	double[] d=new double[2];
	d[0]=0;
	d[1]=0.5*(p+q);
	return(d);
    }

    //Q2
    public static double[] specialVector4(int p,int q) {
	double[] d=new double[2];
	d[0]=-2.0*p*q/(p+q);
	d[1]=-(-3.0*p*p+2.0*p*q+q*q)/(2.0*p+2.0*q);
	return(d);
    }


    public static double[] specialVector5(int p,int q) {
	double[] d=new double[2];
	d[0]=q;
	d[1]=-p;
	return(d);
    }

    public static double[] specialVector6(int p,int q) {
	double[] d=new double[2];
	d[0]=(1.0*p*q)/(p+q);
	d[1]=d[0]+(q-p)/2.0;
	return(d);
    }


    public static double[] specialVector(int k,int p,int q) {
	if(k==1) return(specialVector1(p,q));
	if(k==2) return(specialVector2(p,q));
	if(k==3) return(specialVector3(p,q));
	if(k==4) return(specialVector4(p,q));
	if(k==5) return(specialVector5(p,q));
	if(k==6) return(specialVector6(p,q));
	return(null);
    }


    public static double[] specialPerp(int k,int p,int q) {
	double[] x=specialVector(k,p,q);
	double d=Math.sqrt(x[0]*x[0]+x[1]*x[1]);
	double[] y=new double[2];
	if((k<1)||(k>4)) return(null);
	y[0]=-x[1]/d;
	y[1]=x[0]/d;
	return(y);
    }


    public static double[] specialUnit(int k,int p,int q) {
	double[] x=specialVector(k,p,q);
	double d=Math.sqrt(x[0]*x[0]+x[1]*x[1]);
	double[] y=new double[2];
	if((k<1)||(k>4)) return(null);
	y[0]=x[0]/d;
	y[1]=x[1]/d;
	return(y);
    }

}

  