import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.math.*;

public class PenroseRenormalize {
    Manager M;
    double PHI;




    public PenroseRenormalize() {
    }


    public static double getParameter(double L1,double L3,double freq) {
	double PHI=(1+Math.sqrt(5.0))/2;
	double lim1=L1;
	double lim3=L3;
	double lim2=(lim1+lim3)/2.0;
	int test=0;
	double[] d={0,0};
	d[1]=1/(PHI*PHI*PHI);
	double[] gaps=new double[3];
	int count=0;
	while(test==0) {
	    d[0]=lim2;
	    double[] x=KiteGrid.doGrid(1,5473,23184,d);
	    gaps=Renormalize.gapFrequency(x,23184);

	    if(gaps[0]<=freq) lim1=lim2;
	    if(gaps[0]>=freq) lim3=lim2;
            lim2=(lim1+lim3)/2.0;
	    if(lim2-lim1<.00001) test=0;
	    ++count;
	    if(count>100) test=1;
	}
	return(lim2);

    }


    public static double getParameter1(double freq) {
	double PHI=(1+Math.sqrt(5.0))/2;
	double lim1=2.0/(PHI*PHI);
	double lim3=1.0;
	double x=getParameter(lim1,lim3,freq);
	return(x);
    }

    public static double getParameter2(double freq) {
	double PHI=(1+Math.sqrt(5.0))/2;
	double lim1=2.0/(PHI*PHI*PHI);
	double lim3=2.0/(PHI*PHI);
	double x=getParameter(lim1,lim3,freq);
	return(x);
    }

    public static double getParameter3(double freq) {
	double PHI=(1+Math.sqrt(5.0))/2;
	double lim1=2.0/(PHI*PHI*PHI*PHI);
	double lim3=2.0/(PHI*PHI*PHI);
	double x=getParameter(lim1,lim3,freq);
	return(x);
    }


    public static  double[] newParameters(double d,int renorm_choice) {
	double PHI=(1+Math.sqrt(5.0))/2;
	double A=1/(PHI*PHI*PHI);
	double[] XX={d,A};
        double[] x=KiteGrid.doGrid(1,5473,23184,XX);
	double[] g=Renormalize.differenceSequence(x,23184);
	double[] gap=Renormalize.getGapSizes(g);
	double[] newseq=Renormalize.renormSequence(x,23184,gap[renorm_choice]);
	double[] gaps=Renormalize.gapFrequency(newseq,23184);
	double[] par=new double[3];
	par[0]=getParameter1(gaps[0]);
	par[1]=getParameter2(gaps[0]);
	par[2]=getParameter3(gaps[0]);
	return(par);
    }



    public static int[] iteratedRenorm(double d1) {
	int[] n=new int[5];
	double d2=d1;
	for(int i=0;i<5;++i) {
	    n[i]=suggestRenorm(d2);
	    d2=penroseMap(d2);
	}
	return(n);
    }


    public static int suggestRenorm(double d1) {
	double d=fixRange(d1);
	double P=(1+Math.sqrt(5.0))/2;
	if((d>2/(P*P))&&(d<=1)) return(0);
	if((d>1/(P*P))&&(d<=2/(P*P))) return(2);
	if((d>2/(P*P*P*P))&&(d<1/(P*P))) return(0);
	if((d>1/(P*P*P))&&(d<=2/(P*P*P*P))) return(2);
	return(0);
    }

   public static double penroseMap(double x) {
       double y=fixRange(x);	
       double A=Math.sqrt(5)-2;
       int test=4;
       if(y>=1-3*A) test=3;
       if(y>=(1-A)/2) test=2;
       if(y>=1-A) test=1;
       y=g(test,y);
       y=fixRange(y);
       return(y);
   }







    public static double g1(double x) {
	double PHI=(1+ Math.sqrt(5))/2;
      double y=(1+2*PHI)*x - 2*PHI;
      return(y);
    }

    public static double g2(double x) {	
        double PHI=(1+ Math.sqrt(5))/2;
	double y=-x+2/(PHI*PHI);
	return(y);
    }

    public static double g3(double x) {
	return(2+g1(x));
    }

    public static double g4(double x) {
	return(-2-g1(x));
    }

    public static double g(int choice,double x) {
	if(choice==1) return(g1(x));
	if(choice==2) return(g2(x));
	if(choice==3) return(g3(x));
	if(choice==4) return(g4(x));
	return(0);
    }


    public static double fixRange(double x) {
	double A=Math.sqrt(5)-2;
	double a1=Math.log(x)/Math.log(A);
	a1=Math.floor(a1);
        double y=x*Math.pow(A,-a1);
	return(y);
    }







}