import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PolyWedge {
    Complex[] z=new Complex[10];
    int count;

    public PolyWedge() {}

    public PolyWedge(Complex z0,Complex z1,Complex z2) {
    this.count=3;
    this.z[0]=z0;
    this.z[1]=z1;
    this.z[2]=z2;
    }

    public GeneralPath toGeneralPath() {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(z[0].x),(float)(z[0].y));
	for(int i=0;i<count;++i) {
	    gp.lineTo((float)(z[i].x),(float)(z[i].y));
	}
	gp.closePath();
	return(gp);
    }

    public PolyWedge(PolyWedge Q) {
	for(int i=0;i<10;++i) z[i]=new Complex();
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.z[i]=Q.z[i];
    }

    public PolyWedge(Quad Q) {
	for(int i=0;i<4;++i) this.z[i]=new Complex(Q.z[i]);
	this.count=4;
    }




    /**Here we are using a cutoff of 10 for the size.  This seems large
       enough for our immediate purposes**/

    public static PolyWedge  makeWedge(Quad Q0,int i,int parity) {
	Quad Q1=Q0.rotate(i);
	Complex z0=Q0.z[i];
	int i1=0;
	int i2=0;
	if(parity==0) {
	    i1=(i+1)%4;
	    i2=(i+3)%4;

	}
	if(parity==1) {
	    i1=(i+3)%4;
	    i2=(i+1)%4;
	}
	double d=1000.0;
	Complex z1=Complex.minus(Q0.z[i1],z0);
	Complex z2=Complex.minus(Q1.z[i2],z0);
	z1=Complex.plus(z0,new Complex(d*z1.x,d*z1.y));
	z2=Complex.plus(z0,new Complex(d*z2.x,d*z2.y));

	return(new PolyWedge(z0,z1,z2));
    }




    public void print() {
	System.out.println("PolyWedge");
	for(int i=0;i<count;++i) z[i].print();
    }



    Complex getCenter() {
	double x=0;
	double y=0;
	for(int i=0;i<count;++i) {
	    x=x+z[i].x/count;
	    y=y+z[i].y/count;
	}
	return(new Complex(x,y));
    }

    //d=1 is identity and d in (0,1) is shrinking

    public PolyWedge homothety(double d) {
	PolyWedge P=new PolyWedge();
	P.count=count;
	Complex Z=getCenter();
	for(int i=0;i<count;++i) {
	    P.z[i]=new Complex((1-d)*Z.x+d*z[i].x,(1-d)*Z.y+d*z[i].y);
	}
	return(P);
    }



}

