import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Renormalize {
    Manager M;





    public Renormalize(Manager MM) {
	this.M=MM;
    }


    public double[] makeInitialSequence(int choice) {
      double offset1=M.C.SB1.getParameter2(1);
      double offset2=M.C.SB2.getParameter2(0);
      int[] pq=M.C.SES.kiteIntegers();
      int p=pq[0];
      int q=pq[1];
      double[] d={offset1,offset2};
      double[] x=KiteGrid.doGrid(choice,p,q,d);
      return(x);
    }


    public double[] finalSequence(int depth,int choice) {
	 double[] x=makeInitialSequence(choice);  
         int[] pq=M.C.SES.kiteIntegers();
         int p=pq[0];
         int q=pq[1]; 
	 for(int i=0;i<=depth;++i) {
	     int rc=M.C.CON_G.RC.S[i].val;
	     x=basicRenormalize(rc,q,x);
	 }
	 return(x);


    }

    public GeneralPath finalGrid(int depth,int choice) { 
 
         GeneralPath gp=new GeneralPath();
         int number=M.C.CON_G.I[5].val;
         int extent=M.C.CON_G.I[6].val;
         double[] bb=M.G.boundingBox(M); 
         int[] pq=M.C.SES.kiteIntegers();
         int p=pq[0];
         int q=pq[1];


	 /*
	 double[] x=makeInitialSequence(choice);  
         int[] pq=M.C.SES.kiteIntegers();
         int p=pq[0];
         int q=pq[1];

	 for(int i=0;i<=depth;++i) {
	     int rc=M.C.CON_G.RC.S[i].val;
	     x=basicRenormalize(rc,q,x);
	 }
	 */

	double[] x=finalSequence(depth,choice);
        if(x==null) return(gp);
        gp=makeGrid(p,q,choice,number,extent,bb,x);
      return(gp);
    }




    public static GeneralPath makeGrid(int p,int q,int choice, int number,int extent, double[] bb,double[] x) {
        GeneralPath gp=new GeneralPath();
        GeneralPath gp2=new GeneralPath();
        double X,Y;
        double[] v=KiteGrid.specialUnit(choice,p,q);
        v[0]=Math.pow(2.0,extent)*v[0];
        v[1]=Math.pow(2.0,extent)*v[1];

      for(int k=-number;k<number;++k) {
	for(int i=0;i<x.length;++i) { 
	    X=x[i]+2*q*k;
            Y=-1.0*p*X/q;
	    gp2.reset();
	    gp2.moveTo((float)(X-v[0]),(float)(Y-v[1]));
	    gp2.lineTo((float)(X+v[0]),(float)(Y+v[1]));
	    if(gp2.intersects(bb[0],bb[1],bb[2],bb[3])==true) gp.append(gp2,false);
	}
      }
	return(gp);
    }




    public static double[] differenceSequence(double[] aa,int q) {
	double[] a=augment(aa,q);
	double[] b=new double[aa.length];
	for(int i=0;i<a.length-1;++i) b[i]=a[i+1]-a[i];
	return(b);
    }


    public static  double[] newGrid(int choice,int p,int q,double[] d,int renorm_choice) {
        double[] x=KiteGrid.doGrid(choice,p,q,d);
	double[] y=basicRenormalize(renorm_choice,q,x);
	return(y);
    }


    public static double[] basicRenormalize(int choice,int q,double[] x) {
	double[] g=differenceSequence(x,q);
	double[] gap=getGapSizes(g);
	double[] y=renormSequence(x,q,gap[choice]);
	return(y);
    }




    public static double[] augment(double[] a,int q) {

	double[] b=new double[a.length+1];
	for(int i=0;i<a.length;++i) b[i]=a[i];
	b[a.length]=a[0]+2*q;
	return(b);
    }

    public static double[] renormSequence(double[] aa,int q,double gap) {
	double[] a=augment(aa,q);
	double[] b=new double[a.length];
	int count=0;
	for(int i=0;i<a.length-1;++i) {
	    double test=a[i+1]-a[i];
	    if(test==gap) {
		b[count]=a[i]+.5*gap;
		++count;
	    }
	}
	double[] c=new double[count];
	for(int i=0;i<count;++i) c[i]=b[i];
	return(c);
    }





    public static double[] getGapSizes(double[] g) {

	double[] val={-1,-1,-1};
	val[0]=g[0];
	int test=0;
	int i=1;
	while((test==0)&&(i<g.length)) {
	    if(g[i]!=val[0]) { 
                val[1]=g[i];
		test=1;
	    }
	    ++i;
	}

	i=2;
	test=0;
	while((test==0)&&(i<g.length)) {
	    if((g[i]!=val[0])&&(g[i]!=val[1])) {
                val[2]=g[i];
		test=1;
	    }
	    ++i;
	}
	double temp=0;

	//sort
	for(int j=0;j<3;++j) {
	    for(int k=j+1;k<3;++k) {
	      if(val[j]>val[k]) {
	        temp=val[j];
	        val[j]=val[k];
	        val[k]=temp;
	      }
	    }
	}

	//	System.out.println("gaps "+val[0]+" "+val[1]+" "+val[2]);

	return(val);
    }




    /* This works off the basic sequence*/

    public static double[] gapFrequency(double[] x,int q) {
	double[] g=differenceSequence(x,q);
	double[] gap=getGapSizes(g);
	double[] f={0,0,0};
	for(int i=0;i<g.length;++i) {
	    if(Math.abs(g[i]-gap[0])<.1) f[0]=f[0]+1;
	    if(Math.abs(g[i]-gap[1])<.1) f[1]=f[1]+1;
	    if(Math.abs(g[i]-gap[2])<.1) f[2]=f[2]+1;
	}
	double tot=f[0]+f[1]+f[2];
	f[0]=f[0]/tot;
	f[1]=f[1]/tot;
	f[2]=f[2]/tot;
	return(f);

    }







    //finds intersection point

    public static Complex intersection(int type1,double index1,int type2,double index2,int p,int q) {
	double[] v1=KiteGrid.specialVector(type1,p,q);
	double[] v2=KiteGrid.specialVector(type2,p,q);

	Complex z=new Complex();
	z.x=index1;
	z.y=-1.0*p*z.x/q;
	double d=GridDynamics.functional(type2,p,q,v1[0],v1[1]);
	d=(index2-index1)/d;
	z.x=z.x+d*v1[0];
	z.y=z.y+d*v1[1];
	return(z);
    }


    public static Complex[] intersection(int type1,double index1,int type2,double[] index2,int p,int q) {

	Complex z0=new Complex();
	Complex z1=new Complex();
	Complex z2=new Complex();
	z0=intersection(type1,index1,type2,index2[0],p,q);
	z1=intersection(type1,index1,type2,index2[1],p,q);
	z2=Complex.minus(z0,z1);
	double[] v1=KiteGrid.specialVector(type1,p,q);
	double test=v1[0]*z2.x+v1[1]*z2.y;
	Complex[] Z=new Complex[2];
	Z[0]=new Complex(z0);
	Z[1]=new Complex(z1);
	if(test<0) {
	    Z[0]=new Complex(z1);
	    Z[1]=new Complex(z0);
	}
	return(Z);
    }






}