import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntrySystem {
    int X,Y;
    Documentation DOC;
    ShapeEntryBasic SB;
    ShapeEntryQuadratic SQ;
    ShapeEntryBarycenter S;
    ControlPanel OPTION;
    ListenSquare[] L=new ListenSquare[10];

    public ShapeEntrySystem(int x,int y) {
	X=x;
	Y=y;
	SB=new ShapeEntryBasic(x+110,y);
	SB.I[0].val=1;
	SB.I[1].val=3;
	SQ=new ShapeEntryQuadratic(x+110,y);
	S=new ShapeEntryBarycenter(x+85,y+210);
	setOption();
	L[0]=new ListenSquare(x+10,y+80,15,15,Color.red);
	L[0].on=1;
    }


    public void setOption() {
	 Color[] C1={new Color(50,100,250),Color.white,Color.white,Color.black,new Color(50,90,255)};
	 String[] OptionString={"quad","kite-basic","kite-quadratic","option"};
	 int[] OptionState={0,1,0};
         OPTION=new ControlPanel(C1,OptionString,OptionState,3);
	 OPTION.mode=1;

    }


    public void render(Graphics2D g) {
	OPTION.render(g,X,Y,100);
	if(OPTION.mode==0) S.render(g);
	if(OPTION.mode==1) SB.render(g);
	if(OPTION.mode==2) SQ.render(g);
	if(OPTION.mode>=1) L[0].render(g,new Color(255,0,255));

    }

    public Quad getQuad() {
	return(new Quad(getParameter()));
    }

    public int[] getParameter() {
	return(S.getParameter());
    }

    public int[]  getParameterKite() {
	int p=SB.I[0].val;
	int q=SB.I[1].val;
	int a=q-p;
	int b=2*p;	
        if((a%2==0)&&(b%2==0)) {a=a/2;b=b/2;}
	int[] x={a,b,a};
	return(x);
    }


    public void kiteToBarycenter() {
	int p=SB.I[0].val;
	int q=SB.I[1].val;
	if(OPTION.mode==2) {
	   p=SQ.I[10].val;
	   q=SQ.I[11].val;
	}
	int a=q-p;
	int b=2*p;
	if((a%2==0)&&(b%2==0)) {a=a/2;b=b/2;}
	S.I[0].val=b;
	S.I[1].val=a;
	S.I[2].val=a;
    }



    public int[] kiteIntegers() {
	int p=SB.I[0].val;
	int q=SB.I[1].val;
	if(OPTION.mode==2) {
	   p=SQ.I[10].val;
	   q=SQ.I[11].val;
	}
	int[] pq={p,q};
	return(pq);
    }


    public double kiteParameter() {
	int p=SB.I[0].val;
	int q=SB.I[1].val;
	double A=1.0*p/q;
	return(A);
    }




    public Complex getComplex() {
	int[] X=getParameter();
	int a=X[0];
	int b=X[1];
	int c=X[2];
	int n=a+b+c;
	double aa=1.0*a/n;
	double bb=1.0*b/n;
	double cc=1.0*c/n;
	Complex Z=new Complex(bb,aa-cc);
	return(Z);
    }




    public int process(MouseEvent e) {

        MouseData J=MouseData.process(e);
	int option=OPTION.switchMode(J.X);
	if(option==20) return(20);

	if(OPTION.mode==0) {
	  S.processMouse(e);
	}	
        if(OPTION.mode==1) {
	  SB.processMouse(e);
	  if(L[0].inside(J.X)==1) kiteToBarycenter();
	}	
        if(OPTION.mode==2) {
	  SQ.processMouse(e);
	  if(L[0].inside(J.X)==1) kiteToBarycenter();
	}
	return(0);
    }

    public void processKey(KeyEvent e) {
     if(OPTION.mode==0)   S.processKey(e);
     if(OPTION.mode==1)   SB.processKey(e);
     if(OPTION.mode==2)   SQ.processKey(e);

    }









}





