import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class TilingCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Quad[] Q=new Quad[3];
    PolyWedge[] WEDGE=new PolyWedge[2000000];
    Color[] C=new Color[5];
    int count=1;
    Complex source=new Complex(0,0);
    int tile=0;
    Color[] TILECOLOR=new Color[2000000];
    GeneralPath[] T2=new GeneralPath[2000000];



    public TilingCanvas addManager(Manager M) {
	TilingCanvas PP=this;
	PP.M=M;
	return(PP);
    }

     public TilingCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 C[0]=new Color(80,170,255,60);
         C[1]=Color.white;
	 C[2]=new Color(0,0,255,100);
	 Q[0]=new Quad(1,1,1);
	 setScales(200,20);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBackground(g);
      drawInitialQuad(g);
      drawTiles(g);
      drawMarkings(g);
   }


    public void drawMarkings(Graphics2D g) {	
	try{
        if(M.C.CON_T.MARKER.L[2].on==1) drawStrips(g);
	if(M.C.CON_T.MARKER.L[0].on==1) TilingMarkings.drawSquares(g,M);
	if(M.C.CON_T.MARKER.L[1].on==1) TilingMarkings.drawFrame(g,M);
	TilingMarkings.drawCrosshairs(g,M);
	}
	catch(Exception e) {}

    }


    public void drawBackground(Graphics2D g) {
	Color COL=Color.black;
	try{
	    COL=M.C.CON_T.COLORS.L[1].C;
	}
	catch(Exception e) {}
	g.setColor(COL);
	g.fillRect(0,0,getWidth(),getHeight());
    }




    public void drawInitialQuad(Graphics2D g) { 
	GeneralPath gp=Q[0].toGeneralPath();
       	gp=transform(gp);
	Color COL=Color.black;
	try{
	    COL=M.C.CON_T.COLORS.L[2].C;
	}
	catch(Exception e) {}
        g.setColor(COL);
        g.fill(gp);
        g.draw(gp);
  }




    public void drawTiles(Graphics2D g) {
	for(int i=0;i<tile;++i) {
	    GeneralPath X=new GeneralPath(T2[i]);
	    X=transform(X);


	    Color COL=Color.black;
	    try{
	       COL=M.C.CON_T.COLORS.L[0].C;
	    }
	    catch(Exception e) {}


            g.setColor(TILECOLOR[i]);
            g.fill(X); 
            g.setColor(COL);
            g.draw(X); 
	}
    }



    public void nextTile(int len) {
	    PolyWedge X=WEDGE[0];
	    int power=M.C.CON_T.POWER.mode;
	    for(int i=1;i<count-1;++i) {
       	      X=ConvexIntersector.wedgeChop(WEDGE[i],X);
	    }

	    TILECOLOR[tile]=M.C.SC.C;
	    if(X!=null) {
	      T2[tile]=X.toGeneralPath();
	      ++tile;
	    }

	    int lim=len;
	    int lim2=M.C.CON_T.TCC.INT[2].val;
	    lim2=(int)(Math.pow(2,lim2));
	    if(lim>lim2) lim=lim2;

	    for(int i=1;i<=lim;++i) {
	       X=Orbiter.nextPoly(X,Q[0]);
	       if(power==1)   X=Orbiter.nextPoly(X,Q[0]);
	       if(testInside(X)==1) {
                  TILECOLOR[tile]=M.C.SC.C;  
                  T2[tile]=X.toGeneralPath();
                  ++tile;
	       }
	    }
    }


    public void firstReturn() {
	PolyWedge P=new PolyWedge(Q[0]);
	    PolyWedge X=WEDGE[0];
	    int power=M.C.CON_T.POWER.mode;
	    for(int i=1;i<count-1;++i) {
       	      X=ConvexIntersector.wedgeChop(WEDGE[i],X);
	    }

	    if(X!=null) {
              TILECOLOR[tile]=M.C.SC.C;
	      T2[tile]=X.toGeneralPath();
	      ++tile;   
              TILECOLOR[tile]=M.C.SC.C;
	      X=Strips.returnMap(P,X);
              T2[tile]=X.toGeneralPath();
	      ++tile;
	    }
    }


    /* this routine is included as a sanity check, to make sure that the
       return map is the same when computed in 2 ways.  The first way is to
       use the actual outer billiards dynamics.  The second way is to use the
       strip maps from the Pinwheel lemma.*/                                                                                        


    public void firstReturn2() {
	PolyWedge P=new PolyWedge(Q[0]);
	    PolyWedge X=WEDGE[0];
	    int power=M.C.CON_T.POWER.mode;
	    for(int i=1;i<count-1;++i) {
       	      X=ConvexIntersector.wedgeChop(WEDGE[i],X);
	    }

	    if(X!=null) {
              TILECOLOR[tile]=M.C.SC.C;
	      T2[tile]=X.toGeneralPath();
	      ++tile;   
              TILECOLOR[tile]=M.C.SC.C;
	      X=Orbiter.returnMap(X,Q[0]);
              T2[tile]=X.toGeneralPath();
	      ++tile;
	    }
    }







    public int testInside(PolyWedge X) {
	if(X==null) return(0);
	int test1=M.C.CON_T.MARKER.L[1].on;
	if(test1==0) return(1);
	int x=M.C.CON_T.TCC.INT[0].val;
	int y=M.C.CON_T.TCC.INT[1].val;
	x=(int)(Math.pow(2,x));
	y=(int)(Math.pow(2,y));
	Complex z=X.getCenter();
	if(Math.abs(z.x)>x+2) return(0);
	if(Math.abs(z.y)>y+2) return(0);
	return(1);
    }




  public static int getDigit(String W,int q) {
        String S=new String();
        int m=-1;
        int n=W.length();
        int qq=q;
        if(q<0) qq=q+n;
        if(q>=n) qq=q-n;
        S=W.substring(qq,qq+1);  
        if(S.compareTo("0")==0) m=0;
        if(S.compareTo("1")==0) m=1;
        if(S.compareTo("2")==0) m=2;
        if(S.compareTo("3")==0) m=3;
        return(m);
  }





    public void drawStrips(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	PolyWedge Q0=new PolyWedge(Q[0]);	
	Color[] COL=new Color[2];
	for(int i=0;i<4;++i) {
	    COL[0]=M.C.CON_T.MARKER.M[2].C;
	    COL[1]=M.C.CON_T.MARKER.M[2].C;
	    gp=Strips.strip(Q0,i);
	    gp=transform(gp);
	    g.setColor(COL[1]);
	    g.fill(gp);
	    g.setColor(COL[0]);
	    g.draw(gp);
	}
    }





    public void goWord(String W) {
	System.out.println("word length "+W.length());
	int n=W.length();
	count=1;
	int v=-1;
        Q[1]=new Quad(Q[0]);
	for(int i=1;i<=n;++i) {
	    v=getDigit(W,i-1);
	    if(v!=-1) {
		Q[2]=Q[1].rotate(v);
		WEDGE[i-1]=PolyWedge.makeWedge(Q[1],v,0);
		Q[1]=new Quad(Q[2]);
		++count;
	    }
	}
    }



     public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}





    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;
	if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;

        if(mode==1) scaleUp(J.X,-1);
        if(mode==3) scaleUp(J.X,+1);
	if(mode==2) {
            Complex temp=unTransform(J.X);
	    source=temp;
	    source.print();
	    action(J.X);
	}


	repaint();

    }


    public void action(Point X) {  

        int choice=M.C.CON_T.MULTI.mode;
	if(Q[0].inside(source)==0) {
              if(choice==0) goFullOrbit();
              if(choice==1) goOrbit();
	      if(choice==2) goReturn();
	      if(choice==3) goReturn2();
	}
    }




    public void goOrbit() {
	int number=M.C.CON_T.INT[0].val;
	   String W=Orbiter.generateString(M.P.source,M.P.Q[0]);
	   goWord(W);
   	   nextTile(number-1);
    }



    public void goReturn() {
	   String W=Orbiter.generateString(M.P.source,M.P.Q[0]);
	   goWord(W);
	   firstReturn();


    }


    public void goReturn2() {
	   String W=Orbiter.generateString(M.P.source,M.P.Q[0]);
	   goWord(W);
	   firstReturn2();
    }



    public void goFullOrbit() {
	String W=Orbiter.generateString(M.P.source,M.P.Q[0]);
	goWord(W);
	nextTile(W.length());
	repaint();
    }



}
