import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TilingMarkings {
    public TilingMarkings() {
    }

    public static void drawX(Graphics2D g,Manager M,Output OUT) {
	GeneralPath H=new GeneralPath();  
        Color COL=M.C.CON_T.MARKER.M[0].C;
	g.setColor(COL);
	for(int i=-100;i<100;++i) {
	  H.reset();
	  H.moveTo(-1000,1+2*i);
	  H.lineTo(1000,1+2*i);  
          if(M.C.EXPORT.mode==1) OUT.polyWrite(H,Color.white,COL);
	  H=M.P.transform(H);
	  g.draw(H);
	}
    }





    public static void drawFrame(Graphics2D g,Manager M) {
	GeneralPath H=new GeneralPath();

	float dx=(float)(Math.pow(2,M.C.CON_T.TCC.INT[0].val));
	float dy=(float)(Math.pow(2,M.C.CON_T.TCC.INT[1].val));

	float a=(float)(1000.0);

	Color COL=M.C.CON_T.MARKER.M[1].C;
        g.setColor(COL);

	//top
	H.reset();
	H.moveTo(dx+a,dy);
	H.lineTo(dx+a,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,dy);
	H=M.P.transform(H);
	g.fill(H);

	//bottom
	H.reset();
	H.moveTo(dx+a,-dy+2);
	H.lineTo(dx+a,-dy-a+2);
	H.lineTo(-dx-a,dy-a+2);
	H.lineTo(-dx-a,-dy+2);
	H=M.P.transform(H);
	g.fill(H);

	//right
	H.reset();
	H.moveTo(dx,dy+a);
	H.lineTo(dx+a,dy+a);
	H.lineTo(dx+a,-dy-a);
	H.lineTo(dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);

	//left
	H.reset();
	H.moveTo(-dx,dy+a);
	H.lineTo(-dx-a,dy+a);
	H.lineTo(-dx-a,-dy-a);
	H.lineTo(-dx,-dy-a);
	H=M.P.transform(H);
	g.fill(H);


	g.setColor(M.C.CON_T.COLORS.L[0].C);
	H.reset();
	H.moveTo(dx,dy);
	H.lineTo(-dx,dy);
	H.lineTo(-dx,-dy+2);
	H.lineTo(dx,-dy+2);
	H.closePath();
	H=M.P.transform(H);
	g.draw(H);
    }




    public static void drawSquares(Graphics2D g,Manager M) {
	g.setStroke(new BasicStroke((float)(1.5)));
	GeneralPath H0=new GeneralPath();

	H0.moveTo(-1,0);
	H0.lineTo(1,2);
	H0.lineTo(3,0);
	H0.lineTo(1,-2);
	H0.closePath();
	H0.moveTo(1,2);
	H0.lineTo(3,0);
	H0.lineTo(5,2);
	H0.closePath();
	H0.moveTo(1,-2);
	H0.lineTo(3,0);
	H0.lineTo(5,-2);
	H0.closePath();

	double LIM=500;
	GeneralPath H=new GeneralPath();
	Color COL=M.C.CON_T.MARKER.M[0].C;
        g.setColor(COL);
        H=new GeneralPath(H0);
	AffineTransform A1=AffineTransform.getTranslateInstance(4,0);
	for(int i=0;i<=LIM;++i) {
	    GeneralPath H1=M.P.transform(H);
            g.draw(H1);    
            H.transform(A1);
	}
	g.setStroke(new BasicStroke(1));

    }




    public static void drawCrosshairs(Graphics2D g,Manager M) {
	GeneralPath gp=new GeneralPath();
	double offsetY=M.C.SB1.getParameter2(1);	  //y direction
	double offsetX=M.C.SB2.getParameter2(0);	  //x direction
	gp.moveTo(0,(float)(offsetY));
	gp.lineTo(100,(float)(offsetY));
	gp.moveTo(0,(float)(offsetY-2));
	gp.lineTo(100,(float)(offsetY-2));

	Complex Z=M.G.SOURCE;
	int[] pq=M.C.SES.kiteIntegers();
	int p=pq[0];
	int q=pq[1];
	double a=1.0*p/q;


	int xx=(int)(Z.x);
	int yy=(int)(Z.y);
	int test=(xx+yy+10000)%2;	
        offsetX=offsetX+2*a*Z.x+2*Z.y;
	if(test==0) {
	   gp.moveTo((float)(offsetX),0);
           gp.lineTo((float)(offsetX),2);
	}
	if(test==1) {
	   gp.moveTo((float)(offsetX),0);
           gp.lineTo((float)(offsetX),-2);
	}

	offsetX=offsetX+2*a*Z.x+2*Z.y;

	gp=M.P.transform(gp);
        g.setColor(Color.white);
	g.draw(gp);
    }



}
