

/*This file contains the routines which make the
degenerate versions of the edge smash test and the
triple smash test.  These tests are only invoked,
respectively, 3 times and 30 user_times.  */





/*First, a routine which numerically detects a trivial
circular arc.   After using this routine we go back
and check that the arc is really a single point, and
not just a very small arc.  Since there are only 33 cases
(and half that using symmetry) this is not hard to do*/

int degenerate_edge_detector(e)
     edge e;
{
  interval d[8];
  /*********************************/
  d[1]=cx_norm(e.s[1][1]);
  d[2]=cx_norm(e.s[1][2]);
  d[3]=cx_norm(e.s[2][1]);
  d[4]=cx_norm(e.s[2][2]);
  d[5]=plus(d[1],d[3]);
  d[6]=plus(d[2],d[4]);
  if(equal(d[5],ZERO())==1) return(1);
  if(equal(d[6],ZERO())==1) return(1);
  /*********************************/
  if(equal(d[2],ZERO())==1) return(-1);
  if(equal(d[4],ZERO())==1) return(-1);
  d[7]=cx_dist(cx_divide(e.s[1][1],e.s[1][2]),cx_divide(e.s[2][1],e.s[2][2]));
  if(equal(d[7],ZERO())==1) return(1);
  return(-1);
}





/*this routine replaces the arc which joins the barycenters with
another edge which has the same endpoints.  This other edge,
which is chosen fairly randomly, can also be used to compute
the degree in the same way as the original arc. */

edge replace(e)
     edge e;
{
  edge f;
  f.s[1][1]=e.s[1][1];
  f.s[1][2]=e.s[1][2];
  f.s[2][1]=cx_times(z(2,3,1),e.s[2][1]);
  f.s[2][2]=cx_times(z(2,3,1),e.s[2][2]);
  return(f);
}



int degenerate_smash_interior_test(e,G)
     edge e;
     graph G;
{
  int i,n,test,d;
  n=0;
  for(i=1;i<=3;++i) 
    {
      d=degenerate_edge_detector(G.e[i]);
      if(d==-1)
	{
            test=generic_intersection_number(e,G.e[i]); 
            n=n+test;
	}
    }
  return(n%2);
}





/* edge smash case */

int degenerate_edge_smash_test(P1,P2)
     poly P1,P2;
{
  graph G1,G2;
  edge ee;
  int d1,d2,d3,d4;
  int test,i,j;
  G1=edge_smash_graph(P1,P2); 
  G2=edge_smash_graph(P2,P1); 

  for(i=1;i<=3;++i) 
    {
      for(j=1;j<=3;++j)
	{
	  d1=degenerate_edge_detector(G1.e[i]);
          d2=degenerate_edge_detector(G2.e[j]);
	  d3=edge_projection_test(G1.e[i],G2.e[j]);
	  if((d1==-1)&&(d2==-1)&&(d3!=1)) return(-1);
	}
    }

  ee=join_smash_barycenters(G1,G2);
  test=degenerate_smash_interior_test(ee,G1);

  if(test!=1) return(-1);
  test=degenerate_smash_interior_test(ee,G2);
  if(test!=1) return(-1); 
  return(1);
}








/* triple smash case */

int degenerate_choice_triple_smash_test(choice,P1,P2)
     poly P1,P2;
     int choice;
{
  graph G1,G2;
  edge ee;
  int d1,d2,d3,d4;
  int test,i,j;
  G1=triple_smash_graph(1,choice,P1,P2); 
  G2=triple_smash_graph(2,choice,P1,P2); 

  for(i=1;i<=3;++i) 
    {
      for(j=1;j<=3;++j)
	{
	  d1=degenerate_edge_detector(G1.e[i]);
          d2=degenerate_edge_detector(G2.e[j]);
	  d3=special_intersection_number(G1.e[i],G2.e[j]);
	  if((d1==-1)&&(d2==-1))
	    {
	      if((d3==1)||(d4==1)) test=1;
	      if((d3!=1)&&(d4!=1)) return(-1);
	    }
          if((d1!=-1)||(d2!=-1)) test=1;
	}
    }


  ee=replace(join_smash_barycenters(G1,G2));
  test=degenerate_smash_interior_test(ee,G1);

  if(test!=1) return(-1);
  test=degenerate_smash_interior_test(ee,G2);
  if(test!=1) return(-1);
  return(1);
}




int degenerate_triple_smash_test(P1,P2)
     poly P1,P2;
{
  int test;
  test=degenerate_choice_triple_smash_test(1,P1,P2);
  if(test==1) return(1);
  test=degenerate_choice_triple_smash_test(2,P1,P2);
  if(test==1) return(2);
  test=degenerate_choice_triple_smash_test(3,P1,P2);
  if(test==1) return(3);
  return(-1);
}
