


/*******************************************
    This file contains the subroutines which
convert the complex Z to the computex Z'.
********************************************/

/**This merges together two lists of polyhedra*/


// Libraries for malloc, memset functions
#include <stdlib.h>
#include <libc.h>

// Modification : Same as merge but takes two pointers
// Merges Y into X
void inplace_merge(poly_list* X,poly_list*  Y){

    int i;
    for(i=1;i<=Y->l;++i)  X->P[X->l+i]=Y->P[i];
    X->l=X->l+Y->l;

}
/*this is the perturbation data.  See Ch. 8 of the paper*/

interval_complex mu(k)
int k;
{
if(k==1) return(cx_convert(0.23,-0.11));
if(k==2) return(cx_convert(0.3,0.0));
if(k==3) return(cx_convert(0.45,0.0));
if(k==4) return(cx_convert(0.55,0.0));  
if(k==5) return(cx_convert(0.92,0.0));
 return(cx_convert(0.85,0.0)); //when k=6.

}


/*Here R is a polyhedron with possibly more than
  4 vertices.  This routine just selects 4 of them.*/

poly tetra_make(R,a,b,c,d)
poly R;
int a,b,c,d;
{
poly Q;
Q.l=4; 
Q.v[1]=R.v[a];
Q.v[2]=R.v[b];
Q.v[3]=R.v[c];
Q.v[4]=R.v[d];
return(Q);
}

// Creates a Poly List on the Heap
poly_list* create_poly_list(){
    poly_list* res = malloc(sizeof (poly_list)) ;
    memset(res,0,sizeof (poly_list)) ;
    return res;
}
// Creates a Poly struct on the Heap
poly* create_poly() {
    poly* res = malloc(sizeof (poly)) ;
    memset(res,0,sizeof(poly)) ;
    return res;
}

/*This operation subdivides a pyramid-with-square-base
into a union of 4 tetrahedra.  It first subdivides
the square base into 4 triangles, in an X pattern, and
then cones to the apex.  It is part of the conservative
barycentric subdivision defined in Ch. 9 of the paper*/

poly_list* pyramid(R,a,b,c,d,e)
     poly R;
     int a,b,c,d,e;
{
poly_list* X = create_poly_list() ;
poly RR;
int i;
 int cc,dd,ee;
RR=R;
RR.v[0]=average(4,R,b,c,d,e,1,1,1,1);
X->P[1]=tetra_make(RR,0,a,b,e);
X->P[2]=tetra_make(RR,0,a,c,b);
X->P[3]=tetra_make(RR,0,a,d,c);
X->P[4]=tetra_make(RR,0,a,e,d);
X->l=4;
return(X);
}


/*We need to assign perturbation data to each
mixed edge in the complex.  These come in
3 types, modulo the action of PU(2,1).  This
routine identifies the edge type, by
computing a hermitian dot product.  Following
this, the routine assigns the perturbation
data and constructs the vertices.  Here
j is 1,2, or 3, accounting for the three
vertices.*/


interval_vector crook0(v1,v2,j)
interval_vector v1,v2;
int j;
{
interval_complex u1,u2;
interval_complex z[10],a[3],nu1,nu2,one;
interval close;
interval_vector w;
u1=mu(2*j-1);
u2=mu(2*j);
z[3]=cx_convert(-.937506,1.500335);
z[4]=cx_conjugate(z[3]);
z[5]=cx_convert(-1.103127,0.0);
z[6]=cx_conjugate(z[5]);
z[7]=hermitian_dot(v1,v2);
 nu1.x=cx_norm(u1);
 nu1.y=ZERO();
 nu2.x=cx_norm(u2);
 nu2.y=ZERO();
 one=cx_convert(1.0,0.0);
close=cx_dist(z[7],z[3]);
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu1);
  a[2]=u1;
  }
 close=cx_dist(z[7],z[4]); 
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu1);
  a[2]=cx_conjugate(u1);
  }
 close=cx_dist(z[7],z[5]);
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu2);
  a[2]=u2;
  }
 close=cx_dist(z[7],z[6]);  
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu2);
  a[2]=cx_conjugate(u2);
  }
w=vec_plus(vec_scale(a[1],v1),vec_scale(a[2],v2));
 w.X.l=1;
 w.X.a[1]=j;
 w.X.b[1]=v1.X.c[1];
 w.X.c[1]=v2.X.c[1];
return(w);
}



/***This merges two lists of polyhedra*/

poly_list merge(X,Y)
poly_list X,Y;
{
  poly_list Z;
  int i;
  Z=X;
  for(i=1;i<=Y.l;++i)  Z.P[X.l+i]=Y.P[i];
  Z.l=X.l+Y.l; 
  return(Z);
}

void temp(R)
poly_list R;
{
}




/*the type of the polyhedron is the number of
  positive vertices.  There are three stages to
  the perturbation construction, and these are
  indexed by the stage variable*/


poly_list* crook( int type, int stage,poly P)

{
  poly_list* X = create_poly_list();
  poly_list Y;
  int i;
  poly* R = create_poly();

  printf("crook used\n");



  if((type==1)&&(stage==1))
    {
         *R=P;
         R->v[4] =crook0(P.v[1],P.v[4],1);
         R->v[5] =crook0(P.v[2],P.v[4],1);
         R->v[6] =crook0(P.v[3],P.v[4],1);
         R->v[7]=average(6,*R,1,2,3,4,5,6,1,1);
         X->P[1]=tetra_make(*R,7,1,2,3);
         X->P[2]=tetra_make(*R,7,4,5,6);
         X->l=2;
         inplace_merge(X,pyramid(*R,7,1,2,5,4));
         inplace_merge(X,pyramid(*R,7,2,3,6,5));
         inplace_merge(X,pyramid(*R,7,3,1,4,6)); 
         return (X) ;
    }

  if((type==1)&&(stage==2))
    {
      R->v[1] =crook0(P.v[1],P.v[4],1);
      R->v[2] =crook0(P.v[2],P.v[4],1);
      R->v[3] =crook0(P.v[3],P.v[4],1);
      R->v[4] =crook0(P.v[1],P.v[4],2);
      R->v[5] =crook0(P.v[2],P.v[4],2);
      R->v[6] =crook0(P.v[3],P.v[4],2);
      R->v[7]= average(6,*R,1,2,3,4,5,6,1,1);   
      X->P[1]=tetra_make(*R,7,1,2,3);
      X->P[2]=tetra_make(*R,7,4,5,6);
      X->l=2;
      inplace_merge(X,pyramid(*R,7,1,2,5,4));
      inplace_merge(X,pyramid(*R,7,2,3,6,5));
      inplace_merge(X,pyramid(*R,7,3,1,4,6));
      return(X);
    }

  if((type==1)&&(stage==3))
    {
      R->v[1] =crook0(P.v[1],P.v[4],2);
      R->v[2] =crook0(P.v[2],P.v[4],2);
      R->v[3] =crook0(P.v[3],P.v[4],2);
      R->v[4] =crook0(P.v[1],P.v[4],3);
      R->v[5] =crook0(P.v[2],P.v[4],3);
      R->v[6] =crook0(P.v[3],P.v[4],3);
      R->v[7]= average(6,*R,1,2,3,4,5,6,1,1);
      X->P[1]=tetra_make(*R,7,1,2,3);
      X->P[2]=tetra_make(*R,7,4,5,6);
      X->l=2;
      inplace_merge(X,pyramid(*R,7,1,2,5,4));
      inplace_merge(X,pyramid(*R,7,2,3,6,5));
      inplace_merge(X,pyramid(*R,7,3,1,4,6));
      return(X);
    }

  if((type==2)&&(stage==1))
    {
      R->v[1]=P.v[1];
      R->v[2]=P.v[2];
      R->v[3]= crook0(P.v[2],P.v[3],1);
      R->v[4]= crook0(P.v[2],P.v[4],1);  
      R->v[5]= crook0(P.v[1],P.v[4],1);
      R->v[6]= crook0(P.v[1],P.v[3],1);
      R->v[7]= average(6,*R,1,2,3,4,5,6,1,1);
      X->P[1]=tetra_make(*R,7,1,5,6);  
      X->P[2]=tetra_make(*R,7,2,3,4);  
      X->l=2;
      inplace_merge(X,pyramid(*R,7,1,2,4,5));
      inplace_merge(X,pyramid(*R,7,1,2,3,6));
      inplace_merge(X,pyramid(*R,7,3,4,5,6));
      return(X);
    }


  if((type==2)&&(stage==2))
    {
      R->v[1]= crook0(P.v[2],P.v[3],1);
      R->v[2]= crook0(P.v[2],P.v[4],1);  
      R->v[3]= crook0(P.v[1],P.v[4],1);
      R->v[4]= crook0(P.v[1],P.v[3],1);
      R->v[5]= crook0(P.v[2],P.v[3],2);
      R->v[6]= crook0(P.v[2],P.v[4],2);  
      R->v[7]= crook0(P.v[1],P.v[4],2);
      R->v[8]= crook0(P.v[1],P.v[3],2);
      R->v[9]= average(8,*R,1,2,3,4,5,6,7,8);
      X->l=0; 
      inplace_merge(X,pyramid(*R,9,1,2,3,4)); 
      inplace_merge(X,pyramid(*R,9,5,6,7,8));
      inplace_merge(X,pyramid(*R,9,1,2,6,5));
      inplace_merge(X,pyramid(*R,9,2,3,7,6));
      inplace_merge(X,pyramid(*R,9,3,4,8,7));
      inplace_merge(X,pyramid(*R,9,4,1,5,8));
      return(X);
    }

  if((type==2)&&(stage==3))
    {
      R->v[1]= crook0(P.v[2],P.v[3],2);
      R->v[2]= crook0(P.v[2],P.v[4],2);  
      R->v[3]= crook0(P.v[1],P.v[4],2);
      R->v[4]= crook0(P.v[1],P.v[3],2);
      R->v[5]= crook0(P.v[2],P.v[3],3);
      R->v[6]= crook0(P.v[2],P.v[4],3);  
      R->v[7]= crook0(P.v[1],P.v[4],3);
      R->v[8]= crook0(P.v[1],P.v[3],3);
      R->v[9]= average(8,*R,1,2,3,4,5,6,7,8);
      X->l=0; 
      inplace_merge(X,pyramid(*R,9,1,2,3,4)); 
      inplace_merge(X,pyramid(*R,9,5,6,7,8));
      inplace_merge(X,pyramid(*R,9,1,2,6,5));
      inplace_merge(X,pyramid(*R,9,2,3,7,6));
      inplace_merge(X,pyramid(*R,9,3,4,8,7));
      inplace_merge(X,pyramid(*R,9,4,1,5,8));
      return(X);
    }


  if((type==3)&&(stage==1))
    {
      R->v[1]=P.v[1];
      R->v[2] =crook0(P.v[1],P.v[2],1);
      R->v[3] =crook0(P.v[1],P.v[3],1);
      R->v[4] =crook0(P.v[1],P.v[4],1);
      X->P[1]=tetra_make(*R,1,2,3,4);
      X->l=1;
      return(X);
    }


  if((type==3)&&(stage==2))
    {
      R->v[1] =crook0(P.v[1],P.v[2],1);
      R->v[2] =crook0(P.v[1],P.v[3],1);
      R->v[3] =crook0(P.v[1],P.v[4],1);
      R->v[4] =crook0(P.v[1],P.v[2],2);
      R->v[5] =crook0(P.v[1],P.v[3],2);
      R->v[6] =crook0(P.v[1],P.v[4],2);
      R->v[7]= average(6,*R,1,2,3,4,5,6,1,1);
      X->P[1]=tetra_make(*R,7,1,2,3);
      X->P[2]=tetra_make(*R,7,4,5,6);
      X->l=2;
      inplace_merge(X,pyramid(*R,7,1,2,5,4));
      inplace_merge(X,pyramid(*R,7,2,3,6,5));
      inplace_merge(X,pyramid(*R,7,3,1,4,6));
      return(X);
    }


  if((type==3)&&(stage==3))
    {
      R->v[1] =crook0(P.v[1],P.v[2],2);
      R->v[2] =crook0(P.v[1],P.v[3],2);
      R->v[3] =crook0(P.v[1],P.v[4],2);
      R->v[4] =crook0(P.v[1],P.v[2],3);
      R->v[5] =crook0(P.v[1],P.v[3],3);
      R->v[6] =crook0(P.v[1],P.v[4],3);
      R->v[7]= average(6,*R,1,2,3,4,5,6,1,1);
      X->P[1]=tetra_make(*R,7,1,2,3);
      X->P[2]=tetra_make(*R,7,4,5,6);
      X->l=2;
      inplace_merge(X,pyramid(*R,7,1,2,5,4));
      inplace_merge(X,pyramid(*R,7,2,3,6,5));
      inplace_merge(X,pyramid(*R,7,3,1,4,6));
      return(X);
    }

  //the program should never get to this stage

  X->l=1;
  X->P[1]=P;
  return X;

  

}




poly_list CROOK(P)
poly P;
{
int typ;
poly_list Y;
poly_list* CR;
int i;
 typ=type(P);
 Y.l=0;
 CR=crook(typ,1,P);
inplace_merge(&Y,crook(typ,1,P));
inplace_merge(&Y,crook(typ,2,P));
inplace_merge(&Y,crook(typ,3,P));
 return(Y);
}



/*We would have liked to have a single list of
polyhedra.  There are 393 in all. Unfortunately,
this is too much data for the computer.  (There is
a lot of data in an individual tetrahedra, as its
vertices are points in C3, and the coordinates are
all intervals rather than doubles.)  At any rate,
we create 2 shorter lists.  This satisfies the
computer.*/


poly_list  TETRA1()
{
  poly_list X;
  int i;
  X.l=7;
  for(i=1;i<=7;++i) X.P[i]=tetra(0,i);
  for(i=8;i<=11;++i) {
      poly tmp_poly = tetra(0,i) ;
      poly_list tmp_list = CROOK(tmp_poly) ;
      X = merge(X, tmp_list);
  }
  return(X);
}

poly_list  TETRA2()
{
  poly_list X;
  int i;
  X.l=0;
  for(i=12;i<=16;++i)  X=merge(X,CROOK(tetra(0,i))); 
  return(X);
}

poly_list  TETRA(j)
     int j;
{
  poly_list X;
  if(j<=1) X=TETRA1();
  else X=TETRA2();
  return X;
}





