
/*find the barycenter of an edge, triangle of tetrahedron*/

interval_vector barycenter(P)
poly P;
{
int i;
interval_complex d1;
interval_vector v;
v=origin();
if(P.l==2) d1=cx_convert(.5,0.0);
if(P.l==3) d1=cx_convert(1.0/3.0,0.0);
if(P.l==4) d1=cx_convert(.25,0.0);
 if((P.l<2)||(P.l>4)) printf("error in barycenter routine\n");
for(i=1;i<=P.l;++i) v=vec_plus(v,P.v[i]);
v=vec_scale(d1,v);
return(v);
}



/*This is like the barycenter routine, but can
  be used for polyhedra having up to 8 vertices*/


interval_vector average(k,R,a,b,c,d,e,f,g,h)
poly R;
int k,a,b,c,d,f,e,g,h;
{
interval_vector v;
int i;
poly Q;
double k1;
interval_complex k2;
k1=k;k1=1.0/k1;
k2=cx_convert(k1,0.0);
 Q.l=k;
 Q.v[1]=R.v[a];
 Q.v[2]=R.v[b];
 Q.v[3]=R.v[c]; 
 Q.v[4]=R.v[d]; 
 Q.v[5]=R.v[e];
 Q.v[6]=R.v[f];
 Q.v[7]=R.v[g];  
 Q.v[8]=R.v[h];  
 v=origin();  
for(i=1;i<=k;++i)
v=vec_plus(v,Q.v[i]);
v=vec_scale(k2,v); 
/***************/
/*make the code*/
/***************/
 v.X.l=k;
 v.X.a[1]=R.v[a].X.a[1];
 v.X.b[1]=R.v[a].X.b[1];
 v.X.c[1]=R.v[a].X.c[1];
 v.X.a[2]=R.v[b].X.a[1];
 v.X.b[2]=R.v[b].X.b[1];
 v.X.c[2]=R.v[b].X.c[1];
 v.X.a[3]=R.v[c].X.a[1];
 v.X.b[3]=R.v[c].X.b[1];
 v.X.c[3]=R.v[c].X.c[1];
 v.X.a[4]=R.v[d].X.a[1];
 v.X.b[4]=R.v[d].X.b[1];
 v.X.c[4]=R.v[d].X.c[1];
 v.X.a[5]=R.v[e].X.a[1];
 v.X.b[5]=R.v[e].X.b[1];
 v.X.c[5]=R.v[e].X.c[1];
 v.X.a[6]=R.v[f].X.a[1];
 v.X.b[6]=R.v[f].X.b[1];
 v.X.c[6]=R.v[f].X.c[1];
 v.X.a[7]=R.v[g].X.a[1];
 v.X.b[7]=R.v[g].X.b[1];
 v.X.c[7]=R.v[g].X.c[1];
 v.X.a[8]=R.v[h].X.a[1];
 v.X.b[8]=R.v[h].X.b[1];
 v.X.c[8]=R.v[h].X.c[1];
return(v);
}







/**the group action on polyhedra**/


interval_vector vector_positive_shift(v)
     interval_vector v;
{
  interval_vector w;
  interval_matrix m;
  int i;
  m=K();
  w=apply(m,v);
  w.X=v.X;
  for(i=1;i<=w.X.l;++i) {
    ++w.X.c[i];++w.X.c[i];  /*shift code forward by 2*/
    if(w.X.a[i]>0) { ++w.X.b[i];++w.X.b[i];}
  }
  return(w);
}


interval_vector vector_negative_shift(v)
     interval_vector v;
{
  interval_vector w;
  interval_matrix m;
  int i;
  m=K_inverse();
  w=apply(m,v);
  w.X=v.X;
  for(i=1;i<=w.X.l;++i)
 for(i=1;i<=w.X.l;++i) {
   --w.X.c[i];--w.X.c[i];  /*shift code back by 2*/
    if(w.X.a[i]>0) { --w.X.b[i];--w.X.b[i];}
  }
  return(w);
}



poly positive_shift(P)
poly P;
{
poly Q;
int i;
Q.l=P.l;
for(i=1;i<=4;++i)  Q.v[i]=vector_positive_shift(P.v[i]);
return(Q);
}



poly negative_shift(P)
poly P;
{
poly Q;
int i;
Q.l=P.l;
for(i=1;i<=4;++i)  Q.v[i]=vector_negative_shift(P.v[i]);
return(Q);
}





/*matching polyhedra using the code*/

/*This routine tells if two individual codes match.
The codes match provided that their triples are
just permutations of each other*/

int code_equal(v1,v2)
     interval_vector v1,v2;
{
  code c1,c2;
  int i,j,test,count;
  c1=v1.X;
  c2=v2.X;
  if(c1.l!=c2.l) return(0);

  for(i=1;i<=c1.l;++i) 
    {
      count=0;
      for(j=1;j<=c2.l;++j)
	{
	  test=0;
	  if(c1.a[i]==c2.a[j]) ++test;
          if(c1.b[i]==c2.b[j]) ++test;
          if(c1.c[i]==c2.c[j]) ++test;
	  if(test==3) count=1;
	}
      if(count==0) return(0);
    }
  return(1);
}








/*This routine computes the number of vertices common
  to two tetrahedra -- i.e. P#Q.  */

int code_match(P,Q)
poly P,Q;
{
int i,j,test,count;
count=0;
for(i=1;i<=4;++i)
  {
  for(j=1;j<=4;++j)
    {
    test=code_equal(P.v[i],Q.v[j]);
    if(test==1)
      {
       ++count;
      }
    }
  }
return(count);
}
 




/*This routine lists out the vertices common to
  P and Q*/

integer_list code_common_vertices(P,Q)
     poly P,Q;
{
  integer_list l;
  int i,j,test,count;
  count=0;
  for(i=1;i<=4;++i)
  {
  for(j=1;j<=4;++j)
    {
    test=code_equal(P.v[i],Q.v[j]);
    if(test==1)
      {
       ++count;
       l.n[count]=i;
      }
    }
  }
  l.l=count; 
 return(l);
}





/*This routine lists out the vertices common to P and
Q in two ways:  As they are ordered in P and as they
are ordered in Q.  This routine is only used when P#Q=3.*/


integer_list code_special_common_vertices(P,Q)
     poly P,Q;
{
  integer_list l;
  int i,j,test,count;
  count=0;
  for(i=1;i<=4;++i)
  {
  for(j=1;j<=4;++j)
    {
    test=code_equal(P.v[i],Q.v[j]);
    if(test==1)
      {
       ++count;
       l.n[count]=i;
       l.n[count+3]=j;
      }
    }
  }
  l.l=2*count; 
 return(l);
}





/*these routines do the same thing as the code
matching routines, except that they do it 
numerically.  We do not use these routines in
our computations, except to test that they
give the same answers as the code matching routines.*/


int numerical_match(P,Q)
poly P,Q;
{
int i,j,test,count;
count=0;
for(i=1;i<=4;++i)
  {
  for(j=1;j<=4;++j)
    {
    test=vec_equal(P.v[i],Q.v[j]);
    if(test==1)
      {
       ++count;
      }
    }
  }
return(count);
}
 
  

integer_list numerical_common_vertices(P,Q)
     poly P,Q;
{
  integer_list l;
  int i,j,test,count;
  count=0;
  for(i=1;i<=4;++i)
  {
  for(j=1;j<=4;++j)
    {
    test=vec_equal(P.v[i],Q.v[j]);
    if(test==1)
      {
       ++count;
       l.n[count]=i;
      }
    }
  }
  l.l=count; 
 return(l);
}
  







/*the type of the polyhedron is the number of
  positive vertices.   This routine computes the type*/


int type(P)
     poly P;
{
  int i,count;
  interval_complex z;
  count=0;
  for(i=1;i<=4;++i)
    {
    z=hermitian_dot(P.v[i],P.v[i]);
    if(z.x.l>0) ++count;
    }
  return(count);
}


/*returns the list of negative vertices.*/

integer_list negative_vertices(P)
     poly P;
{
  int i,count;
  integer_list l;
  interval_complex z;
  count=0;
  for(i=1;i<=4;++i)
    {
    z=hermitian_dot(P.v[i],P.v[i]);
    if(z.x.l<0) 
      {
       ++count;
       l.n[count]=i;
      }
    }
  l.l=count;
  return(l);
}

/*returns the list of positive vertices.*/

integer_list positive_vertices(P)
     poly P;
{
  int i,count;
  integer_list l;
  interval_complex z;
  count=0;
  for(i=1;i<=4;++i)
    {
    z=hermitian_dot(P.v[i],P.v[i]);
    if(z.x.l>0) 
      {
       ++count;
       l.n[count]=i;
      }
    }
  l.l=count;
  return(l);
}
