


/*P1 and P2 are kept in the same order
  when both graphs are constructed during
  the test.  See the line labelled with an
  X in the routine below.  This routine 
  really does the same thing as the edge_smash_graph
  routine.

  order is between 1 and 2
  choice is 1,2,3 and determines the edge*/



graph triple_smash_graph(order,choice,P1,P2)
     poly P1,P2;
     int order, choice;
{
  int a,b,c,d,count;
  integer_list l;
  graph G;
  edge ee;
  interval_vector v0,v1,v2,v3,v4,v5;
  l=code_special_common_vertices(P1,P2); 
  if(choice==1)
    {
    a=l.n[3*order-2];
    b=l.n[3*order-1];
    }
  if(choice==2)
    {
    a=l.n[3*order-1];
    b=l.n[3*order-0];
    }
  if(choice==3)
    {
    a=l.n[3*order-0];
    b=l.n[3*order-2];
    }
  if(a*b==2)  {c=3;d=4;}
  if(a*b==3)  {c=2;d=4;}
  if(a*b==4)  {c=2;d=3;} 
  if(a*b==6)  {c=1;d=4;}
  if(a*b==8)  {c=1;d=3;}
  if(a*b==12) {c=1;d=2;}

  if(order==1)
    {
    v0=vec_minus(P1.v[a],P1.v[b]);
    v1=hermitian_cross(v0,P1.v[b]);
    v2=hermitian_cross(v0,P1.v[c]);
    v3=hermitian_cross(v0,P1.v[d]);
    }

  if(order==2)
    {
    v0=vec_minus(P2.v[a],P2.v[b]);
    v1=hermitian_cross(v0,P2.v[b]);
    v2=hermitian_cross(v0,P2.v[c]);
    v3=hermitian_cross(v0,P2.v[d]);
    }



  G.e[1]=create_edge(1,v1,v2);
  G.e[2]=create_edge(1,v2,v3);
  G.e[3]=create_edge(1,v3,v1);

 if(order==1)
  v4=vec_plus(vec_plus(P1.v[b],P1.v[c]),P1.v[d]);

 if(order==2)
  v4=vec_plus(vec_plus(P2.v[b],P2.v[c]),P2.v[d]);


  v5=hermitian_cross(v0,v4);
  G.e[4]=create_edge(1,v5,v5);
  G.l=3;
  return(G);
}





int choice_triple_smash_test(choice,P1,P2)
     poly P1,P2;
     int choice;
{
  graph G1,G2;
  edge ee;
  int test,i,j;
  /*X*/
  G1=triple_smash_graph(1,choice,P1,P2); 
  G2=triple_smash_graph(2,choice,P1,P2); 

  for(i=1;i<=3;++i) 
    {
      for(j=3;j<=3;++j)
	{
	  test=edge_projection_test(G1.e[i],G2.e[j]);
          if((test!=1)&&(test!=4)) return(-1);
	}
    }
  ee=join_smash_barycenters(G1,G2);
  test=smash_interior_test(ee,G1);
  if(test!=1) return(-1);
  test=smash_interior_test(ee,G2);
  if(test!=1) return(-1);
  return(1);
}


int triple_smash_test(P1,P2)
     poly P1,P2;
{
  int test;
  test=choice_triple_smash_test(1,P1,P2);
  if(test==1) return(1);
  test=choice_triple_smash_test(2,P1,P2);
  if(test==1) return(2);
  test=choice_triple_smash_test(3,P1,P2);
  if(test==1) return(3);
  return(-1);
}


