

/*convert an edge to a vector*/

interval_vector edge_to_vector(e)
     edge e;
{
  interval_vector v;
  v.a=cx_divide(e.s[1][1],e.s[1][2]);
  v.b=cx_divide(cx_plus(e.s[1][1],e.s[2][1]),cx_plus(e.s[1][2],e.s[2][2]));
  v.c=cx_divide(e.s[2][1],e.s[2][2]);
  return(v);
}

/*convert a vector to an edge*/

edge vector_to_edge(v)
     interval_vector v;
{
  edge e;
  interval_complex w;
  w=cx_divide(cx_minus(v.b,v.a),cx_minus(v.c,v.b));
  e.s[1][1]=v.a;
  e.s[1][2]=cx_convert(1.0,0.0);
  e.s[2][1]=cx_times(w,v.c);
  e.s[2][2]=w;
  return(e);
}


/*normalize so that one of the edges projectivizes
  to the positive real line.  See Ch. 10 in the paper.
  The other edge is called e3, and is the one that is
  returned by the program*/

edge normal_position(e1,e2)
     edge e1,e2;
{
  edge e3;
  int i,j;
  e3.s[1][1]=cx_minus(cx_times(e1.s[2][2],e2.s[1][1]),cx_times(e1.s[2][1],e2.s[1][2]));
  e3.s[1][2]=cx_minus(cx_times(e1.s[1][1],e2.s[1][2]),cx_times(e1.s[1][2],e2.s[1][1]));
  e3.s[2][1]=cx_minus(cx_times(e1.s[2][2],e2.s[2][1]),cx_times(e1.s[2][1],e2.s[2][2]));
  e3.s[2][2]=cx_minus(cx_times(e1.s[1][1],e2.s[2][2]),cx_times(e1.s[1][2],e2.s[2][1]));
  return(e3);
}





/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  The arcs are
not supposed to have any endpoints in common.
If they do, the computer returns a -1, signifying
a general failure of the test. The intersections
are found using the quadratic formula.  Special
cases somewhat complicate the otherwise
straightforward routine.*/







interval evaluate(a,b,c,t)
     interval a,b,c,t;
{
  interval y;
  y=c;
  y=plus(y, user_times(b, t));
  y=plus(y, user_times(a, user_times(t, t)));
  return(y);
}



int alternate_generic_intersection_number(e)
     edge e;
{
  /*this test computes the midpoint of the
line segment joining the endpoints of the
arc represented by e and then tries to show
that this arc lies in the circle centered
at this midpoint and containing the two endpoints.
We just need to show that another point on the
arc is closer to this midpoint. Once we know this,
then we check that the entire circle is disjoint
from the positive real axis by showing that the
x coordinate of the center is more negative
than the radius is positive.*/

  interval_complex x1,x2,x3,y;
  interval n1,n2;
  int i,j;
  x1=cx_divide(e.s[1][1],e.s[1][2]);
  x2=cx_divide(e.s[2][1],e.s[2][2]);
  x3=cx_divide(cx_plus(e.s[1][1],e.s[2][1]),cx_plus(e.s[1][2],e.s[2][2]));
  /*take average*/
  y=cx_plus(x1,x2);
  y.x.l=.5*y.x.l;
  y.x.r=.5*y.x.r;
  y.y.l=.5*y.y.l;
  y.y.r=.5*y.y.r;

  n1=cx_norm(cx_minus(x1,y));
  n2=cx_norm(cx_minus(x3,y));

  if(n2.r>n1.l) return(-1);
  if(n1.r<-y.x.r) return(0);
  return(-1);
}








int generic_intersection_number(e1,e2)
     edge e1,e2;
{
  edge e;
  int n;
  interval_complex ca,cb,cc,R;
  interval a0,b0,c0,a1,b1,c1,a2,b2;
  interval t1,t2,v1,v2,v3,v4;
  e=normal_position(e1,e2); 


/*******************************************/
  /*if there are common endpoints we fail the
    computation*/

  if(equal(cx_norm(e.s[1][1]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[1][2]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[2][1]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[2][2]),ZERO())==1) return(-1);
/*******************************************/


/*******************************************/
  /*find coefficients of the two quadratic polynomials
    a0_t^2+b0_t+c0* and a_1t^2+b_1t+c_1*/

  ca=cx_times(e.s[1][1],cx_conjugate(e.s[1][2]));
  cb=cx_plus(cx_times(e.s[1][1],cx_conjugate(e.s[2][2])),
             cx_times(e.s[2][1],cx_conjugate(e.s[1][2])));
  cc=cx_times(e.s[2][1],cx_conjugate(e.s[2][2]));
  a0=ca.y;
  b0=cb.y;
  c0=cc.y; 
  a1=ca.x;
  b1=cb.x;
  c1=cc.x;  

  /*if just a0=0 we interchange a0 with c0 and a1 with c1,
    as described in Ch10 of the paper*/

  if(equal(a0,ZERO())==1) {
  c0=ca.y;
  b0=cb.y;
  a0=cc.y; 
  c1=ca.x;
  b1=cb.x;
  a1=cc.x;  
  }



  if((equal(a0,ZERO())==1)) return(alternate_generic_intersection_number(e));
  /*now we know that a0 is nonzero*/
  /****************************************************/




  /****************************************************/
  /*case 1:  In some cases we can guarantee easily that
    there are no real roots*/

  /*no real roots if the discriminant is negative*/
  v1= user_times(b0, b0);
  v2= user_times(plus(c0, c0), plus(a0, a0));
  v3=minus(v1,v2);
  if(v3.r<0) return(0);

  /*If c/a and b/a are both positive then there are
    no real roots.*/
  v1=divide(c0,a0);
  v2=divide(b0,a0);
  if((v1.l>0)&&(v2.l>0)) return(0);
 /****************************************************/


 /****************************************************/
  /*compute the auxilliary quantities a2 and b2*/
  if(a0.l>0) {
  a2=minus(user_times(a0, b1), user_times(b0, a1));
  b2=minus(user_times(a0, c1), user_times(c0, a1));
  }

  if(a0.r<0) {
  a2=minus(user_times(a1, b0), user_times(b1, a0));
  b2=minus(user_times(a1, c0), user_times(c1, a0));
  }
  /****************************************************/


  /****************************************************/
  /*case 2: the inequalities are incompatible, so no roots*/
  if((a2.r<0)&&(b2.r<0)) return(0);
  /****************************************************/

  /****************************************************/
  /*case 3: the second inequality is redundant.  Then we
    just have to compute the number of positive roots of
    P(t)=a_0t^2+b_0t+c_0=0*/

  if((a2.l>0)&&(b2.l>0)) 
    {
    if((c0.r<0)&&(a0.r>0)) return(1);
    if((c0.r>0)&&(a0.r<0)) return(1);
  /*now we know that P(0) and P(infinity) have the same sign.
    So we compute the critical point t1=-b0/2a0.*/
    t1=minus(ZERO(),divide(b0,plus(a0,a0)));
    if(t1.r<0) return(0);  /*critical point negative*/
    /*now we know that the critical point is positive,
      so we compute the critical value*/
    v1=evaluate(a0,b0,c0,t1);
    if(equal(v1,ZERO())==1) return(-1); /*fail boundary case*/
    if((c0.r<0)&&(v1.r<0)) return(0);
    if((c0.l>0)&&(v1.l>0)) return(0);
    if((c0.r<0)&&(v1.l>0)) return(2);
    if((c0.l>0)&&(v1.r<0)) return(2);
    return(-1); /*fail any other cases*/
    }
   /****************************************************/


   /****************************************************/
  /*case 4: the first inequality is redundant.  Then we
    just have to compute the number of roots of P(t) where
    t is in the ray [-b_2/a_2, infinity) */

    if((a2.l>0)&&(b2.r<0)) 
      {
	t1=minus(ZERO(),divide(b2,a2));
	v1=evaluate(a0,b0,c0,t1);
	if(equal(v1,ZERO())==1) return(-1); /*fail boundary case*/
	if((v1.r<0)&&(a0.l>0)) return(1);
	if((v1.l>0)&&(a0.r<0)) return(1);
        /*now we know that P(t1) and P(infinity) have the same sign.
	  So we compute the critical point t2=-b0/2a0.*/
         t2=minus(ZERO(),divide(b0,plus(a0,a0)));
         if(t2.r<t1.l) return(0);  /*critical pt less than endpoint*/
        /*now we know that the critical point lies in the
	  ray, so we compute the critical value*/
         v2=evaluate(a0,b0,c0,t2);
         if(equal(v2,ZERO())==1) return(-1); /*fail boundary case*/
         if((a0.r<0)&&(v2.r<0)) return(0);
         if((a0.l>0)&&(v2.l>0)) return(0);
         if((a0.r<0)&&(v2.l>0)) return(2);
         if((a0.l>0)&&(v2.r<0)) return(2);
	 return(-1); /*fail any other cases*/
      }
    /****************************************************/



    /****************************************************/
    /*case 5: the two inequalities carve out an interval.
      The interval is [0,t1] where t1=-b2/a2*/

     if((a2.r<0)&&(b2.l>0)) 
       {
       t1=minus(ZERO(),divide(b2,a2));
       v1=evaluate(a0,b0,c0,t1);
       if(equal(v1,ZERO())==1) return(-1); /*fail boundary case*/
       if((v1.r<0)&&(c0.l>0)) return(1);
       if((v1.l>0)&&(c0.r<0)) return(1);
       /*now we know that P(0) and P(t1) have the same sign.
	 So we compute the critical point t2=-b0/2a0.*/
       t2=minus(ZERO(),divide(b0,plus(a0,a0)));
       if(t2.r<0) return(0);  /*critical pt negative*/
       if(t2.l>t1.r) return(0);  /*critical pt greater than endpt*/
       /*now we know that the critical point lies in the
       ray, so we compute the critical value*/
       v2=evaluate(a0,b0,c0,t2);
       if(equal(v2,ZERO())==1) return(-1); /*fail boundary case*/
         if((c0.r<0)&&(v2.r<0)) return(0);
         if((c0.l>0)&&(v2.l>0)) return(0);
         if((c0.r<0)&&(v2.l>0)) return(2);
         if((c0.l>0)&&(v2.r<0)) return(2);
	 return(-1); /*fail any other cases*/
       }
     /****************************************************/

     return(-1); /* fail any remaining cases*/
}




/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  In this case
the arcs share an endpoint in common.  Special
cases somewhat complicate the otherwise
straightforward routine.*/

int special_intersection_number(e1,e2)
     edge e1,e2;
{
  edge e;
  int n;
  interval_vector v;
  interval_complex ca,cb,cc;
  interval a,b,c;
  interval t1,v1;
  e=normal_position(e1,e2); 

  /*******************************************/
  /*find polynomial coefficients*/
  /*******************************************/
  ca=cx_times(e.s[1][1],cx_conjugate(e.s[1][2]));
  cb=cx_plus(cx_times(e.s[1][1],cx_conjugate(e.s[2][2])),
             cx_times(e.s[2][1],cx_conjugate(e.s[1][2])));
  cc=cx_times(e.s[2][1],cx_conjugate(e.s[2][2]));
  a=ca.y;
  b=cb.y;
  c=cc.y;
  /************************************************/
  /*degenerate case: all coefficients disappear*/
  /************************************************/
  if((equal(a,ZERO())==1)&&(equal(b,ZERO())==1)&&(equal(c,ZERO())==1))
    {
    a=ca.x;
    b=cb.x;
    c=cc.x; 
    if(equal(c,ZERO())==1) 
      {
        if((a.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    if(equal(a,ZERO())==1) 
      { 
        if((c.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    }
  /************************************************/
  /**************not all coefficients disappear**************/ 
  /************************************************/
  a=ca.y;
  b=cb.y;
  c=cc.y; 
  /*degenerate case: the the edge e projectivizes to an infinite ray*/
  if((equal(a,ZERO())==1) && (equal(b,ZERO())==1) &&(equal(c,ZERO())!=1))
     return(1);
  if((equal(c,ZERO())==1) && (equal(b,ZERO())==1) &&(equal(a,ZERO())!=1))
     return(1);

  /*typical cases: solve linear equation*/
  if(equal(c,ZERO())==1)  {t1=divide(b,a); t1=minus(ZERO(),t1);}
  if(equal(a,ZERO())==1)  {t1=divide(c,b); t1=minus(ZERO(),t1);}
  if(equal(t1,ZERO())==1) return(-1);
  if(t1.r<0) return(1);



  /*******************************/
  /*at this point t1 is positive*/
  /*******************************/
  a=ca.x;
  b=cb.x;
  c=cc.x; 
  if(equal(c,ZERO())==1) v1=plus(user_times(a, t1), b);
  if(equal(a,ZERO())==1) v1=plus(user_times(b, t1), c);
  if(equal(v1,ZERO())==1) return(-1);
  if(v1.l>0) return(2);
  return(1);
}



/* 1 indicates success -- that is, the arcs are disjoint
   excep[t if they share an endpoint. */

int edge_projection_test(e1,e2) 
     edge e1,e2;
{
  edge e;
  edge e3;
  int i,n[5],test;
  e=normal_position(e1,e2);
  n[1]=0;
  n[2]=0;
  n[3]=0;
  n[4]=0;
  if((equal(cx_norm(e.s[1][1]),ZERO())==1)) n[1]=1;
  if((equal(cx_norm(e.s[1][2]),ZERO())==1)) n[2]=1;
  if((equal(cx_norm(e.s[2][1]),ZERO())==1)) n[3]=1;
  if((equal(cx_norm(e.s[2][2]),ZERO())==1)) n[4]=1;

  if((n[1]==1)&&(n[2]==1)) return(-1);
  if((n[3]==1)&&(n[4]==1)) return(-1);
  if((n[1]==1)&&(n[4]==1)) return(4); /*both endpoints agree*/
  if((n[2]==1)&&(n[3]==1)) return(4); /*both endpoints agree*/

  if(n[1]+n[2]+n[3]+n[4]>0)
    {
    test=special_intersection_number(e1,e2);
    if(test==1) return(1);
    return(-1);
    }
  test=generic_intersection_number(e1,e2);
  if(test==0) return(1);
  return(-1);
}

