

/*convert an edge to a vector*/

interval_vector edge_to_vector(e)
     edge e;
{
  interval_vector v;
  v.a=cx_divide(e.s[1][1],e.s[1][2]);
  v.b=cx_divide(cx_plus(e.s[1][1],e.s[2][1]),cx_plus(e.s[1][2],e.s[2][2]));
  v.c=cx_divide(e.s[2][1],e.s[2][2]);
  return(v);
}

/*convert a vector to an edge*/

edge vector_to_edge(v)
     interval_vector v;
{
  edge e;
  interval_complex w;
  w=cx_divide(cx_minus(v.b,v.a),cx_minus(v.c,v.b));
  e.s[1][1]=v.a;
  e.s[1][2]=cx_convert(1.0,0.0);
  e.s[2][1]=cx_times(w,v.c);
  e.s[2][2]=w;
  return(e);
}


/*normalize to that one of the edges projectivizes
  to the positive real line.  See Ch. 10 in the paper.*/

edge normal_position(e1,e2)
     edge e1,e2;
{
  edge e3;
  int i,j;
  e3.s[1][1]=cx_minus(cx_times(e1.s[2][2],e2.s[1][1]),cx_times(e1.s[2][1],e2.s[1][2]));
  e3.s[1][2]=cx_minus(cx_times(e1.s[1][1],e2.s[1][2]),cx_times(e1.s[1][2],e2.s[1][1]));
  e3.s[2][1]=cx_minus(cx_times(e1.s[2][2],e2.s[2][1]),cx_times(e1.s[2][1],e2.s[2][2]));
  e3.s[2][2]=cx_minus(cx_times(e1.s[1][1],e2.s[2][2]),cx_times(e1.s[1][2],e2.s[2][1]));
  return(e3);
}





/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  The arcs are
not supposed to have any endpoints in common.
If they do, the computer returns a -1, signifying
a general failure of the test. The intersections
are found using the quadratic formula.  Special
cases somewhat complicate the otherwise
straightforward routine.*/


int generic_intersection_number(e1,e2)
     edge e1,e2;
{
  edge e;
  int n;
  interval_complex ca,cb,cc;
  interval a,b,c,d,four;
  interval t1,t2,v1,v2;
  four=double_to_interval(4.0);
  e=normal_position(e1,e2); 
  /***********************/
  /*common endpoints fail*/
  /***********************/
  if(equal(cx_norm(e.s[1][1]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[1][2]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[2][1]),ZERO())==1) return(-1);
  if(equal(cx_norm(e.s[2][2]),ZERO())==1) return(-1);
  /*******************************************/
  /*find coefficients of quadratic polynomial: at^2+bt+c*/
  /*******************************************/
  ca=cx_times(e.s[1][1],cx_conjugate(e.s[1][2]));
  cb=cx_plus(cx_times(e.s[1][1],cx_conjugate(e.s[2][2])),
             cx_times(e.s[2][1],cx_conjugate(e.s[1][2])));
  cc=cx_times(e.s[2][1],cx_conjugate(e.s[2][2]));
  a=ca.y;
  b=cb.y;
  c=cc.y; 
  /********************************/
  /*degenerate case*/
  /*********************************/
  if(equal(a,ZERO())==1) 
    {
      cc=cx_divide(e.s[1][1],e.s[1][2]);  /*first root*/
      if(cc.x.r>= 0) return(-1);          /*positive fails*/
      t1=divide(c,b); t1=minus(ZERO(),t1);
      if(t1.r<0) return(0);
      b=cb.x;
      c=cc.x; 
      v1=plus(times(b,t1),c);
      if(v1.l>0) return(1);
      if(v1.r<0) return(0);
      return(-1);
    }
  /************************************/
  /*find roots using quadratic formula*/
  /***************************************/ 
  d=minus(times(b,b),times(four,times(a,c)));     /*discriminant*/
  if(d.r<0) return(0);      /*no real roots*/
  d=sq_root(d);    
  a=plus(a,a);                              
  t1=divide(plus(b,d),a); t1=minus(ZERO(),t1); 
  t2=divide(minus(d,b),a); 
  /*********************************************/
  /*evaluate the other polynomial on the roots*/   
  /*********************************************/
  a=ca.x;
  b=cb.x;
  c=cc.x;
  v1=plus(plus(times(times(a,t1),t1),times(b,t1)),c);
  v2=plus(plus(times(times(a,t2),t2),times(b,t2)),c);
  /***************************/
  /*all boundary cases fail*/
  /***************************/
  if((equal(t1,ZERO())==1)&&(equal(v1,ZERO())==1)) return(-1);
  if((equal(t2,ZERO())==1)&&(equal(v2,ZERO())==1)) return(-1);
  if((v1.l>0)&&(equal(t1,ZERO())==1)) return(-1);
  if((v2.l>0)&&(equal(t2,ZERO())==1)) return(-1);
  if((t1.l>0)&&(equal(v1,ZERO())==1)) return(-1);
  if((t2.l>0)&&(equal(v2,ZERO())==1)) return(-1);
  if((equal(t1,t2)==1)&&(t1.l>0)) return(-1);
  /************************************/
  /*generic case: count the solutions*/
  /************************************/
  n=0;
  if((t1.l>0)&&(v1.l>0)) ++n;
  if((t2.l>0)&&(v2.l>0)) ++n;
  return(n);
}



/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  In this case
the arcs share an endpoint in common.  Special
cases somewhat complicate the otherwise
straightforward routine.*/

int special_intersection_number(e1,e2)
     edge e1,e2;
{
  edge e;
  int n;
  interval_vector v;
  interval_complex ca,cb,cc;
  interval a,b,c;
  interval t1,v1;
  e=normal_position(e1,e2); 

  /*******************************************/
  /*find polynomial coefficients*/
  /*******************************************/
  ca=cx_times(e.s[1][1],cx_conjugate(e.s[1][2]));
  cb=cx_plus(cx_times(e.s[1][1],cx_conjugate(e.s[2][2])),
             cx_times(e.s[2][1],cx_conjugate(e.s[1][2])));
  cc=cx_times(e.s[2][1],cx_conjugate(e.s[2][2]));
  a=ca.y;
  b=cb.y;
  c=cc.y;
  /************************************************/
  /*degenerate case: all coefficients disappear*/
  /************************************************/
  if((equal(a,ZERO())==1)&&(equal(b,ZERO())==1)&&(equal(c,ZERO())==1))
    {
    a=ca.x;
    b=cb.x;
    c=cc.x; 
    if(equal(c,ZERO())==1) 
      {
        if((a.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    if(equal(a,ZERO())==1) 
      { 
        if((c.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    }
  /************************************************/
  /**************not all coefficients disappear**************/ 
  /************************************************/
  a=ca.y;
  b=cb.y;
  c=cc.y; 
  /*degenerate case: the the edge e projectivizes to an infinite ray*/
  if((equal(a,ZERO())==1) && (equal(b,ZERO())==1) &&(equal(c,ZERO())!=1))
     return(1);
  if((equal(c,ZERO())==1) && (equal(b,ZERO())==1) &&(equal(a,ZERO())!=1))
     return(1);

  /*typical cases: solve linear equation*/
  if(equal(c,ZERO())==1)  {t1=divide(b,a); t1=minus(ZERO(),t1);}
  if(equal(a,ZERO())==1)  {t1=divide(c,b); t1=minus(ZERO(),t1);}
  if(equal(t1,ZERO())==1) return(-1);
  if(t1.r<0) return(1);



  /*******************************/
  /*at this point t1 is positive*/
  /*******************************/
  a=ca.x;
  b=cb.x;
  c=cc.x; 
  if(equal(c,ZERO())==1) v1=plus(times(a,t1),b);
  if(equal(a,ZERO())==1) v1=plus(times(b,t1),c);
  if(equal(v1,ZERO())==1) return(-1);
  if(v1.l>0) return(2);
  return(1);
}



/* 1 indicates success -- that is, the arcs are disjoint
   excep[t if they share an endpoint. */

int edge_projection_test(e1,e2) 
     edge e1,e2;
{
  edge e;
  edge e3;
  int i,n[5],test;
  e=normal_position(e1,e2);
  n[1]=0;
  n[2]=0;
  n[3]=0;
  n[4]=0;
  if((equal(e.s[1][1],ZERO())==1)) n[1]=1;
  if((equal(e.s[1][2],ZERO())==1)) n[2]=1;
  if((equal(e.s[2][1],ZERO())==1)) n[3]=1;
  if((equal(e.s[2][2],ZERO())==1)) n[4]=1;

  if((n[1]==1)&&(n[2]==1)) return(-1);
  if((n[3]==1)&&(n[4]==1)) return(-1);
  if((n[1]==1)&&(n[4]==1)) return(4); /*both endpoints agree*/
  if((n[2]==1)&&(n[3]==1)) return(4); /*both endpoints agree*/

  if(n[1]+n[2]+n[3]+n[4]>0)
    {
    test=special_intersection_number(e1,e2);
    if(test==1) return(1);
    return(-1);
    }
  test=generic_intersection_number(e1,e2);
  if(test==0) return(1);
  return(-1);
}

