import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class CircularArc {
   Complex center;
   double radius;
    boolean line;
    Complex[] z=new Complex[5];
    double angle1,angle2;

    public CircularArc() {}


    public Path2D.Double toPath() {
	if(line==true) return toPathLine();
	return toPathArc();
    }
    
    public Path2D.Double toPathArc() {
	Path2D.Double p=new Path2D.Double();
	Arc2D.Double A=new Arc2D.Double(0,0,0,0,0,0,Arc2D.OPEN);
	A.x=center.x-radius;
	A.y=center.y-radius;
	A.height=2*radius;
	A.width=2*radius;
	A.start = angle1;
	A.extent = angle2-angle1;
	A.start=(180/Math.PI)*A.start;
	A.extent=(180/Math.PI)*A.extent;
	p.append(A,false);
	return p;
    }

    public Path2D.Double toPathLine() {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(z[1].x,z[1].y);
	p.lineTo(z[2].x,z[2].y);
	p.moveTo(z[3].x,z[3].y);
	p.lineTo(z[4].x,z[4].y);
	return p;
    }


    
    public void print() {
	System.out.print("center "); center.print();
	System.out.println("radius "+" "+radius);
	System.out.println("angle 1    "+angle1);
	System.out.println("angle 2    "+angle2);
	System.out.println("line "+line);
    }

    
/*first compute the denominator of the center of the
  circle containing the arc*/

	public static double denominator(Complex a,Complex b,Complex c) {
	    double x1=a.x;
	    double y1=a.y;
	    double x2=b.x;
	    double y2=b.y;
	    double x3=c.x;
	    double y3=c.y;
	    double s=0;
	    s=s+(x2*y1 + x3*y2 + x1*y3);
	    s=s-(y2*x1 + y3*x2 + y1*x3);
	    s=s*2;
	    return s;
	}


/*now compute the numerator of the first coordinate*/

	public static double x_numerator(Complex a,Complex b,Complex c) {
            double x1=a.x;
	    double y1=a.y;
	    double x2=b.x;
	    double y2=b.y;
	    double x3=c.x;
	    double y3=c.y;
	    double s=0;
	    s=s+(x2*x2*y1 + x3*x3*y2 + x1*x1*y3);
	    s=s-(x2*x2*y3 + x3*x3*y1 + x1*x1*y2);
	    s=s+(y2*y2*y1 + y3*y3*y2 + y1*y1*y3);
	    s=s-(y2*y2*y3 + y3*y3*y1 + y1*y1*y2);
	    return +s;
	}

	public static double y_numerator(Complex a,Complex b,Complex c) {
            double x1=a.x;
	    double y1=a.y;
	    double x2=b.x;
	    double y2=b.y;
	    double x3=c.x;
	    double y3=c.y;
	    double s=0;
	    s=s-(x2*x2*x3 + x3*x3*x1 + x1*x1*x2);
	    s=s+(x2*x2*x1 + x3*x3*x2 + x1*x1*x3);
	    s=s-(y2*y2*x3 + y3*y3*x1 + y1*y1*x2);
	    s=s+(y2*y2*x1 + y3*y3*x2 + y1*y1*x3);
	    return -s;
	}

/*now put together the previous three routines.*/

	public static Complex center(Complex a,Complex b,Complex c) {
	    Complex z=new Complex();
	    double K=denominator(a,b,c);
	    double J1=x_numerator(a,b,c);
	    double J2=y_numerator(a,b,c);
	    return new Complex(J1/K,J2/K);
	}




/*once we know the center of the circle it is
easy to find the radius.  After we get the radius
we have to figure out the endpoints of the arc.
We use basic trig to do this.  Our routine is
not perfect.  If the arc is too straight the
center is too big.  We give some cutoff value.
Beyond the cutoff value we replace the arc by
a straight line segment.  In case the arc goes
through (or near) infinity, we represent it by
2 disconnected segments.  You should picture an
arrow sticking off the end of one of the segments,
pointing at infinity.
We emphasize that these routines are used for
drawing purposes only.  The arbitrary cutoff
value does not find its way into our calculations.
*/


	public static CircularArc makeArc(Complex a,Complex b,Complex c) {
           double x1,x2,y1,y2,x3,y3;
           double a1,a2,a3;
           int test1,test2;
	   
	   CircularArc s=new CircularArc();

	   
	   x1=a.x;
	   y1=a.y;
	   x2=b.x;
	   y2=b.y;
	   x3=c.x;
	   y3=c.y; 
	   double den=denominator(a,b,c);
	   Complex cen=center(a,b,c);
	   s.center=new Complex(cen);
	   s.radius=Math.sqrt((cen.x-x1)*(cen.x-x1)+(cen.y-y1)*(cen.y-y1));

           a1=new_atan(x1-cen.x,-y1+cen.y);
           a2=new_atan(x2-cen.x,-y2+cen.y);
           a3=new_atan(x3-cen.x,-y3+cen.y);

           if(a1<=a3) {
	       if((a2>=a1)&&(a2<a3))  {s.angle1=a1;s.angle2=a3;}
               if(a2>=a3)        {s.angle1=a3;s.angle2=a1+2*Math.PI;}
               if(a2<=a1)        {s.angle1=a3;s.angle2=a1+2*Math.PI;}
	   }
	   
           if(a3<=a1) {
             if(a2>=a3&a2<=a1) {s.angle1=a3;s.angle2=a1;}
             if(a2<=a3)        {s.angle1=a1;s.angle2=a3+2*Math.PI;}
             if(a2>=a1)        {s.angle1=a1;s.angle2=a3+2*Math.PI;}
	   }
	   
           if((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)<.00001) {
             s.center=b;
             s.radius=0.0;
             s.angle1=0.0;
             s.angle2=0.0;
	   }
	   
           s.line=false;


	   /**This is where we draw line segments*/
	   if((Math.abs(den)<.0000001)||(Math.abs(cen.x)>10000000.0)||(Math.abs(cen.y)>10000000.0)) {
	       s.line=true;
	       double ab=Complex.dist(a,b);
	       double ac=Complex.dist(a,c);
	       double bc=Complex.dist(b,c);
	       
	       if((ac>=ab)&&(ac>=bc)) {
                 s.z[1]=new Complex(a);
                 s.z[2]=new Complex(b);
                 s.z[3]=new Complex(b);
                 s.z[4]=new Complex(c);
	       }

	       if((ab>=ac)&&(ab>=bc)) {
                 s.z[1]=new Complex(c);
		 s.z[2]=new Complex(10*b.x-9*c.x,10*b.y-9*c.y);
                 s.z[3]=new Complex(a);
		 s.z[4]=new Complex(10*a.x-9*c.x,10*a.y-9*c.y);
	       }

	       if((bc>=ac)&&(bc>=ab)) {
                 s.z[1]=new Complex(c);
		 s.z[2]=new Complex(10*b.x-9*c.x,10*b.y-9*c.y);
                 s.z[3]=new Complex(a);
		 s.z[4]=new Complex(10*b.x-9*c.x,10*b.y-9*c.y);
	       }
	   }
	   return s;
	}
	

	public static double new_atan(double x,double y) {
           double p;
           p=Math.atan2(y,x);
           if (p<0) p=p+2*Math.PI;
           return(p);
	}

}




