import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public static double dist(Complex z1,Complex z2) {
        return norm(minus(z1,z2));
    }

    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }
    
    public static Complex negative(Complex z) {
	Complex w=new Complex(-z.x,-z.y);
	return(w);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }

    public static double arg(Complex z) {
       double d=Math.atan2(z.y,z.x);
       if(z.y<0.0) d=d+2.0*Math.PI;
       return(d);
    }

    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

