import java.awt.event.*;
import java.awt.*;

public class ComplexVector {
    Complex a,b,c;
    Code X;

    public ComplexVector() {
	this.a=new Complex();
	this.b=new Complex();
	this.c=new Complex();
	this.X=new Code();
    }
    
    public ComplexVector(Complex a,Complex b,Complex c) {
	this.a=new Complex(a);
	this.b=new Complex(b);
	this.c=new Complex(c);
	this.X=new Code();
    }

    public ComplexVector(ComplexVector V) {
	this.a=new Complex(V.a);
	this.b=new Complex(V.b);
	this.c=new Complex(V.c);
	this.X=new Code();
	this.X.l=V.X.l;
	for(int i=0;i<10;++i) {
	    this.X.a[i]=V.X.a[i];
	    this.X.b[i]=V.X.b[i];
	    this.X.c[i]=V.X.c[i];
	}
    }

    public static Complex dot(ComplexVector V,ComplexVector W) {
	Complex A=Complex.times(V.a,W.a);
	Complex B=Complex.times(V.b,W.b);
	Complex C=Complex.times(V.c,W.c);
	Complex D=Complex.plus(A,B);
	D=Complex.plus(D,C);
	return D;
    }


    public static Complex hermitianDot(ComplexVector V,ComplexVector W) {
	Complex A=Complex.times(V.a,Complex.conjugate(W.a));
	Complex B=Complex.times(V.b,Complex.conjugate(W.b));
	Complex C=Complex.times(V.c,Complex.conjugate(W.c));
	Complex D=Complex.plus(A,B);
	D=Complex.minus(D,C);
	return D;
    }


/*Hermitian lorenz cross product on C3*/
    public static ComplexVector hermitianCross(ComplexVector v,ComplexVector w) {
	ComplexVector x=new ComplexVector();
	x.a=Complex.minus(Complex.times(v.b,w.c),Complex.times(v.c,w.b));
	x.b=Complex.minus(Complex.times(v.c,w.a),Complex.times(v.a,w.c));
	x.c=Complex.minus(Complex.times(v.b,w.a),Complex.times(v.a,w.b));
	x.a=Complex.conjugate(x.a);
	x.b=Complex.conjugate(x.b);
	x.c=Complex.conjugate(x.c);
	return(x);
    }


/*Hermitian lorenz cross product on C3*/
    public static ComplexVector cross(ComplexVector v,ComplexVector w) {
	ComplexVector x=new ComplexVector();
	x.a=Complex.minus(Complex.times(v.b,w.c),Complex.times(v.c,w.b));
	x.b=Complex.minus(Complex.times(v.c,w.a),Complex.times(v.a,w.c));
	x.c=Complex.minus(Complex.times(v.a,w.b),Complex.times(v.b,w.a));
	x.a=Complex.conjugate(x.a);
	x.b=Complex.conjugate(x.b);
	x.c=Complex.conjugate(x.c);
	return(x);
    }

    /*vector addition*/
    
    public static ComplexVector plus(ComplexVector V,ComplexVector W) {
	Complex A=Complex.plus(V.a,W.a);
	Complex B=Complex.plus(V.b,W.b);
	Complex C=Complex.plus(V.c,W.c);
	return new ComplexVector(A,B,C);
    }

    /*vector subtraction*/
    
    public static ComplexVector minus(ComplexVector V,ComplexVector W) {
	Complex A=Complex.minus(V.a,W.a);
	Complex B=Complex.minus(V.b,W.b);
	Complex C=Complex.minus(V.c,W.c);
	return new ComplexVector(A,B,C);
    }

    public static ComplexVector scale(Complex a,ComplexVector v) {
	ComplexVector w=new ComplexVector();
	w.a=Complex.times(a,v.a);
	w.b=Complex.times(a,v.b);
	w.c=Complex.times(a,v.c);
	return(w);
    }
    
    public static ComplexVector origin() {
	 Complex Z2=new Complex(0,0);
	return new ComplexVector(Z2,Z2,Z2);
    }
   	
    public static double dist(ComplexVector v,ComplexVector w) {
       double[] d=new double[5];
       d[1]=Complex.dist(v.a,w.a);
       d[2]=Complex.dist(v.b,w.b);
       d[3]=Complex.dist(v.c,w.c);
       d[4]=0;
       for(int i=1;i<=4;++i)  d[4]=d[4]+d[i]*d[i];
       d[4]=Math.sqrt(d[4]);
       return(d[4]);
    }

    public void print() {
	System.out.println("----------");
	a.print();
	b.print();
	c.print();
    }
    
}




