import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    SelectColor CS;
    ControlPanel TESTS,ZOOM,FILTER;
    ListenSquare GO,HALT;
    SelectInteger TILING_RANGE,SHADER;
    Lever DELAY;
    Tests TST;
    ControlPanelColor DISPLAY,TILING,TILING2;
    String[] MESSAGE=new String[5];
    PopupManager PM;
    

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,246,599,50);
	 TILING_RANGE=new SelectInteger(310,5,50,25,5,1,20,1);
	 SHADER=new SelectInteger(310,50,50,25,0,0,20,1);
	 DELAY=new Lever(10,230,0,25);
	 GO=new ListenSquare(125,200,30,20);
	 HALT=new ListenSquare(160,200,40,20);
         TST=new Tests();
	 setPanels();
	 PM=new PopupManager(this.M,400,80);
	 for(int i=0;i<5;++i) MESSAGE[i]="";
     }

    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};

	String[] DisplayString={"bg","tetra1","tetra2","halos","display"};
	int[] DisplayState={0,1,1,0};
	Color[] DisplayColor={Color.black,new Color(80,140,255),new Color(255,150,0),new Color(255,255,255,40)};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,4,DisplayColor);


	String[] TilingString={"8","9","10","11","12","13","14","15","16","outline1","outline2","tile colors"};
	int[] TilingState={0,0,0,0,0,0,0,0,0,0,0,0};
	Color[] TilingColor={
	    new Color(200,0,120),new Color(235,0,120),new Color(255,50,120),new Color(255,100,120),
	    new Color(0,0,200),new Color(0,0,255),new Color(50,100,255),
	    new Color(255,200,0),new Color(255,255,0),Color.black,Color.white};
        TILING=new ControlPanelColor(C0,TilingString,TilingState,11,TilingColor);




	
	String[] TestsString={"norms","purity","affine bounded","cutoff","injectivity+matching","tests"};
	int[] TestsState={1,0,0,0,0};
        TESTS=new ControlPanel(C0,TestsString,TestsState,5);
	TESTS.mode=0;
	
	String[] ZoomString={"no","yes","auto scaling"};
	int[] ZoomState={0,1};
        ZOOM=new ControlPanel(C0,ZoomString,ZoomState,2);
	ZOOM.mode=1;

	String[] FilterString={"0 common points","1 common point","2 common points","3 common points","injectivity test filter"};
	int[] FilterState={1,1,1,1};
        FILTER=new ControlPanel(C0,FilterString,FilterState,4);
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawMessage(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(155,0,200));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }


    
    public void drawControls(Graphics2D g) {
	CS.render(g);
	DISPLAY.render(g,0,0,90);
	TILING.render(g,215,0,85);
	TILING_RANGE.render(g,Color.blue,Color.white,Color.white);
	SHADER.render(g,Color.blue,Color.white,Color.white);
	TESTS.render(g,95,0,115);
	if(TESTS.mode==4) FILTER.render2(g,95,100,120);
	ZOOM.render(g,0,85,90);
	if(TST.HALT==true) GO.render(g,"go",12,2,new Color(0,170,0));
	if(TST.HALT==false) HALT.render(g,"stop",12,2,new Color(220,0,0));
	DELAY.render2(g,"test delay",Color.blue);
	PM.render(g);
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(Color.white);
	 g.setFont(new Font("Helvetica",Font.PLAIN,16));
	 for(int i=0;i<3;++i) g.drawString(MESSAGE[i],420,20+24*i);
    }

       public void doGo() {
	if(TST.HALT==false) return;
	TST=new Tests(this);
	new Thread(TST).start();
    }
    
    public void doHalt() {
	TST.HALT=true;
    }
    
    
    public void mouseClicked(MouseEvent e) {
	PM.M=this.M;
        CS.process(e); 
        MouseData J=MouseData.process(e);
	DISPLAY.process(J.X,CS.C);
	TILING.process(J.X,CS.C);
	TESTS.switchMode(J.X);
	ZOOM.switchMode(J.X);
	FILTER.toggle(J.X);
	DELAY.process(J.X);
	TILING_RANGE.modify(J.X);
	SHADER.modify(J.X);
	if(GO.inside(J.X)==1) doGo();
	if(HALT.inside(J.X)==1) doHalt();
	PM.process(J.X);
	M.repaint();
    }


    
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 

}

